/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils.cloud;

import com.aliyun.migration.api.exception.HealthCheckException;
import com.aliyun.migration.workflow.migration.common.bean.BwmJsonObject;
import com.aliyun.migration.workflow.migration.common.utils.cloud.AbstractCloudClient;
import com.aliyun.migration.workflow.migration.common.utils.cloud.STSCredentials;
import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DownloadFileRequest;
import com.aliyun.oss.model.DownloadFileResult;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.UploadFileRequest;
import com.aliyun.oss.model.UploadFileResult;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.auth.sts.AssumeRoleRequest;
import com.aliyuncs.auth.sts.AssumeRoleResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssCloudClient
extends AbstractCloudClient {
    private static final Logger log = LoggerFactory.getLogger(OssCloudClient.class);
    private OSS ossClient;
    private final String endpoint;
    private final String accessKey;
    private final String accessSecret;

    public OssCloudClient(String endpoint, String accessKey, String accessSecret) throws HealthCheckException {
        this(endpoint, accessKey, accessSecret, null, null);
    }

    public OssCloudClient(String endpoint, String accessKey, String accessSecret, String securityToken) throws HealthCheckException {
        this(endpoint, accessKey, accessSecret, null, securityToken);
    }

    public OssCloudClient(String endpoint, String accessKey, String accessSecret, Long connectTimeout, String securityToken) throws HealthCheckException {
        if (StringUtils.isEmpty((CharSequence)accessKey)) {
            accessKey = System.getenv("LHM_DW_AK");
        }
        if (StringUtils.isEmpty((CharSequence)accessSecret)) {
            accessSecret = System.getenv("LHM_DW_SK");
        }
        if (connectTimeout != null) {
            ClientBuilderConfiguration config = new ClientBuilderConfiguration();
            config.setConnectionTimeout(connectTimeout.intValue());
            config.setConnectionRequestTimeout(connectTimeout.intValue());
            config.setSocketTimeout(connectTimeout.intValue());
            config.setRequestTimeout(connectTimeout.intValue());
            config.setMaxErrorRetry(0);
            this.ossClient = new OSSClientBuilder().build(endpoint, accessKey, accessSecret, config);
        } else {
            this.ossClient = !StringUtils.isEmpty((CharSequence)securityToken) ? new OSSClientBuilder().build(endpoint, accessKey, accessSecret, securityToken) : new OSSClientBuilder().build(endpoint, accessKey, accessSecret);
        }
        this.endpoint = endpoint.replace("http://", "").replace("https://", "");
        this.accessKey = accessKey;
        this.accessSecret = accessSecret;
    }

    @Override
    public void uploadAndMergeFolder(String bucketName, String objectName, String fileName) {
        String ossRootPath = objectName;
        String localRootPath = fileName;
        if (StringUtils.isEmpty((CharSequence)localRootPath) || !new File(localRootPath).exists()) {
            return;
        }
        if (new File(localRootPath).isFile()) {
            log.info("local file {} upload to oss: {}", (Object)fileName, (Object)objectName);
            this.uploadFile(bucketName, objectName, fileName);
        } else if (new File(localRootPath).isDirectory()) {
            List files = FileUtils.listFiles((File)new File(localRootPath), null, (boolean)true).stream().toList();
            for (File file : files) {
                log.info("local file {} upload to oss: {}", (Object)file.getAbsolutePath().substring(ossRootPath.length()));
                this.uploadFile(bucketName, ossRootPath + file.getAbsolutePath().substring(localRootPath.length()), file.getAbsolutePath());
            }
        }
    }

    @Override
    public void uploadFile(String bucketName, String objectName, String fileName) {
        try {
            UploadFileRequest uploadFileRequest = new UploadFileRequest(bucketName, objectName);
            uploadFileRequest.setUploadFile(fileName);
            uploadFileRequest.setTaskNum(5);
            uploadFileRequest.setPartSize(0x100000L);
            uploadFileRequest.setEnableCheckpoint(true);
            UploadFileResult uploadFileResult = this.ossClient.uploadFile(uploadFileRequest);
        }
        catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            log.error("Error Message:    " + oe.getErrorCode());
            log.error("Error Code:       " + oe.getErrorCode());
            log.error("Request ID:       " + oe.getRequestId());
            log.error("Host ID:          " + oe.getHostId());
        }
        catch (com.aliyun.oss.ClientException ce) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
            log.error("Error Message: " + ce.getMessage(), (Throwable)ce);
        }
        catch (Throwable e) {
            log.error("Error Message: " + e.getMessage(), e);
        }
    }

    @Override
    public void createFile(String bucketName, String objectName, String content) {
        try {
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, objectName, (InputStream)new ByteArrayInputStream(content.getBytes()));
            PutObjectResult putObjectResult = this.ossClient.putObject(putObjectRequest);
        }
        catch (OSSException oe) {
            System.out.println("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            System.out.println("Error Message:" + oe.getErrorMessage());
            System.out.println("Error Code:" + oe.getErrorCode());
            System.out.println("Request ID:" + oe.getRequestId());
            System.out.println("Host ID:" + oe.getHostId());
        }
        catch (com.aliyun.oss.ClientException ce) {
            System.out.println("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
            System.out.println("Error Message:" + ce.getMessage());
        }
    }

    @Override
    public void downloadFile(String bucketName, String objectName, String downloadFile) {
        try {
            DownloadFileRequest downloadFileRequest = new DownloadFileRequest(bucketName, objectName);
            downloadFileRequest.setDownloadFile(downloadFile);
            downloadFileRequest.setTaskNum(5);
            downloadFileRequest.setPartSize(0x100000L);
            downloadFileRequest.setEnableCheckpoint(true);
            DownloadFileResult downloadResult = this.ossClient.downloadFile(downloadFileRequest);
            ObjectMetadata objectMetadata = downloadResult.getObjectMetadata();
            log.info(objectMetadata.getETag());
            log.info((String)objectMetadata.getUserMetadata().get("meta"));
        }
        catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            log.error("Error Message:    " + oe.getErrorCode());
            log.error("Error Code:       " + oe.getErrorCode());
            log.error("Request ID:       " + oe.getRequestId());
            log.error("Host ID:          " + oe.getHostId());
        }
        catch (com.aliyun.oss.ClientException ce) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
            log.error("Error Message: " + ce.getMessage(), (Throwable)ce);
        }
        catch (Throwable e) {
            log.error("Error Message: " + e.getMessage(), e);
        }
    }

    @Override
    public void healthCheck() throws HealthCheckException {
        if (this.ossClient == null) {
            throw new HealthCheckException();
        }
        try {
            this.ossClient.doesBucketExist("test");
        }
        catch (Exception e) {
            throw new HealthCheckException();
        }
    }

    private void checkBucket(String bucketName) throws OSSException, com.aliyun.oss.ClientException {
        if (this.ossClient != null) {
            if (this.ossClient.doesBucketExist(bucketName)) {
                log.info("Bucket already exists.");
            } else {
                this.ossClient.createBucket(bucketName);
                try {
                    this.ossClient.setBucketAcl(bucketName, CannedAccessControlList.PublicReadWrite);
                }
                catch (Exception e) {
                    log.info("\u8be5bucket\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u516c\u5f00\uff0c\u5206\u4eab\u6587\u4ef6\u5730\u5740\u4f1a\u8fc7\u671f\u5931\u6548\uff01e:", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void release() {
        if (this.ossClient != null) {
            this.ossClient.shutdown();
        }
    }

    @Override
    public void uploadFile(final String bucketName, final String objectName, final InputStream inputStream, String contentType) {
        try {
            this.checkBucket(bucketName);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    OssCloudClient.this.uploadProgress(bucketName, objectName, inputStream);
                }
            });
            t.start();
            this.ossClient.putObject(new PutObjectRequest(bucketName, objectName, inputStream));
        }
        catch (Exception e) {
            log.error("Error Message: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public InputStream downloadFile(String bucketName, String objectName) {
        try {
            GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, objectName);
            OSSObject oSSObject = this.ossClient.getObject(getObjectRequest);
            if (oSSObject != null) {
                return oSSObject.getObjectContent();
            }
        }
        catch (Exception e) {
            log.error("Error Message: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public String getFileUrl(String bucketName, String objectName) {
        URL url = this.ossClient.generatePresignedUrl(bucketName, objectName, new Date());
        if (url != null) {
            return url.toString().substring(0, url.toString().indexOf("?"));
        }
        return null;
    }

    @Override
    public void statObject(String bucketName, String objectName) throws Exception {
        this.ossClient.getObjectMetadata(bucketName, objectName);
    }

    @Override
    public void deleteFile(String bucketName, List<String> objectNames) {
        try {
            DeleteObjectsRequest request = new DeleteObjectsRequest(bucketName);
            request.setKeys(objectNames);
            request.setQuiet(true);
            this.ossClient.deleteObjects(request);
        }
        catch (Exception e) {
            log.error("Error Message: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void getSignature(HttpServletRequest request, HttpServletResponse response, String bucketName, String callbackUrl, String prefix, Long expireSecond) throws ServletException, IOException {
        this.getSignature(request, response, bucketName, callbackUrl, prefix, expireSecond, 1048576000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeGet(String url) {
        BufferedReader in = null;
        String content = null;
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            HttpGet request = new HttpGet();
            request.setURI(new URI(url));
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            in.close();
            content = sb.toString();
            return content;
        }
        catch (Exception e) {}
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return content;
        }
    }

    private String GetPostBody(InputStream is, int contentLen) {
        if (contentLen > 0) {
            int readLengthThisTime = 0;
            byte[] message = new byte[contentLen];
            try {
                for (int readLen = 0; readLen != contentLen && (readLengthThisTime = is.read(message, readLen, contentLen - readLen)) != -1; readLen += readLengthThisTime) {
                }
                return new String(message);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "";
    }

    private boolean VerifyOSSCallbackRequest(HttpServletRequest request, String ossCallbackBody) throws NumberFormatException, IOException {
        boolean ret = false;
        String autorizationInput = new String(request.getHeader("Authorization"));
        String pubKeyInput = request.getHeader("x-oss-pub-key-url");
        byte[] authorization = BinaryUtil.fromBase64String((String)autorizationInput);
        byte[] pubKey = BinaryUtil.fromBase64String((String)pubKeyInput);
        String pubKeyAddr = new String(pubKey);
        if (!pubKeyAddr.startsWith("http://gosspublic.alicdn.com/") && !pubKeyAddr.startsWith("https://gosspublic.alicdn.com/")) {
            log.error("pub key addr must be oss addrss");
            return false;
        }
        String retString = this.executeGet(pubKeyAddr);
        retString = retString.replace("-----BEGIN PUBLIC KEY-----", "");
        retString = retString.replace("-----END PUBLIC KEY-----", "");
        String queryString = request.getQueryString();
        String uri = request.getRequestURI();
        String decodeUri = URLDecoder.decode(uri, "UTF-8");
        Object authStr = decodeUri;
        if (queryString != null && !queryString.equals("")) {
            authStr = (String)authStr + "?" + queryString;
        }
        authStr = (String)authStr + "\n" + ossCallbackBody;
        ret = OssCloudClient.doCheck((String)authStr, authorization, retString);
        return ret;
    }

    @Override
    public void verifySignature(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String ossCallbackBody = this.GetPostBody((InputStream)request.getInputStream(), Integer.parseInt(request.getHeader("content-length")));
        boolean ret = this.VerifyOSSCallbackRequest(request, ossCallbackBody);
        if (ret) {
            this.response(request, response, "{\"Status\":\"OK\"}", 200);
        } else {
            this.response(request, response, "{\"Status\":\"verify not ok\"}", 400);
        }
    }

    private static boolean doCheck(String content, byte[] sign, String publicKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            byte[] encodedKey = BinaryUtil.fromBase64String((String)publicKey);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initVerify(pubKey);
            signature.update(content.getBytes());
            boolean bverify = signature.verify(sign);
            return bverify;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void response(HttpServletRequest request, HttpServletResponse response, String results, int status) throws IOException {
        String callbackFunName = request.getParameter("callback");
        response.addHeader("Content-Length", String.valueOf(results.length()));
        if (callbackFunName == null || callbackFunName.equalsIgnoreCase("")) {
            response.getWriter().println(results);
        } else {
            response.getWriter().println(callbackFunName + "( " + results + " )");
        }
        response.setStatus(status);
        response.flushBuffer();
    }

    private void response(HttpServletRequest request, HttpServletResponse response, String results) throws IOException {
        String callbackFunName = request.getParameter("callback");
        if (callbackFunName == null || callbackFunName.equalsIgnoreCase("")) {
            response.getWriter().println(results);
        } else {
            response.getWriter().println(callbackFunName + "( " + results + " )");
        }
        response.setStatus(200);
        response.flushBuffer();
    }

    @Override
    public void getSignature(HttpServletRequest request, HttpServletResponse response, String bucketName, String callbackUrl, String prefix, Long expireSecond, Long fileSize) throws ServletException, IOException {
        String host = "http://" + bucketName + "." + this.endpoint;
        try {
            long expireTime = expireSecond;
            long expireEndTime = System.currentTimeMillis() + expireTime * 1000L;
            Date expiration = new Date(expireEndTime);
            PolicyConditions policyConds = new PolicyConditions();
            policyConds.addConditionItem("content-length-range", 0L, fileSize == null ? 1048576000L : fileSize);
            policyConds.addConditionItem(MatchMode.StartWith, "key", prefix);
            String postPolicy = this.ossClient.generatePostPolicy(expiration, policyConds);
            byte[] binaryData = postPolicy.getBytes("utf-8");
            String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
            String postSignature = this.ossClient.calculatePostSignature(postPolicy);
            BwmJsonObject respMap = new BwmJsonObject();
            respMap.put("accessid", this.accessKey);
            respMap.put("policy", encodedPolicy);
            respMap.put("signature", postSignature);
            respMap.put("dir", prefix);
            respMap.put("host", host);
            respMap.put("expire", String.valueOf(expireEndTime / 1000L));
            if (StringUtils.isNotEmpty((CharSequence)callbackUrl)) {
                BwmJsonObject jasonCallback = new BwmJsonObject();
                jasonCallback.put("callbackUrl", callbackUrl);
                jasonCallback.put("callbackBody", "filename=${object}&size=${size}&mimeType=${mimeType}&height=${imageInfo.height}&width=${imageInfo.width}");
                jasonCallback.put("callbackBodyType", "application/x-www-form-urlencoded");
                String base64CallbackBody = BinaryUtil.toBase64String((byte[])jasonCallback.toString().getBytes());
                respMap.put("callback", base64CallbackBody);
            }
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Access-Control-Allow-Methods", "GET, POST");
            this.response(request, response, respMap.toString());
        }
        catch (Exception e) {
            log.error("Error Message: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void uploadFileWithException(final String bucketName, final String objectName, final InputStream inputStream, String contentType) throws Exception {
        this.checkBucket(bucketName);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                OssCloudClient.this.uploadProgress(bucketName, objectName, inputStream);
            }
        });
        t.start();
        this.ossClient.putObject(new PutObjectRequest(bucketName, objectName, inputStream));
    }

    @Override
    public STSCredentials getSTSCredentials(String roleArn, String roleSessionName, String policy, Long expireSecond) {
        String stsEndpoint = "sts.aliyuncs.com";
        if (StringUtils.isEmpty((CharSequence)policy)) {
            policy = "{\n    \"Version\": \"1\", \n    \"Statement\": [\n        {\n            \"Action\": [\n                \"oss:*\"\n            ], \n            \"Resource\": [\n                \"acs:oss:*:*:*\" \n            ], \n            \"Effect\": \"Allow\"\n        }\n    ]\n}";
        }
        try {
            DefaultProfile.addEndpoint((String)"", (String)"", (String)"Sts", (String)"sts.aliyuncs.com");
            DefaultProfile profile = DefaultProfile.getProfile((String)"", (String)this.accessKey, (String)this.accessSecret);
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            AssumeRoleRequest request = new AssumeRoleRequest();
            request.setMethod(MethodType.POST);
            request.setRoleArn(roleArn);
            request.setRoleSessionName(roleSessionName);
            request.setPolicy(policy);
            if (expireSecond == null || expireSecond < 900L || expireSecond > 3600L) {
                request.setDurationSeconds(Long.valueOf(1000L));
            } else {
                request.setDurationSeconds(expireSecond);
            }
            AssumeRoleResponse response = (AssumeRoleResponse)client.getAcsResponse((AcsRequest)request);
            if (response != null) {
                return STSCredentials.of(response.getCredentials(), response.getRequestId());
            }
        }
        catch (ClientException e) {
            log.error("Failed\uff1aerror" + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public String getTempFileUrl(String bucketName, String objectName, Long expireTime) {
        URL url = this.ossClient.generatePresignedUrl(bucketName, objectName, new Date(System.currentTimeMillis() + (expireTime == null || expireTime < 0L ? 3600000L : expireTime)));
        if (url != null) {
            return url.toString();
        }
        return null;
    }

    public List<Bucket> listBuckets() {
        return this.ossClient.listBuckets();
    }

    public static String getEndpointFromRegion(String region) {
        if (StringUtils.isEmpty((CharSequence)region)) {
            return "oss-cn-hangzhou.aliyuncs.com";
        }
        return "oss-" + region + ".aliyuncs.com";
    }
}

