/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils;

import com.aliyun.migration.workflow.migration.common.bean.BwmNode;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeHelper {
    private static final Logger log = LoggerFactory.getLogger(NodeHelper.class);
    private static final CopyOnWriteArraySet<String> gloableNodeNameSet = new CopyOnWriteArraySet();
    private static AtomicInteger suffixNameCounter = new AtomicInteger(0);

    public static <T extends BwmNode> void supplyNodes(List<T> nodes) {
        for (BwmNode node : nodes) {
            String displayName = node.getDisplayName();
            if (!gloableNodeNameSet.contains(displayName)) {
                gloableNodeNameSet.add(displayName);
                continue;
            }
            String afterName = displayName + "_" + suffixNameCounter.getAndIncrement();
            node.setDisplayName(afterName);
            log.warn("\u8282\u70b9\u540d\u79f0\u91cd\u590d\uff0c\u52a8\u6001\u4fee\u6539\u524d {} \uff0c\u4fee\u6539\u540e {} ", (Object)displayName, (Object)afterName);
        }
    }

    public void clear() {
        gloableNodeNameSet.clear();
        suffixNameCounter.getAndSet(0);
    }
}

