/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    public static JSONObject sendGet(String urlString) throws Exception {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        try {
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String inputLine;
                    StringBuilder response = new StringBuilder();
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                    JSONObject jSONObject = JSON.parseObject((String)response.toString());
                    return jSONObject;
                }
            }
            throw new Exception("GET request failed with response code: " + responseCode);
        }
        finally {
            connection.disconnect();
        }
    }

    public static byte[] inputStreamToByteArray(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    public static JSONObject sendPost(String urlString, String jsonInputString) throws Exception {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json; utf-8");
        connection.setRequestProperty("Accept", "application/json");
        connection.setDoOutput(true);
        try (OutputStream os = connection.getOutputStream();){
            byte[] input = jsonInputString.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
        try {
            int responseCode = connection.getResponseCode();
            if (responseCode == 200 || responseCode == 201) {
                try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                    String responseLine;
                    StringBuilder response = new StringBuilder();
                    while ((responseLine = br.readLine()) != null) {
                        response.append(responseLine.trim());
                    }
                    JSONObject jSONObject = JSON.parseObject((String)response.toString());
                    return jSONObject;
                }
            }
            throw new Exception("POST request failed with response code: " + responseCode);
        }
        finally {
            connection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadUrlToTempFile(String downloadUrl, String fileName, String fileSuffix) throws IOException {
        log.info("\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6\uff0cURL: {}", (Object)downloadUrl);
        Path tempPath = Files.createTempFile(fileName, fileSuffix, new FileAttribute[0]);
        File tempFile = tempPath.toFile();
        log.debug("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6: {}", (Object)tempFile.getAbsolutePath());
        try {
            URL url = new URL(downloadUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(60000);
            try (InputStream in = connection.getInputStream();){
                long bytesCopied = Files.copy(in, tempPath, StandardCopyOption.REPLACE_EXISTING);
                log.info("\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f\uff0cURL: {}, \u4e34\u65f6\u6587\u4ef6\u8def\u5f84: {}, \u6587\u4ef6\u5927\u5c0f: {} bytes", new Object[]{downloadUrl, tempFile.getAbsolutePath(), bytesCopied});
            }
            finally {
                connection.disconnect();
            }
        }
        catch (IOException e) {
            try {
                Files.deleteIfExists(tempPath);
                log.warn("\u4e0b\u8f7d\u5931\u8d25\uff0c\u5df2\u6e05\u7406\u4e34\u65f6\u6587\u4ef6: {}", (Object)tempPath);
            }
            catch (IOException deleteException) {
                log.warn("\u4e0b\u8f7d\u5931\u8d25\u4e14\u65e0\u6cd5\u6e05\u7406\u4e34\u65f6\u6587\u4ef6: {}", (Object)tempPath, (Object)deleteException);
            }
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0cURL: {}", (Object)downloadUrl, (Object)e);
            throw new IOException("Failed to download file from URL: " + downloadUrl, e);
        }
        return tempFile;
    }
}

