/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks_public20200518.Client;
import com.aliyun.dataworks_public20200518.models.CreateDIJobRequest;
import com.aliyun.dataworks_public20200518.models.CreateDIJobResponse;
import com.aliyun.dataworks_public20200518.models.CreateResourceFileAdvanceRequest;
import com.aliyun.dataworks_public20200518.models.CreateResourceFileResponse;
import com.aliyun.dataworks_public20200518.models.CreateUdfFileRequest;
import com.aliyun.dataworks_public20200518.models.CreateUdfFileResponse;
import com.aliyun.dataworks_public20200518.models.DeleteBusinessRequest;
import com.aliyun.dataworks_public20200518.models.DeleteDIJobRequest;
import com.aliyun.dataworks_public20200518.models.DeleteDIJobResponse;
import com.aliyun.dataworks_public20200518.models.DeleteFileRequest;
import com.aliyun.dataworks_public20200518.models.GetBusinessRequest;
import com.aliyun.dataworks_public20200518.models.GetBusinessResponse;
import com.aliyun.dataworks_public20200518.models.GetDIJobRequest;
import com.aliyun.dataworks_public20200518.models.GetDIJobResponseBody;
import com.aliyun.dataworks_public20200518.models.GetFileRequest;
import com.aliyun.dataworks_public20200518.models.GetFileResponse;
import com.aliyun.dataworks_public20200518.models.GetFolderRequest;
import com.aliyun.dataworks_public20200518.models.GetFolderResponse;
import com.aliyun.dataworks_public20200518.models.GetProjectRequest;
import com.aliyun.dataworks_public20200518.models.GetProjectResponse;
import com.aliyun.dataworks_public20200518.models.ListBusinessRequest;
import com.aliyun.dataworks_public20200518.models.ListBusinessResponse;
import com.aliyun.dataworks_public20200518.models.ListBusinessResponseBody;
import com.aliyun.dataworks_public20200518.models.ListCalcEnginesRequest;
import com.aliyun.dataworks_public20200518.models.ListCalcEnginesResponse;
import com.aliyun.dataworks_public20200518.models.ListCalcEnginesResponseBody;
import com.aliyun.dataworks_public20200518.models.ListDIJobsRequest;
import com.aliyun.dataworks_public20200518.models.ListDIJobsResponse;
import com.aliyun.dataworks_public20200518.models.ListDIJobsResponseBody;
import com.aliyun.dataworks_public20200518.models.ListDataSourcesRequest;
import com.aliyun.dataworks_public20200518.models.ListDataSourcesResponse;
import com.aliyun.dataworks_public20200518.models.ListDataSourcesResponseBody;
import com.aliyun.dataworks_public20200518.models.ListFilesRequest;
import com.aliyun.dataworks_public20200518.models.ListFilesResponse;
import com.aliyun.dataworks_public20200518.models.ListFilesResponseBody;
import com.aliyun.dataworks_public20200518.models.ListFoldersRequest;
import com.aliyun.dataworks_public20200518.models.ListFoldersResponse;
import com.aliyun.dataworks_public20200518.models.ListFoldersResponseBody;
import com.aliyun.dataworks_public20200518.models.ListProjectsRequest;
import com.aliyun.dataworks_public20200518.models.ListProjectsResponse;
import com.aliyun.dataworks_public20200518.models.ListProjectsResponseBody;
import com.aliyun.dataworks_public20200518.models.ListResourceGroupsRequest;
import com.aliyun.dataworks_public20200518.models.ListResourceGroupsResponse;
import com.aliyun.dataworks_public20200518.models.ListResourceGroupsResponseBody;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.workflow.migration.common.utils.CustomCreateFileRequest;
import com.aliyun.migration.workflow.migration.common.utils.CustomCreateFileResponse;
import com.aliyun.migration.workflow.migration.common.utils.DwClientRuntimeOption;
import com.aliyun.migration.workflow.migration.common.utils.PageUtil;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teaopenapi.models.OpenApiRequest;
import com.aliyun.teaopenapi.models.Params;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import com.cronutils.utils.StringUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwClient {
    private static final Logger log = LoggerFactory.getLogger(DwClient.class);
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private Client client = null;
    private String ossPath = "";
    private String endpoint = "";
    private Long requestTimesCount = 0L;
    public RuntimeOptions runtime;
    private static Long parseTimeMilliseconds = 200L;
    public static Map<Integer, Integer> nodeTypeIdMapShenzhen = ImmutableMap.builder().put((Object)1317, (Object)-1).put((Object)1316, (Object)1000025).put((Object)1315, (Object)10017).put((Object)1308, (Object)10008).put((Object)1307, (Object)10005).put((Object)1309, (Object)10009).put((Object)1303, (Object)1000039).put((Object)1314, (Object)10016).put((Object)1305, (Object)10002).put((Object)1302, (Object)10003).put((Object)1311, (Object)10011).put((Object)1312, (Object)-1).put((Object)1310, (Object)10010).put((Object)1304, (Object)10001).put((Object)1306, (Object)10004).put((Object)1313, (Object)10013).put((Object)-1, (Object)10014).put((Object)-2, (Object)-1).put((Object)-3, (Object)10015).put((Object)-4, (Object)10006).put((Object)-5, (Object)10007).build();
    public static Map<Integer, Integer> nodeTypeIdMapHangzhou = ImmutableMap.builder().put((Object)1317, (Object)-1).put((Object)1316, (Object)1000024).put((Object)1315, (Object)10017).put((Object)1308, (Object)10008).put((Object)1307, (Object)10005).put((Object)1309, (Object)10009).put((Object)1303, (Object)1000039).put((Object)1314, (Object)10016).put((Object)1305, (Object)10002).put((Object)1302, (Object)10003).put((Object)1311, (Object)10011).put((Object)1312, (Object)-1).put((Object)1310, (Object)10010).put((Object)1304, (Object)10001).put((Object)1306, (Object)10004).put((Object)1313, (Object)10013).put((Object)-1, (Object)10014).put((Object)-2, (Object)-1).put((Object)-3, (Object)10015).put((Object)-4, (Object)10006).put((Object)-5, (Object)10007).build();

    public Long getRequestTimesCount() {
        return this.requestTimesCount;
    }

    public DwClient(String endpoint, String accessKeyId, String accessKeySecret) {
        this.init(endpoint, accessKeyId, accessKeySecret);
        this.endpoint = endpoint;
    }

    public DwClient(String endpoint, String accessKeyId, String accessKeySecret, String ossPath) {
        this.init(endpoint, accessKeyId, accessKeySecret, ossPath);
        this.endpoint = endpoint;
    }

    public void init(String endpoint, String accessKeyId, String accessKeySecret) {
        try {
            endpoint = this.validataDwEndpoint(endpoint);
            this.client = this.createClient(endpoint, accessKeyId, accessKeySecret);
            this.runtime = new DwClientRuntimeOption().getRuntime();
        }
        catch (Exception e) {
            log.error("init client failed: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void init(String endpoint, String accessKeyId, String accessKeySecret, Long parseTimeMilliseconds) {
        try {
            endpoint = this.validataDwEndpoint(endpoint);
            this.client = this.createClient(endpoint, accessKeyId, accessKeySecret);
            this.runtime = new DwClientRuntimeOption().getRuntime();
            DwClient.parseTimeMilliseconds = parseTimeMilliseconds;
        }
        catch (Exception e) {
            log.error("init client failed: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String validataDwEndpoint(String endpoint) {
        if (StringUtils.isEmpty((CharSequence)endpoint)) {
            return endpoint;
        }
        if (endpoint.startsWith(HTTP_PREFIX)) {
            return endpoint.replace(HTTP_PREFIX, "");
        }
        if (endpoint.startsWith(HTTPS_PREFIX)) {
            return endpoint.replace(HTTPS_PREFIX, "");
        }
        return endpoint;
    }

    public void init(String endpoint, String accessKeyId, String accessKeySecret, String ossPath) {
        try {
            endpoint = this.validataDwEndpoint(endpoint);
            this.client = this.createClient(endpoint, accessKeyId, accessKeySecret);
            this.ossPath = ossPath;
        }
        catch (Exception e) {
            log.error("init client failed: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Client createClient(String endpoint, String accessKeyId, String accessKeySecret) throws Exception {
        Config config = new Config().setAccessKeyId(accessKeyId).setAccessKeySecret(accessKeySecret);
        config.endpoint = endpoint;
        return new Client(config);
    }

    public ListProjectsResponseBody.ListProjectsResponseBodyPageResult listProjectsWithOptions(Integer pageSize, Integer pageNumber) {
        ListProjectsRequest listProjectsRequest = new ListProjectsRequest().setPageNumber(pageNumber).setPageSize(pageSize);
        try {
            Long l = this.requestTimesCount;
            this.requestTimesCount = this.requestTimesCount + 1L;
            DwClient.pauseForAMount();
            ListProjectsResponse listProjectsResponse = this.client.listProjectsWithOptions(listProjectsRequest, this.runtime);
            return listProjectsResponse.body.pageResult;
        }
        catch (TeaException error) {
            log.info(error.getMessage());
            log.info(error.getData().get("Recommend").toString());
            Common.assertAsString((Object)error.message);
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            log.info(error.getMessage());
            log.info(error.getData().get("Recommend").toString());
            Common.assertAsString((Object)error.message);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.LIST_DW_PROJECT_ERROR);
        }
        return null;
    }

    public ListCalcEnginesResponseBody.ListCalcEnginesResponseBodyData listCalcEnginesWithOptions(Long projectId, String calcEngineType, Integer pageSize, Integer pageNumber) {
        ListCalcEnginesRequest listCalcEnginesRequest = new ListCalcEnginesRequest().setProjectId(projectId).setCalcEngineType(calcEngineType).setPageSize(pageSize).setPageNumber(pageNumber);
        try {
            Long l = this.requestTimesCount;
            this.requestTimesCount = this.requestTimesCount + 1L;
            DwClient.pauseForAMount();
            ListCalcEnginesResponse listCalcEnginesResponse = this.client.listCalcEnginesWithOptions(listCalcEnginesRequest, this.runtime);
            return listCalcEnginesResponse.body.data;
        }
        catch (TeaException error) {
            log.info(error.getMessage());
            log.info(error.getData().get("Recommend").toString());
            Common.assertAsString((Object)error.message);
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            log.info(error.getMessage());
            log.info(error.getData().get("Recommend").toString());
            Common.assertAsString((Object)error.message);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.LIST_DW_CALC_ENGINE_ERROR);
        }
        return null;
    }

    public List<ListResourceGroupsResponseBody.ListResourceGroupsResponseBodyData> listResourceGroupsWithOptions(Integer groupType) {
        ListResourceGroupsRequest listResourceGroupsRequest = new ListResourceGroupsRequest().setResourceGroupType(groupType).setBizExtKey("single");
        try {
            Long l = this.requestTimesCount;
            this.requestTimesCount = this.requestTimesCount + 1L;
            DwClient.pauseForAMount();
            ListResourceGroupsResponse listResourceGroupsResponse = this.client.listResourceGroupsWithOptions(listResourceGroupsRequest, this.runtime);
            return listResourceGroupsResponse.body.data;
        }
        catch (TeaException error) {
            log.info(error.getMessage());
            log.info(error.getData().get("Recommend").toString());
            Common.assertAsString((Object)error.message);
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            log.info(error.getMessage());
            log.info(error.getData().get("Recommend").toString());
            Common.assertAsString((Object)error.message);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.LIST_DW_RESOURCE_ERROR);
        }
        return Lists.newArrayList();
    }

    public GetBusinessResponse getBusiness(Long projectId, Long businessId) {
        GetBusinessRequest getBusinessRequest = new GetBusinessRequest();
        getBusinessRequest.setProjectId(projectId);
        getBusinessRequest.setBusinessId(businessId);
        try {
            Long l = this.requestTimesCount;
            this.requestTimesCount = this.requestTimesCount + 1L;
            DwClient.pauseForAMount();
            GetBusinessResponse response = this.client.getBusinessWithOptions(getBusinessRequest, this.runtime);
            return response;
        }
        catch (TeaException error) {
            log.info(error.getMessage());
            log.info(error.getData().get("Recommend").toString());
            Common.assertAsString((Object)error.message);
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            log.info(error.getMessage());
            log.info(error.getData().get("Recommend").toString());
            Common.assertAsString((Object)error.message);
        }
        return null;
    }

    public List<ListBusinessResponseBody.ListBusinessResponseBodyDataBusiness> searchBusiness(Long projectId, String businessName) {
        ListBusinessRequest listBusinessRequest = new ListBusinessRequest();
        listBusinessRequest.setProjectId(projectId);
        listBusinessRequest.setPageNumber(Integer.valueOf(1));
        listBusinessRequest.setPageSize(Integer.valueOf(100));
        listBusinessRequest.setKeyword(businessName);
        try {
            Long l = this.requestTimesCount;
            this.requestTimesCount = this.requestTimesCount + 1L;
            DwClient.pauseForAMount();
            ListBusinessResponse listBusinessResponse = this.client.listBusinessWithOptions(listBusinessRequest, this.runtime);
            ListBusinessResponseBody.ListBusinessResponseBodyData data = listBusinessResponse.getBody().getData();
            List business = data.getBusiness();
            return business;
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            log.error(error.getMessage());
            log.error(error.getData().get("Recommend").toString());
            Common.assertAsString((Object)error.message);
            return null;
        }
    }

    public List<ListBusinessResponseBody.ListBusinessResponseBodyDataBusiness> getAllBusiness(Long projectId) {
        ListBusinessRequest listBusinessRequest = new ListBusinessRequest();
        listBusinessRequest.setProjectId(projectId);
        listBusinessRequest.setPageNumber(Integer.valueOf(1));
        listBusinessRequest.setPageSize(Integer.valueOf(100));
        try {
            Long l = this.requestTimesCount;
            this.requestTimesCount = this.requestTimesCount + 1L;
            DwClient.pauseForAMount();
            ListBusinessResponse listBusinessResponse = this.client.listBusinessWithOptions(listBusinessRequest, this.runtime);
            ListBusinessResponseBody.ListBusinessResponseBodyData data = listBusinessResponse.getBody().getData();
            List business = data.getBusiness();
            return business;
        }
        catch (TeaException error) {
            log.info(error.getMessage());
            log.info(error.getData().get("Recommend").toString());
            Common.assertAsString((Object)error.message);
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            log.info(error.getMessage());
            log.info(error.getData().get("Recommend").toString());
            Common.assertAsString((Object)error.message);
        }
        return null;
    }

    public CustomCreateFileResponse createFileTemplate(CustomCreateFileRequest customCreateFileRequest) throws Exception {
        if (customCreateFileRequest.getFileType() != null) {
            customCreateFileRequest.setFileType(this.fixNodeType(customCreateFileRequest.getFileType()));
        }
        customCreateFileRequest.setOwner(null);
        Params params = this.createApiInfo(customCreateFileRequest.getActionName());
        Map body = customCreateFileRequest.toMap();
        OpenApiRequest request = new OpenApiRequest().setBody((Object)body);
        try {
            Long l = this.requestTimesCount;
            this.requestTimesCount = this.requestTimesCount + 1L;
            DwClient.pauseForAMount();
            CustomCreateFileResponse response = (CustomCreateFileResponse)TeaModel.toModel((Map)this.client.callApi(params, request, this.runtime), (TeaModel)new CustomCreateFileResponse());
            response.body.setRequestAction(customCreateFileRequest.getActionName());
            return response;
        }
        catch (TeaException error) {
            log.error(error.getMessage());
            log.error(error.getData().get("Recommend").toString());
            Common.assertAsString((Object)error.message);
            throw new RuntimeException(error);
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            log.error(error.getMessage());
            log.error(error.getData().get("Recommend").toString());
            Common.assertAsString((Object)error.message);
            throw new RuntimeException(error);
        }
    }

    public Params createApiInfo(String actionName) throws Exception {
        Params params = new Params().setAction(actionName).setVersion("2020-05-18").setProtocol("HTTPS").setMethod("POST").setAuthType("AK").setStyle("RPC").setPathname("/").setReqBodyType("formData").setBodyType("json");
        return params;
    }

    public Map<String, ?> submitFile(Long projectId, long fieldId, boolean skipAllDeployFileExtensions) throws Exception {
        Params params = this.createApiInfo("SubmitFile");
        HashMap<String, Constable> body = new HashMap<String, Constable>();
        body.put("ProjectId", projectId);
        body.put("ProjectIdentifier", null);
        body.put("FileId", Long.valueOf(fieldId));
        body.put("Comment", null);
        body.put("SkipAllDeployFileExtensions", Boolean.valueOf(skipAllDeployFileExtensions));
        OpenApiRequest request = new OpenApiRequest().setBody(body);
        Long l = this.requestTimesCount;
        this.requestTimesCount = this.requestTimesCount + 1L;
        DwClient.pauseForAMount();
        Map resMap = this.client.callApi(params, request, this.runtime);
        log.info("submit task : {}", (Object)JSON.toJSONString((Object)resMap));
        return resMap;
    }

    public CreateResourceFileResponse createResourceFileAdvanced(CreateResourceFileAdvanceRequest createResourceFileAdvanceRequestRequest) {
        try {
            createResourceFileAdvanceRequestRequest.setStorageURL(this.ossPath);
            Long l = this.requestTimesCount;
            this.requestTimesCount = this.requestTimesCount + 1L;
            DwClient.pauseForAMount();
            CreateResourceFileResponse response = this.client.createResourceFileAdvance(createResourceFileAdvanceRequestRequest, this.runtime);
            return response;
        }
        catch (Exception e) {
            log.error("create.file.error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public CreateUdfFileResponse createFunction(CreateUdfFileRequest createUdfFileRequest) {
        try {
            Long l = this.requestTimesCount;
            this.requestTimesCount = this.requestTimesCount + 1L;
            DwClient.pauseForAMount();
            CreateUdfFileResponse response = this.client.createUdfFileWithOptions(createUdfFileRequest, this.runtime);
            return response;
        }
        catch (TeaException error) {
            log.error(error.getMessage());
            log.error(error.getData().get("Recommend").toString());
            Common.assertAsString((Object)error.message);
            throw new RuntimeException(error);
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            log.error(error.getMessage());
            log.error(error.getData().get("Recommend").toString());
            Common.assertAsString((Object)error.message);
            throw new RuntimeException(_error);
        }
    }

    public GetProjectResponse getProject(GetProjectRequest request) {
        try {
            Long l = this.requestTimesCount;
            this.requestTimesCount = this.requestTimesCount + 1L;
            DwClient.pauseForAMount();
            GetProjectResponse response = this.client.getProjectWithOptions(request, this.runtime);
            return response;
        }
        catch (Exception e) {
            log.error("get.project.error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public GetFileResponse getFile(GetFileRequest request) {
        try {
            Long l = this.requestTimesCount;
            this.requestTimesCount = this.requestTimesCount + 1L;
            DwClient.pauseForAMount();
            GetFileResponse response = this.client.getFileWithOptions(request, this.runtime);
            return response;
        }
        catch (Exception e) {
            log.error("get.file.error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<ListFilesResponseBody.ListFilesResponseBodyDataFiles> listFiles(ListFilesRequest request) throws InterruptedException {
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(100);
        paginator.setPageNum(1);
        ArrayList<ListFilesResponseBody.ListFilesResponseBodyDataFiles> result = new ArrayList<ListFilesResponseBody.ListFilesResponseBodyDataFiles>();
        PageUtil.doPaginate(paginator, p -> {
            try {
                request.setPageNumber(Integer.valueOf(p.getPageNum()));
                request.setPageSize(Integer.valueOf(p.getPageSize()));
                Long l = this.requestTimesCount;
                this.requestTimesCount = this.requestTimesCount + 1L;
                DwClient.pauseForAMount();
                ListFilesResponse listFilesResponse = this.client.listFilesWithOptions(request, this.runtime);
                ListFilesResponseBody.ListFilesResponseBodyData data = listFilesResponse.getBody().getData();
                Integer count = data.getTotalCount();
                List files = data.getFiles();
                PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                paginateResult.setPageNum(p.getPageNum());
                paginateResult.setPageSize(p.getPageSize());
                paginateResult.setData(files);
                result.addAll(files);
                paginateResult.setTotalCount(count);
                return paginateResult;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return result;
    }

    public Map<String, String> getFolderList(long projectId) throws InterruptedException {
        HashMap<String, String> result = new HashMap<String, String>();
        ListFoldersRequest request = new ListFoldersRequest();
        request.setProjectId(Long.valueOf(projectId));
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(100);
        paginator.setPageNum(1);
        PageUtil.doPaginate(paginator, p -> {
            try {
                request.setPageNumber(Integer.valueOf(p.getPageNum()));
                request.setPageSize(Integer.valueOf(p.getPageSize()));
                Long l = this.requestTimesCount;
                this.requestTimesCount = this.requestTimesCount + 1L;
                DwClient.pauseForAMount();
                ListFoldersResponse listFoldersResponse = this.client.listFoldersWithOptions(request, this.runtime);
                ListFoldersResponseBody.ListFoldersResponseBodyData data = listFoldersResponse.getBody().getData();
                Integer count = data.getTotalCount();
                List folders = data.getFolders();
                PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                paginateResult.setPageNum(p.getPageNum());
                paginateResult.setPageSize(p.getPageSize());
                paginateResult.setData(folders);
                result.putAll(folders.stream().collect(Collectors.toMap(ListFoldersResponseBody.ListFoldersResponseBodyDataFolders::getFolderId, ListFoldersResponseBody.ListFoldersResponseBodyDataFolders::getFolderPath)));
                paginateResult.setTotalCount(count);
                return paginateResult;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return result;
    }

    public String getFolderPathById(long projectId, String folderId) {
        GetFolderRequest request = new GetFolderRequest();
        request.setProjectId(Long.valueOf(projectId));
        request.setFolderId(folderId);
        try {
            Long l = this.requestTimesCount;
            this.requestTimesCount = this.requestTimesCount + 1L;
            DwClient.pauseForAMount();
            GetFolderResponse response = this.client.getFolderWithOptions(request, this.runtime);
            return response.getBody().getData().getFolderPath();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Long getExistedResourceFileId(String resourceName, long projectId) throws InterruptedException {
        ListFilesRequest request = new ListFilesRequest();
        request.setExactFileName(resourceName);
        request.setProjectId(Long.valueOf(projectId));
        List<ListFilesResponseBody.ListFilesResponseBodyDataFiles> response = this.listFiles(request);
        if (response != null && !response.isEmpty()) {
            return response.get(0).getFileId();
        }
        return -1L;
    }

    public void deleteResourceFile(long projectId, long fileId) throws Exception {
        DeleteFileRequest request = new DeleteFileRequest();
        request.setProjectId(Long.valueOf(projectId));
        request.setFileId(Long.valueOf(fileId));
        Long l = this.requestTimesCount;
        this.requestTimesCount = this.requestTimesCount + 1L;
        DwClient.pauseForAMount();
        this.client.deleteFileWithOptions(request, this.runtime);
    }

    public List<ListDataSourcesResponseBody.ListDataSourcesResponseBodyDataDataSources> getDatasourceList(long projectId) throws InterruptedException {
        ListDataSourcesRequest request = new ListDataSourcesRequest();
        request.setProjectId(Long.valueOf(projectId));
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(100);
        paginator.setPageNum(1);
        ArrayList<ListDataSourcesResponseBody.ListDataSourcesResponseBodyDataDataSources> result = new ArrayList<ListDataSourcesResponseBody.ListDataSourcesResponseBodyDataDataSources>();
        PageUtil.doPaginate(paginator, p -> {
            try {
                request.setPageNumber(Integer.valueOf(p.getPageNum()));
                request.setPageSize(Integer.valueOf(p.getPageSize()));
                Long l = this.requestTimesCount;
                this.requestTimesCount = this.requestTimesCount + 1L;
                DwClient.pauseForAMount();
                ListDataSourcesResponse listDataSourcesResponse = this.client.listDataSourcesWithOptions(request, this.runtime);
                ListDataSourcesResponseBody.ListDataSourcesResponseBodyData data = listDataSourcesResponse.getBody().getData();
                Integer count = data.getTotalCount();
                List datasource = data.getDataSources();
                PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                paginateResult.setPageNum(p.getPageNum());
                paginateResult.setPageSize(p.getPageSize());
                paginateResult.setData(datasource);
                result.addAll(datasource);
                paginateResult.setTotalCount(count);
                return paginateResult;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return result;
    }

    public void deleteAllBusiness(long projectId) {
        List<ListBusinessResponseBody.ListBusinessResponseBodyDataBusiness> bussinessList = this.getAllBusiness(projectId);
        bussinessList.forEach(buss -> {
            DeleteBusinessRequest request = new DeleteBusinessRequest();
            request.setBusinessId(buss.getBusinessId());
            request.setProjectId(Long.valueOf(projectId));
            try {
                Long l = this.requestTimesCount;
                this.requestTimesCount = this.requestTimesCount + 1L;
                DwClient.pauseForAMount();
                this.client.deleteBusinessWithOptions(request, this.runtime);
            }
            catch (Exception e) {
                log.error("delete baseline error", (Throwable)e);
            }
        });
    }

    public List<ListDIJobsResponseBody.ListDIJobsResponseBodyDIJobPagingDIJobs> listDIJobs(long projectId) throws Exception {
        ListDIJobsRequest request = new ListDIJobsRequest();
        request.setProjectId(Long.valueOf(projectId));
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(20);
        paginator.setPageNum(1);
        ArrayList<ListDIJobsResponseBody.ListDIJobsResponseBodyDIJobPagingDIJobs> result = new ArrayList<ListDIJobsResponseBody.ListDIJobsResponseBodyDIJobPagingDIJobs>();
        PageUtil.doPaginate(paginator, p -> {
            try {
                request.setPageNumber(Integer.valueOf(p.getPageNum()));
                request.setPageSize(Integer.valueOf(p.getPageSize()));
                Long l = this.requestTimesCount;
                this.requestTimesCount = this.requestTimesCount + 1L;
                DwClient.pauseForAMount();
                ListDIJobsResponse listDIJobsResponse = this.client.listDIJobsWithOptions(request, this.runtime);
                ListDIJobsResponseBody.ListDIJobsResponseBodyDIJobPaging data = listDIJobsResponse.getBody().getDIJobPaging();
                Integer count = data.getTotalCount();
                List jobs = data.getDIJobs();
                PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                paginateResult.setPageNum(p.getPageNum());
                paginateResult.setPageSize(p.getPageSize());
                paginateResult.setData(jobs);
                result.addAll(jobs);
                paginateResult.setTotalCount(count);
                return paginateResult;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return result;
    }

    public GetDIJobResponseBody.GetDIJobResponseBodyData getDIJob(long projectId, long jobId) throws Exception {
        GetDIJobRequest request = new GetDIJobRequest();
        request.setDIJobId(Long.valueOf(jobId));
        request.setWithDetails(Boolean.valueOf(true));
        Long l = this.requestTimesCount;
        this.requestTimesCount = this.requestTimesCount + 1L;
        DwClient.pauseForAMount();
        return this.client.getDIJobWithOptions(request, this.runtime).getBody().getData();
    }

    public List<GetDIJobResponseBody.GetDIJobResponseBodyData> exportDIJobDefinationList(long projectId) throws Exception {
        List<ListDIJobsResponseBody.ListDIJobsResponseBodyDIJobPagingDIJobs> DIJobList = this.listDIJobs(projectId);
        if (DIJobList.isEmpty()) {
            return new ArrayList<GetDIJobResponseBody.GetDIJobResponseBodyData>();
        }
        ArrayList<GetDIJobResponseBody.GetDIJobResponseBodyData> result = new ArrayList<GetDIJobResponseBody.GetDIJobResponseBodyData>();
        DIJobList.forEach(job -> {
            try {
                GetDIJobResponseBody.GetDIJobResponseBodyData data = this.getDIJob(projectId, job.getDIJobId());
                result.add(data);
            }
            catch (Exception e) {
                log.error("exportDIJobDefinationList error", (Throwable)e);
            }
        });
        return result;
    }

    public void importDIJobListByGetResponse(List<GetDIJobResponseBody.GetDIJobResponseBodyData> jobList, List<CreateDIJobRequest> requests) {
        jobList.forEach(job -> {
            try {
                this.createDIJobByGetResponse((GetDIJobResponseBody.GetDIJobResponseBodyData)job, requests);
            }
            catch (Exception e) {
                log.error("DIJob migration error, jobName: {}, source: {}, tartget: {}, \n {}", new Object[]{job.jobName, job.getSourceDataSourceSettings(), job.getDestinationDataSourceSettings(), e});
            }
        });
    }

    public void createDIJobByGetResponse(GetDIJobResponseBody.GetDIJobResponseBodyData job, List<CreateDIJobRequest> requests) throws Exception {
        CreateDIJobRequest request = new CreateDIJobRequest();
        request = (CreateDIJobRequest)JSONObject.parseObject((String)JSONObject.from((Object)job).toJSONString(new JSONWriter.Feature[0]), CreateDIJobRequest.class);
        if (request.getJobSettings().getCycleScheduleSettings().getCycleMigrationType() == null) {
            request.getJobSettings().getCycleScheduleSettings().setScheduleParameters(null);
        }
        if (request.getResourceSettings().getRequestedCu() == null) {
            request.getResourceSettings().setRequestedCu(Float.valueOf(1.0f));
        }
        ArrayList<CreateDIJobRequest.CreateDIJobRequestTransformationRules> rules = new ArrayList<CreateDIJobRequest.CreateDIJobRequestTransformationRules>();
        ArrayList<String> noneEffectRules = new ArrayList<String>();
        for (CreateDIJobRequest.CreateDIJobRequestTransformationRules rule : request.getTransformationRules()) {
            if (rule.getRuleName().length() > 49) {
                rule.setRuleName(rule.getRuleName().substring(rule.getRuleName().length() - 49, rule.getRuleName().length()));
            }
            if (!rule.getRuleActionType().equals("AddColumn") || !rule.getRuleExpression().equals("{}")) {
                rules.add(rule);
                continue;
            }
            noneEffectRules.add(rule.getRuleName());
        }
        request.setTransformationRules(rules);
        for (CreateDIJobRequest.CreateDIJobRequestTableMappings tableMappings : request.getTableMappings()) {
            ArrayList<CreateDIJobRequest.CreateDIJobRequestTableMappingsTransformationRules> rulesTab = new ArrayList<CreateDIJobRequest.CreateDIJobRequestTableMappingsTransformationRules>();
            for (CreateDIJobRequest.CreateDIJobRequestTableMappingsTransformationRules rule : tableMappings.getTransformationRules()) {
                if (rule.getRuleName().length() > 49) {
                    rule.setRuleName(rule.getRuleName().substring(rule.getRuleName().length() - 49, rule.getRuleName().length()));
                }
                if (noneEffectRules.contains(rule.getRuleName())) continue;
                rulesTab.add(rule);
            }
            tableMappings.setTransformationRules(rulesTab);
        }
        requests.add(request);
        this.createDIJob(request);
    }

    public void createDIJob(CreateDIJobRequest request) throws Exception {
        Long l = this.requestTimesCount;
        this.requestTimesCount = this.requestTimesCount + 1L;
        DwClient.pauseForAMount();
        CreateDIJobResponse response = this.client.createDIJobWithOptions(request, this.runtime);
    }

    public void deleteDIJob(DeleteDIJobRequest request) throws Exception {
        Long l = this.requestTimesCount;
        this.requestTimesCount = this.requestTimesCount + 1L;
        DwClient.pauseForAMount();
        DeleteDIJobResponse response = this.client.deleteDIJobWithOptions(request, this.runtime);
    }

    public void deleteDIJobListByGetResponse(List<GetDIJobResponseBody.GetDIJobResponseBodyData> jobList) {
        jobList.forEach(job -> {
            try {
                this.deleteDIJobByGetResponse((GetDIJobResponseBody.GetDIJobResponseBodyData)job);
            }
            catch (Exception e) {
                log.error("deleteDIJobListByGetResponse error", (Throwable)e);
            }
        });
    }

    public void deleteDIJobByGetResponse(GetDIJobResponseBody.GetDIJobResponseBodyData job) throws Exception {
        DeleteDIJobRequest request = new DeleteDIJobRequest();
        request.setDIJobId(job.getDIJobId());
        this.deleteDIJob(request);
    }

    private static void pauseForAMount() {
        try {
            Thread.sleep(parseTimeMilliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Integer fixNodeType(Integer nodeTypeId) {
        switch (this.endpoint) {
            case "dataworks.cn-hangzhou.aliyuncs.com": {
                if (!nodeTypeIdMapHangzhou.containsKey(nodeTypeId)) break;
                return nodeTypeIdMapHangzhou.get(nodeTypeId);
            }
            case "dataworks.cn-shenzhen.aliyuncs.com": {
                if (!nodeTypeIdMapShenzhen.containsKey(nodeTypeId)) break;
                return nodeTypeIdMapShenzhen.get(nodeTypeId);
            }
        }
        return nodeTypeId;
    }
}

