/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.type;

import com.aliyun.migration.workflow.migration.common.type.ScheduleNodeTypeInterface;
import java.util.HashMap;
import java.util.Map;

public enum OozieNodeType implements ScheduleNodeTypeInterface
{
    START("start", "START"),
    END("end", "END"),
    KILL("kill", "KILL"),
    DECISION("decision", "DECISION"),
    FORK("fork", "FORK"),
    JOIN("join", "JOIN"),
    MAPREDUCE("actionmap-reduce", "MAPREDUCE"),
    PIG("actionpig", "PIG"),
    FS("actionfs", "FS"),
    SUBWORKFLOW("actionsub-workflow", "SUBWORKFLOW"),
    JAVA("actionjava", "JAVA");

    private final String nameInXml;
    private final String name;
    private static final Map<String, OozieNodeType> COMMAND_TYPE_MAP;

    private OozieNodeType(String nameInXml, String name) {
        this.nameInXml = nameInXml;
        this.name = name;
    }

    public String getNameInXml() {
        return this.nameInXml;
    }

    public String getName() {
        return this.name;
    }

    public static OozieNodeType of(String tagName) {
        if (COMMAND_TYPE_MAP.containsKey(tagName)) {
            return COMMAND_TYPE_MAP.get(tagName);
        }
        throw new IllegalArgumentException("invalid tagName : " + tagName);
    }

    public static OozieNodeType of(String outTagName, String insideTagName) {
        if (COMMAND_TYPE_MAP.containsKey(outTagName + insideTagName)) {
            return COMMAND_TYPE_MAP.get(outTagName + insideTagName);
        }
        throw new IllegalArgumentException("invalid outTagName : " + outTagName + " insideTagName : " + insideTagName);
    }

    static {
        COMMAND_TYPE_MAP = new HashMap<String, OozieNodeType>();
        for (OozieNodeType oozieNodeType : OozieNodeType.values()) {
            COMMAND_TYPE_MAP.put(oozieNodeType.nameInXml, oozieNodeType);
            COMMAND_TYPE_MAP.put(oozieNodeType.name, oozieNodeType);
        }
    }
}

