/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.tool;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskMoveThreadPool<E extends Callable<T>, T> {
    private static final Logger log = LoggerFactory.getLogger(TaskMoveThreadPool.class);
    private static final Long TIME_OUT = 10L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(List<E> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            log.warn("no need to exec!");
            return;
        }
        int minThreadNum = tasks.size();
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("MoveWorkflowNodeThreadPool-%d").build();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(minThreadNum, minThreadNum, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        ExecutorCompletionService threadPool = new ExecutorCompletionService(executor);
        try {
            for (Callable task : tasks) {
                threadPool.submit(task);
            }
            for (int i = 0; i < minThreadNum; ++i) {
                Object dealCount = threadPool.take().get();
                log.info("[workflow-move]: Current thread {} handle workflow size is:{}", (Object)Thread.currentThread(), dealCount);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("[workflow-move]:Workflow node data migration multi-thread errors\uff0c{}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
        finally {
            boolean b = MoreExecutors.shutdownAndAwaitTermination((ExecutorService)executor, (long)TIME_OUT, (TimeUnit)TimeUnit.SECONDS);
            log.info("[workflow-move]: Thread pool closing results\uff1a{}", (Object)b);
        }
    }
}

