/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.spi;

import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.workflow.migration.common.jarload.JarLoader;
import com.aliyun.migration.workflow.migration.common.spi.BwmPluginRegisterSupervisor;
import com.aliyun.migration.workflow.migration.common.utils.BwmCommonUtil;
import java.io.File;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterOperator {
    private static final Logger log = LoggerFactory.getLogger(RegisterOperator.class);
    private static String JAR_PATH = BwmCommonUtil.getPluginExternalLoadPath();

    public static void doRegister() {
        RegisterOperator.register(RegisterOperator.class.getClassLoader());
        RegisterOperator.doRegisterExternal();
    }

    private static void doRegisterExternal() {
        if (StringUtils.isBlank((CharSequence)JAR_PATH) || !new File(JAR_PATH).exists()) {
            log.warn("extenal plugin path is not found: {}", (Object)JAR_PATH);
            return;
        }
        String[] paths = new String[]{JAR_PATH};
        JarLoader classLoader = new JarLoader(paths);
        RegisterOperator.register(classLoader);
    }

    public static void doRegisterExternal(String selfPath) {
        if (StringUtils.isBlank((CharSequence)selfPath) || !new File(selfPath).exists()) {
            log.warn("external plugin path is not found: {}", (Object)selfPath);
            return;
        }
        String[] paths = new String[]{JAR_PATH};
        JarLoader classLoader = new JarLoader(paths);
        RegisterOperator.register(classLoader);
    }

    private static void register(ClassLoader classLoader) {
        ServiceLoader<BwmPluginRegisterSupervisor> registers = ServiceLoader.load(BwmPluginRegisterSupervisor.class, classLoader);
        for (BwmPluginRegisterSupervisor register : registers) {
            try {
                String keyword = register.keyword();
                register.register();
                log.info("register plugin finish : {}", (Object)keyword);
            }
            catch (Exception e) {
                log.error("failed to load register : {}", (Object)register.keyword());
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.PLUGIN_INIT_ERROR, (String)("failed to load register " + register.keyword()));
            }
        }
    }
}

