/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.file;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.constant.report.StatisticsReportConstant;
import com.aliyun.migration.api.constant.report.WorkflowDatasourceSheetProperties;
import com.aliyun.migration.api.constant.report.WorkflowFunctionSheetProperties;
import com.aliyun.migration.api.constant.report.WorkflowNodeSheetProperties;
import com.aliyun.migration.api.constant.report.WorkflowProjectSheetProperties;
import com.aliyun.migration.api.constant.report.WorkflowRelationSheetProperties;
import com.aliyun.migration.api.constant.report.WorkflowResourceSheetProperties;
import com.aliyun.migration.api.constant.report.WorkflowSheetProperties;
import com.aliyun.migration.api.constant.report.WorkflowTriggerSheetProperties;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.common.config.BwmSaasConfiguration;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageFileOperator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class BwmPackageSrSnapshotFileOperator {
    private static final Logger log = LoggerFactory.getLogger(BwmPackageSrSnapshotFileOperator.class);
    private static Charset charset = Charset.forName("UTF-8");

    public static void writeDiscoverySrSnapshotFile(WorkflowProjectPackage workflowProjectPackage, BwmSaasConfiguration bwmSaasConfiguration) {
        WorkflowProjectSheetProperties projectSheetProperties = new WorkflowProjectSheetProperties();
        projectSheetProperties.setMetaInfo(bwmSaasConfiguration.getMeta().getTenantUuid(), bwmSaasConfiguration.getMeta().getMetaVersion(), bwmSaasConfiguration.getMeta().getScheduleDatasourceUuid());
        JSONArray projectSrJsonArray = new JSONArray();
        String projectSrFilePath = bwmSaasConfiguration.getDiscoverySrSnapshotFileSavePath(StatisticsReportConstant.StatisticEntity.WORKFLOW_PROJECT.name().toLowerCase(), workflowProjectPackage.getWorkflowProject().getProjectId());
        projectSheetProperties.setPropertyValue(workflowProjectPackage.getWorkflowProject());
        projectSrJsonArray.add((Object)projectSheetProperties.getValuesForSR());
        try {
            FileUtils.writeStringToFile((File)new File(projectSrFilePath), (String)projectSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeFile error, projectSrFilePath:{}", (Object)projectSrFilePath, (Object)e);
        }
        WorkflowSheetProperties workflowSheetProperties = new WorkflowSheetProperties();
        workflowSheetProperties.setMetaInfo(bwmSaasConfiguration.getMeta().getTenantUuid(), bwmSaasConfiguration.getMeta().getMetaVersion(), bwmSaasConfiguration.getMeta().getScheduleDatasourceUuid());
        JSONArray workflowSrJsonArray = new JSONArray();
        String workflowSrFilePath = bwmSaasConfiguration.getDiscoverySrSnapshotFileSavePath(StatisticsReportConstant.StatisticEntity.WORKFLOW.name().toLowerCase(), workflowProjectPackage.getWorkflowProject().getProjectId());
        for (Workflow workflow : workflowProjectPackage.getWorkflowList()) {
            workflowSheetProperties.setPropertyValue(workflow);
            workflowSrJsonArray.add((Object)workflowSheetProperties.getValuesForSR());
        }
        try {
            FileUtils.writeStringToFile((File)new File(workflowSrFilePath), (String)workflowSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeFile error, workflowSrFilePath:{}", (Object)workflowSrFilePath, (Object)e);
        }
        WorkflowNodeSheetProperties workflowNodeSheetProperties = new WorkflowNodeSheetProperties();
        workflowNodeSheetProperties.setMetaInfo(bwmSaasConfiguration.getMeta().getTenantUuid(), bwmSaasConfiguration.getMeta().getMetaVersion(), bwmSaasConfiguration.getMeta().getScheduleDatasourceUuid());
        JSONArray workflowNodeSrJsonArray = new JSONArray();
        String workflowNodeSrFilePath = bwmSaasConfiguration.getDiscoverySrSnapshotFileSavePath(StatisticsReportConstant.StatisticEntity.WORKFLOW_NODE.name().toLowerCase(), workflowProjectPackage.getWorkflowProject().getProjectId());
        BwmPackageFileOperator.buildNodeScriptSavePath(workflowProjectPackage);
        for (Workflow workflow : workflowProjectPackage.getWorkflowList()) {
            for (Object node : workflow.getWorkflowNodes()) {
                workflowNodeSheetProperties.setPropertyValue((WorkflowNode)node);
                workflowNodeSrJsonArray.add((Object)workflowNodeSheetProperties.getValuesForSR());
            }
        }
        try {
            FileUtils.writeStringToFile((File)new File(workflowNodeSrFilePath), (String)workflowNodeSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeFile error, workflowNodeSrFilePath:{}", (Object)workflowNodeSrFilePath, (Object)e);
        }
        WorkflowRelationSheetProperties workflowRelationSheetProperties = new WorkflowRelationSheetProperties();
        workflowRelationSheetProperties.setMetaInfo(bwmSaasConfiguration.getMeta().getTenantUuid(), bwmSaasConfiguration.getMeta().getMetaVersion(), bwmSaasConfiguration.getMeta().getScheduleDatasourceUuid());
        JSONArray workflowRelationSrJsonArray = new JSONArray();
        String workflowRelationSrFilePath = bwmSaasConfiguration.getDiscoverySrSnapshotFileSavePath(StatisticsReportConstant.StatisticEntity.WORKFLOW_RELATION.name().toLowerCase(), workflowProjectPackage.getWorkflowProject().getProjectId());
        for (Workflow workflow : workflowProjectPackage.getWorkflowList()) {
            for (Object relation : workflow.getNodeRelations()) {
                workflowRelationSheetProperties.setPropertyValue(workflow, (RelationPackage)relation);
                workflowRelationSrJsonArray.add((Object)workflowRelationSheetProperties.getValuesForSR());
            }
        }
        try {
            FileUtils.writeStringToFile((File)new File(workflowRelationSrFilePath), (String)workflowRelationSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeFile error, workflowRelationSrFilePath:{}", (Object)workflowRelationSrFilePath, (Object)e);
        }
        WorkflowDatasourceSheetProperties workflowDatasourceSheetProperties = new WorkflowDatasourceSheetProperties();
        workflowDatasourceSheetProperties.setMetaInfo(bwmSaasConfiguration.getMeta().getTenantUuid(), bwmSaasConfiguration.getMeta().getMetaVersion(), bwmSaasConfiguration.getMeta().getScheduleDatasourceUuid());
        JSONArray workflowDatasourceSrJsonArray = new JSONArray();
        String workflowDatasourceSrFilePath = bwmSaasConfiguration.getDiscoverySrSnapshotFileSavePath(StatisticsReportConstant.StatisticEntity.WORKFLOW_DATASOURCE.name().toLowerCase(), workflowProjectPackage.getWorkflowProject().getProjectId());
        for (WorkflowDatasource datasource : workflowProjectPackage.getDatasources()) {
            workflowDatasourceSheetProperties.setPropertyValue(datasource);
            workflowDatasourceSrJsonArray.add((Object)workflowDatasourceSheetProperties.getValuesForSR());
        }
        try {
            FileUtils.writeStringToFile((File)new File(workflowDatasourceSrFilePath), (String)workflowDatasourceSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeFile error, workflowDatasourceSrFilePath:{}", (Object)workflowDatasourceSrFilePath, (Object)e);
        }
        WorkflowFunctionSheetProperties workflowFunctionSheetProperties = new WorkflowFunctionSheetProperties();
        workflowFunctionSheetProperties.setMetaInfo(bwmSaasConfiguration.getMeta().getTenantUuid(), bwmSaasConfiguration.getMeta().getMetaVersion(), bwmSaasConfiguration.getMeta().getScheduleDatasourceUuid());
        JSONArray workflowFunctionSrJsonArray = new JSONArray();
        String workflowFunctionSrFilePath = bwmSaasConfiguration.getDiscoverySrSnapshotFileSavePath(StatisticsReportConstant.StatisticEntity.WORKFLOW_FUNCTION_RESOURCE.name().toLowerCase(), workflowProjectPackage.getWorkflowProject().getProjectId());
        for (WorkflowFunctionResource function : workflowProjectPackage.getFunctions()) {
            workflowFunctionSheetProperties.setPropertyValue(function);
            workflowFunctionSrJsonArray.add((Object)workflowFunctionSheetProperties.getValuesForSR());
        }
        try {
            FileUtils.writeStringToFile((File)new File(workflowFunctionSrFilePath), (String)workflowFunctionSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeFile error, workflowFunctionSrFilePath:{}", (Object)workflowFunctionSrFilePath, (Object)e);
        }
        WorkflowResourceSheetProperties workflowResourceSheetProperties = new WorkflowResourceSheetProperties();
        workflowResourceSheetProperties.setMetaInfo(bwmSaasConfiguration.getMeta().getTenantUuid(), bwmSaasConfiguration.getMeta().getMetaVersion(), bwmSaasConfiguration.getMeta().getScheduleDatasourceUuid());
        JSONArray workflowResourceSrJsonArray = new JSONArray();
        String workflowResourceSrFilePath = bwmSaasConfiguration.getDiscoverySrSnapshotFileSavePath(StatisticsReportConstant.StatisticEntity.WORKFLOW_FILE_RESOURCE.name().toLowerCase(), workflowProjectPackage.getWorkflowProject().getProjectId());
        for (WorkflowFileResource file : workflowProjectPackage.getFiles()) {
            workflowResourceSheetProperties.setPropertyValue(file);
            workflowResourceSheetProperties.setPropertyValue(WorkflowResourceSheetProperties.WorkflowResourceSheetColumn.PATH, (Object)BwmPackageFileOperator.buildFileResourceSavePath(file));
            workflowResourceSrJsonArray.add((Object)workflowResourceSheetProperties.getValuesForSR());
        }
        try {
            FileUtils.writeStringToFile((File)new File(workflowResourceSrFilePath), (String)workflowResourceSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeFile error, workflowResourceSrFilePath:{}", (Object)workflowResourceSrFilePath, (Object)e);
        }
        WorkflowTriggerSheetProperties workflowTriggerSheetProperties = new WorkflowTriggerSheetProperties();
        workflowTriggerSheetProperties.setMetaInfo(bwmSaasConfiguration.getMeta().getTenantUuid(), bwmSaasConfiguration.getMeta().getMetaVersion(), bwmSaasConfiguration.getMeta().getScheduleDatasourceUuid());
        JSONArray workflowTriggerSrJsonArray = new JSONArray();
        String workflowTriggerSrFilePath = bwmSaasConfiguration.getDiscoverySrSnapshotFileSavePath(StatisticsReportConstant.StatisticEntity.WORKFLOW_TRIGGER.name().toLowerCase(), workflowProjectPackage.getWorkflowProject().getProjectId());
        for (Workflow workflow : workflowProjectPackage.getWorkflowList()) {
            if (!CollectionUtils.isEmpty((Collection)workflow.getTriggers())) {
                for (WorkflowTrigger trigger : workflow.getTriggers()) {
                    workflowTriggerSheetProperties.setPropertyValue(workflow, trigger);
                    workflowTriggerSrJsonArray.add((Object)workflowTriggerSheetProperties.getValuesForSR());
                }
            }
            for (WorkflowNode node : workflow.getWorkflowNodes()) {
                if (node.getTrigger() == null) continue;
                workflowTriggerSheetProperties.setPropertyValue(node, node.getTrigger());
                workflowTriggerSrJsonArray.add((Object)workflowTriggerSheetProperties.getValuesForSR());
            }
        }
        try {
            FileUtils.writeStringToFile((File)new File(workflowTriggerSrFilePath), (String)workflowTriggerSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeFile error, workflowTriggerSrFilePath:{}", (Object)workflowTriggerSrFilePath, (Object)e);
        }
    }

    public static void writeMigrationSrSnapshotFile(WorkflowProjectPackage workflowProjectPackage, BwmSaasConfiguration bwmSaasConfiguration) {
        WorkflowProjectSheetProperties projectSheetProperties = new WorkflowProjectSheetProperties();
        projectSheetProperties.setMetaInfo(bwmSaasConfiguration.getMeta().getTenantUuid(), bwmSaasConfiguration.getMeta().getMetaVersion(), bwmSaasConfiguration.getMeta().getScheduleDatasourceUuid());
        JSONArray projectSrJsonArray = new JSONArray();
        String projectSrFilePath = bwmSaasConfiguration.getMigrationSrSnapshotFileSavePath(StatisticsReportConstant.StatisticEntity.WORKFLOW_PROJECT.name().toLowerCase());
        if (workflowProjectPackage.getWorkflowProject() != null) {
            projectSheetProperties.setPropertyValue(workflowProjectPackage.getWorkflowProject());
            projectSrJsonArray.add((Object)projectSheetProperties.getValuesForSR());
        }
        try {
            FileUtils.writeStringToFile((File)new File(projectSrFilePath), (String)projectSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeFile error, projectSrFilePath:{}", (Object)projectSrFilePath, (Object)e);
        }
        WorkflowSheetProperties workflowSheetProperties = new WorkflowSheetProperties();
        workflowSheetProperties.setMetaInfo(bwmSaasConfiguration.getMeta().getTenantUuid(), bwmSaasConfiguration.getMeta().getMetaVersion(), bwmSaasConfiguration.getMeta().getScheduleDatasourceUuid());
        JSONArray workflowSrJsonArray = new JSONArray();
        String workflowSrFilePath = bwmSaasConfiguration.getMigrationSrSnapshotFileSavePath(StatisticsReportConstant.StatisticEntity.WORKFLOW.name().toLowerCase());
        if (!CollectionUtils.isEmpty((Collection)workflowProjectPackage.getWorkflowList())) {
            for (Workflow workflow : workflowProjectPackage.getWorkflowList()) {
                workflowSheetProperties.setPropertyValue(workflow);
                workflowSrJsonArray.add((Object)workflowSheetProperties.getValuesForSR());
            }
        }
        try {
            FileUtils.writeStringToFile((File)new File(workflowSrFilePath), (String)workflowSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeFile error, workflowSrFilePath:{}", (Object)workflowSrFilePath, (Object)e);
        }
        WorkflowNodeSheetProperties workflowNodeSheetProperties = new WorkflowNodeSheetProperties();
        workflowNodeSheetProperties.setMetaInfo(bwmSaasConfiguration.getMeta().getTenantUuid(), bwmSaasConfiguration.getMeta().getMetaVersion(), bwmSaasConfiguration.getMeta().getScheduleDatasourceUuid());
        JSONArray workflowNodeSrJsonArray = new JSONArray();
        String workflowNodeSrFilePath = bwmSaasConfiguration.getMigrationSrSnapshotFileSavePath(StatisticsReportConstant.StatisticEntity.WORKFLOW_NODE.name().toLowerCase());
        BwmPackageFileOperator.buildNodeScriptSavePath(workflowProjectPackage);
        if (!CollectionUtils.isEmpty((Collection)workflowProjectPackage.getWorkflowList())) {
            for (Workflow workflow : workflowProjectPackage.getWorkflowList()) {
                if (CollectionUtils.isEmpty((Collection)workflow.getWorkflowNodes())) continue;
                for (Object node : workflow.getWorkflowNodes()) {
                    workflowNodeSheetProperties.setPropertyValue((WorkflowNode)node);
                    workflowNodeSrJsonArray.add((Object)workflowNodeSheetProperties.getValuesForSR());
                }
            }
        }
        try {
            FileUtils.writeStringToFile((File)new File(workflowNodeSrFilePath), (String)workflowNodeSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeFile error, workflowNodeSrFilePath:{}", (Object)workflowNodeSrFilePath, (Object)e);
        }
        WorkflowRelationSheetProperties workflowRelationSheetProperties = new WorkflowRelationSheetProperties();
        workflowRelationSheetProperties.setMetaInfo(bwmSaasConfiguration.getMeta().getTenantUuid(), bwmSaasConfiguration.getMeta().getMetaVersion(), bwmSaasConfiguration.getMeta().getScheduleDatasourceUuid());
        JSONArray workflowRelationSrJsonArray = new JSONArray();
        String workflowRelationSrFilePath = bwmSaasConfiguration.getMigrationSrSnapshotFileSavePath(StatisticsReportConstant.StatisticEntity.WORKFLOW_RELATION.name().toLowerCase());
        if (!CollectionUtils.isEmpty((Collection)workflowProjectPackage.getWorkflowList())) {
            for (Workflow workflow : workflowProjectPackage.getWorkflowList()) {
                if (CollectionUtils.isEmpty((Collection)workflow.getNodeRelations())) continue;
                for (Object relation : workflow.getNodeRelations()) {
                    workflowRelationSheetProperties.setPropertyValue(workflow, (RelationPackage)relation);
                    workflowRelationSrJsonArray.add((Object)workflowRelationSheetProperties.getValuesForSR());
                }
            }
        }
        try {
            FileUtils.writeStringToFile((File)new File(workflowRelationSrFilePath), (String)workflowRelationSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeFile error, workflowRelationSrFilePath:{}", (Object)workflowRelationSrFilePath, (Object)e);
        }
        WorkflowDatasourceSheetProperties workflowDatasourceSheetProperties = new WorkflowDatasourceSheetProperties();
        workflowDatasourceSheetProperties.setMetaInfo(bwmSaasConfiguration.getMeta().getTenantUuid(), bwmSaasConfiguration.getMeta().getMetaVersion(), bwmSaasConfiguration.getMeta().getScheduleDatasourceUuid());
        JSONArray workflowDatasourceSrJsonArray = new JSONArray();
        String workflowDatasourceSrFilePath = bwmSaasConfiguration.getMigrationSrSnapshotFileSavePath(StatisticsReportConstant.StatisticEntity.WORKFLOW_DATASOURCE.name().toLowerCase());
        if (!CollectionUtils.isEmpty((Collection)workflowProjectPackage.getDatasources())) {
            for (WorkflowDatasource datasource : workflowProjectPackage.getDatasources()) {
                workflowDatasourceSheetProperties.setPropertyValue(datasource);
                workflowDatasourceSrJsonArray.add((Object)workflowDatasourceSheetProperties.getValuesForSR());
            }
        }
        try {
            FileUtils.writeStringToFile((File)new File(workflowDatasourceSrFilePath), (String)workflowDatasourceSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeFile error, workflowDatasourceSrFilePath:{}", (Object)workflowDatasourceSrFilePath, (Object)e);
        }
        WorkflowFunctionSheetProperties workflowFunctionSheetProperties = new WorkflowFunctionSheetProperties();
        workflowFunctionSheetProperties.setMetaInfo(bwmSaasConfiguration.getMeta().getTenantUuid(), bwmSaasConfiguration.getMeta().getMetaVersion(), bwmSaasConfiguration.getMeta().getScheduleDatasourceUuid());
        JSONArray workflowFunctionSrJsonArray = new JSONArray();
        String workflowFunctionSrFilePath = bwmSaasConfiguration.getMigrationSrSnapshotFileSavePath(StatisticsReportConstant.StatisticEntity.WORKFLOW_FUNCTION_RESOURCE.name().toLowerCase());
        if (!CollectionUtils.isEmpty((Collection)workflowProjectPackage.getFunctions())) {
            for (WorkflowFunctionResource function : workflowProjectPackage.getFunctions()) {
                workflowFunctionSheetProperties.setPropertyValue(function);
                workflowFunctionSrJsonArray.add((Object)workflowFunctionSheetProperties.getValuesForSR());
            }
        }
        try {
            FileUtils.writeStringToFile((File)new File(workflowFunctionSrFilePath), (String)workflowFunctionSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeFile error, workflowFunctionSrFilePath:{}", (Object)workflowFunctionSrFilePath, (Object)e);
        }
        WorkflowResourceSheetProperties workflowResourceSheetProperties = new WorkflowResourceSheetProperties();
        workflowResourceSheetProperties.setMetaInfo(bwmSaasConfiguration.getMeta().getTenantUuid(), bwmSaasConfiguration.getMeta().getMetaVersion(), bwmSaasConfiguration.getMeta().getScheduleDatasourceUuid());
        JSONArray workflowResourceSrJsonArray = new JSONArray();
        String workflowResourceSrFilePath = bwmSaasConfiguration.getMigrationSrSnapshotFileSavePath(StatisticsReportConstant.StatisticEntity.WORKFLOW_FILE_RESOURCE.name().toLowerCase());
        if (!CollectionUtils.isEmpty((Collection)workflowProjectPackage.getFiles())) {
            for (WorkflowFileResource file : workflowProjectPackage.getFiles()) {
                workflowResourceSheetProperties.setPropertyValue(file);
                workflowResourceSheetProperties.setPropertyValue(WorkflowResourceSheetProperties.WorkflowResourceSheetColumn.PATH, (Object)BwmPackageFileOperator.buildFileResourceSavePath(file));
                workflowResourceSrJsonArray.add((Object)workflowResourceSheetProperties.getValuesForSR());
            }
        }
        try {
            FileUtils.writeStringToFile((File)new File(workflowResourceSrFilePath), (String)workflowResourceSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeFile error, workflowResourceSrFilePath:{}", (Object)workflowResourceSrFilePath, (Object)e);
        }
        WorkflowTriggerSheetProperties workflowTriggerSheetProperties = new WorkflowTriggerSheetProperties();
        workflowTriggerSheetProperties.setMetaInfo(bwmSaasConfiguration.getMeta().getTenantUuid(), bwmSaasConfiguration.getMeta().getMetaVersion(), bwmSaasConfiguration.getMeta().getScheduleDatasourceUuid());
        JSONArray workflowTriggerSrJsonArray = new JSONArray();
        String workflowTriggerSrFilePath = bwmSaasConfiguration.getMigrationSrSnapshotFileSavePath(StatisticsReportConstant.StatisticEntity.WORKFLOW_TRIGGER.name().toLowerCase());
        if (!CollectionUtils.isEmpty((Collection)workflowProjectPackage.getWorkflowList())) {
            for (Workflow workflow : workflowProjectPackage.getWorkflowList()) {
                if (!CollectionUtils.isEmpty((Collection)workflow.getTriggers())) {
                    for (WorkflowTrigger trigger : workflow.getTriggers()) {
                        workflowTriggerSheetProperties.setPropertyValue(workflow, trigger);
                        workflowTriggerSrJsonArray.add((Object)workflowTriggerSheetProperties.getValuesForSR());
                    }
                }
                if (CollectionUtils.isEmpty((Collection)workflow.getWorkflowNodes())) continue;
                for (WorkflowNode node : workflow.getWorkflowNodes()) {
                    if (node.getTrigger() == null) continue;
                    workflowTriggerSheetProperties.setPropertyValue(node, node.getTrigger());
                    workflowTriggerSrJsonArray.add((Object)workflowTriggerSheetProperties.getValuesForSR());
                }
            }
        }
        try {
            FileUtils.writeStringToFile((File)new File(workflowTriggerSrFilePath), (String)workflowTriggerSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeFile error, workflowTriggerSrFilePath:{}", (Object)workflowTriggerSrFilePath, (Object)e);
        }
    }
}

