/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert.shell2n;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.shell.ShellParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.shell2n.AbstractShellConverter;
import com.aliyun.migration.workflow.migration.common.convert.utils.ScriptArgsReplace;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellShellConverter
extends AbstractShellConverter {
    private static final Logger log = LoggerFactory.getLogger(ShellShellConverter.class);

    public ShellShellConverter(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
        this.workflow = workflow;
    }

    @Override
    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = BwmJsonUtil.deepCopy(workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        String nodeType = super.getNodeType(workflowNode);
        tgtworkflowNode.setNodeType(nodeType);
        if (this.isJsonString(workflowNode.getScript()).booleanValue()) {
            ShellParameters parameter = (ShellParameters)GsonUtils.fromJsonString((String)workflowNode.getScript(), (Type)TypeToken.get(ShellParameters.class).getType());
            List resources = ListUtils.emptyIfNull((List)parameter.getResourceFilesList()).stream().map(ResourceInfo::getResourceName).distinct().collect(Collectors.toList());
            ArrayList<String> codeLines = new ArrayList<String>();
            codeLines.add(DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.valueOf((String)nodeType), (String)"", resources));
            if (tgtworkflowNode.getParamMap() == null) {
                tgtworkflowNode.setParamMap(new HashMap());
            }
            ListUtils.emptyIfNull((List)parameter.getLocalParams()).forEach(x -> {
                String prop = x.getProp();
                String value = x.getValue();
                tgtworkflowNode.getParamMap().put(prop, value);
            });
            if (this.isShellScriptParamReplaceEnabled(workflowNode).booleanValue()) {
                parameter.setRawScript(ScriptArgsReplace.replace(parameter.getRawScript(), tgtworkflowNode.getParamMap(), this.workflow.getCustomProperties(), null));
            }
            if (!StringUtils.isEmpty((CharSequence)parameter.getRawScript())) {
                codeLines.add(parameter.getRawScript());
            }
            if (codeLines.isEmpty()) {
                tgtworkflowNode.setScript("");
            } else {
                tgtworkflowNode.setScript(Joiner.on((String)"\n").join(codeLines));
            }
        } else {
            if (this.isShellScriptParamReplaceEnabled(workflowNode).booleanValue()) {
                workflowNode.setScript(ScriptArgsReplace.replace(workflowNode.getScript(), workflowNode.getParamMap(), this.workflow.getCustomProperties(), null));
            }
            ArrayList<String> codeLines = new ArrayList<String>();
            ArrayList resources = new ArrayList();
            if (workflowNode.getFiles() != null) {
                workflowNode.getFiles().forEach(file -> {
                    if (StringUtils.isNotBlank((CharSequence)file.getName())) {
                        resources.add(file.getName());
                    }
                });
            }
            codeLines.add(DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.valueOf((String)nodeType), (String)"", resources));
            if (StringUtils.isNotBlank((CharSequence)workflowNode.getScript())) {
                codeLines.add(workflowNode.getScript());
            }
            if (codeLines.isEmpty()) {
                tgtworkflowNode.setScript("");
            } else {
                tgtworkflowNode.setScript(Joiner.on((String)"\n").join(codeLines));
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.EMR_SHELL.name(), (CharSequence)tgtworkflowNode.getNodeType())) {
            tgtworkflowNode.setScript(ShellShellConverter.wfToEmrCode(tgtworkflowNode));
        }
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }
}

