/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert.datax2di;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIJsonProcessor;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.AbstractDataxConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.DIType;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.Oss2OssForDataXReaderConverter;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class Oss2OssForDataXWriterConverter
extends AbstractDataxConverter {
    private static final Logger log = LoggerFactory.getLogger(Oss2OssForDataXWriterConverter.class);

    @Override
    public void convert(JSONObject readerJson, DIJsonProcessor readerJp) {
        String maxFileSize;
        JSONObject parameter = readerJson.getJSONObject("parameter");
        if (parameter == null) {
            log.warn("reader.parameter.can.not.be.null");
            return;
        }
        String endpoint = parameter.containsKey((Object)"endpoint") ? parameter.getString("endpoint") : "";
        String accessId = parameter.containsKey((Object)"accessId") ? parameter.getString("accessId") : "";
        String accessKey = parameter.containsKey((Object)"accessKey") ? parameter.getString("accessKey") : "";
        String bucket = parameter.containsKey((Object)"bucket") ? parameter.getString("bucket") : "";
        ArrayList object = new ArrayList();
        String writeMode = parameter.containsKey((Object)"writeMode") ? parameter.getString("writeMode") : "";
        ArrayList column = new ArrayList();
        String fieldDelimiter = parameter.containsKey((Object)"fieldDelimiter") ? parameter.getString("fieldDelimiter") : "";
        String encoding = parameter.containsKey((Object)"encoding") ? parameter.getString("encoding") : "utf-8";
        String nullFormat = parameter.containsKey((Object)"nullFormat") ? parameter.getString("nullFormat") : "\\N";
        ArrayList header = new ArrayList();
        String string = maxFileSize = parameter.containsKey((Object)"maxFileSize") ? parameter.getString("maxFileSize") : null;
        if (parameter.containsKey((Object)"object")) {
            parameter.getJSONArray("object").forEach(x -> object.add(x.toString()));
        }
        if (parameter.containsKey((Object)"column")) {
            parameter.getJSONArray("column").forEach(singleColumn -> column.add(new HashMap<String, Object>(){
                {
                    ((JSONObject)singleColumn).forEach((key, value) -> this.put(key, value));
                }
            }));
        }
        if (parameter.containsKey((Object)"header")) {
            parameter.getJSONArray("header").forEach(x -> header.add(x.toString()));
        }
        readerJp.set("stepType", (Object)DIType.OSS.getStepType());
        readerJp.set("parameter.datasource", (Object)bucket);
        readerJp.set("parameter.object", (Object)(CollectionUtils.isEmpty(object) ? new String[]{} : object.toArray()));
        readerJp.set("parameter.fieldDelimiter", (Object)fieldDelimiter);
        readerJp.set("parameter.encoding", (Object)encoding);
        readerJp.set("parameter.nullFormat", (Object)nullFormat);
        readerJp.set("parameter.header", (Object)(CollectionUtils.isEmpty(header) ? new String[]{} : header.toArray()));
        readerJp.set("parameter.maxFileSize", (Object)maxFileSize);
        readerJp.set("parameter.writeMode", (Object)writeMode);
        readerJp.set("parameter.column", (Object)parameter.getJSONObject("column"));
        readerJp.set("parameter.csvReaderConfig", (Object)parameter.getJSONObject("csvReaderConfig"));
        String fileFormat = parameter.containsKey((Object)"fileFormat") ? parameter.getString("fileFormat") : Oss2OssForDataXReaderConverter.fileFormatType.CSV.getType();
        readerJp.set("parameter.fileFormat", (Object)fileFormat);
        if (fileFormat.equals(Oss2OssForDataXReaderConverter.fileFormatType.PARQUET.getType()) || fileFormat.equals(Oss2OssForDataXReaderConverter.fileFormatType.PARQUET.getType().toUpperCase())) {
            String parquetSchema = parameter.containsKey((Object)"parquetSchema") ? parameter.getString("parquetSchema") : "";
            String path = parameter.containsKey((Object)"path") ? parameter.getString("path") : "";
            readerJp.set("parquetSchema", (Object)parquetSchema);
            readerJp.set("path", (Object)path);
        } else if (fileFormat.equals(Oss2OssForDataXReaderConverter.fileFormatType.ORC.getType()) || fileFormat.equals(Oss2OssForDataXReaderConverter.fileFormatType.ORC.getType().toUpperCase())) {
            String path = parameter.containsKey((Object)"path") ? parameter.getString("path") : "";
            readerJp.set("path", (Object)path);
        }
    }

    protected static enum fileFormatType {
        TEXT("text"),
        CSV("csv"),
        ORC("orc"),
        SEQ("seq"),
        RC("rc"),
        PARQUET("parquet"),
        EXCEL("excel"),
        BINARY("binary");

        private final String type;

        private fileFormatType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

