/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert.datax2di;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIJsonProcessor;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.AbstractDataxConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.DIType;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class MySQL2MySQLForDataXReaderConverter
extends AbstractDataxConverter {
    private static final Logger log = LoggerFactory.getLogger(MySQL2MySQLForDataXReaderConverter.class);

    @Override
    public void convert(JSONObject readerJson, DIJsonProcessor readerJp) {
        Object[] objectArray;
        JSONObject connection;
        JSONObject parameter = readerJson.getJSONObject("parameter");
        if (parameter == null) {
            log.warn("reader.parameter.can.not.be.null");
            return;
        }
        ArrayList jdbcUrl = new ArrayList();
        ArrayList table = new ArrayList();
        ArrayList column = new ArrayList();
        String splitPk = parameter.containsKey((Object)"splitPk") ? parameter.getString("splitPk") : "";
        String where = parameter.containsKey((Object)"where") ? parameter.getString("where") : "";
        ArrayList querySql = new ArrayList();
        if (parameter.containsKey((Object)"connection")) {
            connection = (JSONObject)parameter.getJSONArray("connection").get(0);
            if (connection.containsKey((Object)"jdbcUrl")) {
                connection.getJSONArray("jdbcUrl").forEach(x -> jdbcUrl.add(x.toString()));
            }
            if (connection.containsKey((Object)"table")) {
                connection.getJSONArray("table").forEach(x -> table.add(x.toString()));
            }
            if (connection.containsKey((Object)"querySql")) {
                connection.getJSONArray("querySql").forEach(x -> querySql.add(x.toString()));
            }
        }
        if (parameter.containsKey((Object)"column")) {
            parameter.getJSONArray("column").forEach(x -> column.add(x.toString()));
        }
        readerJp.set("stepType", (Object)DIType.MYSQL.getStepType());
        readerJp.set("parameter.splitPk", (Object)(StringUtils.isNotBlank((CharSequence)splitPk) ? splitPk : ""));
        readerJp.set("parameter.where", (Object)(StringUtils.isNotBlank((CharSequence)where) ? where : ""));
        if (CollectionUtils.isEmpty(column)) {
            String[] stringArray = new String[1];
            objectArray = stringArray;
            stringArray[0] = "*";
        } else {
            objectArray = column.toArray();
        }
        readerJp.set("parameter.column", (Object)objectArray);
        connection = new JSONArray();
        JSONObject singleConnection = new JSONObject();
        singleConnection.put("table", (Object)(CollectionUtils.isEmpty(table) ? new String[]{} : null));
        singleConnection.put("querySql", (Object)(CollectionUtils.isEmpty(querySql) ? new String[]{} : querySql.toArray()));
        singleConnection.put("datasource", (Object)this.getDatabaseFromUrl((String)jdbcUrl.get(0)));
        connection.add((Object)singleConnection);
        readerJp.set("parameter.connection", (Object)connection);
    }
}

