/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert.datax2di;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIJsonProcessor;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.AbstractDataxConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.DataxType;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

class DefaultDataxWriterConverter
extends AbstractDataxConverter {
    DefaultDataxWriterConverter() {
    }

    @Override
    public void convert(JSONObject writerJson, DIJsonProcessor writerJp) {
        Object[] objectArray;
        JSONObject parameter = writerJson.getJSONObject("parameter");
        String writeMode = parameter.getString("writeMode");
        JSONArray column = parameter.getJSONArray("column");
        ArrayList columns = new ArrayList();
        if (Objects.nonNull(column)) {
            column.forEach(x -> columns.add(x.toString()));
        }
        String preSql = parameter.getString("preSql");
        String postSql = parameter.getString("postSql");
        JSONArray connection = parameter.getJSONArray("connection");
        if (Objects.nonNull(connection)) {
            JSONObject connectionJSONObject = connection.getJSONObject(0);
            String jdbcUrls = connectionJSONObject.getString("jdbcUrl");
            String databaseFromUrl = this.getDatabaseFromUrl(jdbcUrls);
            JSONArray tables = connectionJSONObject.getJSONArray("table");
            String table = tables.getString(0);
            writerJp.set("parameter.table", (Object)table);
            writerJp.set("parameter.datasource", (Object)databaseFromUrl);
        }
        writerJp.set("stepType", (Object)DataxType.MYSQL.getType());
        if (StringUtils.isNotBlank((CharSequence)preSql)) {
            writerJp.set("parameter.preSql", (Object)new String[]{preSql});
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{postSql})) {
            writerJp.set("parameter.postSql", (Object)new String[]{postSql});
        }
        if (CollectionUtils.isEmpty(columns)) {
            String[] stringArray = new String[1];
            objectArray = stringArray;
            stringArray[0] = "*";
        } else {
            objectArray = columns.toArray();
        }
        writerJp.set("parameter.column", (Object)objectArray);
        writerJp.set("parameter.writeMode", (Object)writeMode);
    }
}

