/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert.datax2di;

import com.aliyun.migration.workflow.migration.common.convert.datax2di.AbstractDataxConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.ClickHouse2ClickHouseForDataXWriterConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.DataxType;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.DefaultDataxWriterConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.Hdfs2HdfsForDataXWriterConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.MongoDB2MongoDBForDataXWriterConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.MySQL2MySQLForDataXWriterConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.Odps2OdpsForDataXWriterConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.Oracle2OracleForDataXWriterConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.Oss2OssForDataXWriterConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.PostgreSQL2PostgreSQLForDataXWriterConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.SqlServer2SqlServerForDataXWriterConverter;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import java.util.HashMap;
import java.util.Map;

public class DataxWriterConvertFactory {
    private BwmConfiguration writerConfiguration;

    public DataxWriterConvertFactory(BwmConfiguration bwmConfiguration) {
        this.writerConfiguration = bwmConfiguration;
    }

    public AbstractDataxConverter getWriterConvert(String writeName) {
        Map<String, Object> configurationMap = this.writerConfiguration.getMap("self", new HashMap<String, Object>());
        BwmConfiguration dataxConfiguration = BwmConfiguration.from(configurationMap.getOrDefault("datax.datasource.map", "{}").toString());
        DataxType dataxType = DataxType.getTypeByWriterName(writeName);
        String resTypeStr = dataxConfiguration.getString(dataxType.getType(), dataxType.getType());
        DataxType resType = DataxType.getTypeByName(resTypeStr);
        switch (resType) {
            case MYSQL: {
                return new MySQL2MySQLForDataXWriterConverter();
            }
            case POSTGRESQL: {
                return new PostgreSQL2PostgreSQLForDataXWriterConverter();
            }
            case ORACLE: {
                return new Oracle2OracleForDataXWriterConverter();
            }
            case SQLSERVER: {
                return new SqlServer2SqlServerForDataXWriterConverter();
            }
            case ODPS: {
                return new Odps2OdpsForDataXWriterConverter();
            }
            case OSS: {
                return new Oss2OssForDataXWriterConverter();
            }
            case HIVE: 
            case HDFS: {
                return new Hdfs2HdfsForDataXWriterConverter();
            }
            case CLICKHOUSE: {
                return new ClickHouse2ClickHouseForDataXWriterConverter();
            }
            case MONGODB: {
                return new MongoDB2MongoDBForDataXWriterConverter();
            }
        }
        return new DefaultDataxWriterConverter();
    }
}

