/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.context;

import org.springframework.aop.framework.AopContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Lazy(value=false)
public class ApplicationContextUtil
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private static ConfigurableListableBeanFactory beanFactory;
    private static ApplicationContext applicationContext;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ApplicationContextUtil.beanFactory = beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ApplicationContextUtil.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static <T> T getBean(String name) {
        return (T)beanFactory.getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)ApplicationContextUtil.getApplicationContext().getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)ApplicationContextUtil.getApplicationContext().getBean(name, clazz);
    }

    public static boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return beanFactory.isSingleton(name);
    }

    public static Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return beanFactory.getType(name);
    }

    public static <T> T getAopProxy(T invoker) {
        return (T)AopContext.currentProxy();
    }

    public static String[] getActiveProfiles() {
        return ApplicationContextUtil.getEnvironment().getActiveProfiles();
    }

    public static Environment getEnvironment() {
        return applicationContext.getEnvironment();
    }

    public static String getActiveProfile() {
        String[] activeProfiles = ApplicationContextUtil.getActiveProfiles();
        return activeProfiles.length != 0 ? activeProfiles[0] : null;
    }
}

