/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.config;

import com.alibaba.fastjson2.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WriterProjectMappingRule {
    private FilterType filterType;
    private String projectId;
    private String projectName;
    private List<String> idExpressionList;
    private List<String> nameExpressionList;

    public WriterProjectMappingRule parseJSON(String jsonStr) {
        JSONObject ruleObject;
        try {
            ruleObject = JSONObject.parseObject((String)jsonStr);
        }
        catch (Exception e) {
            return null;
        }
        if (!ruleObject.containsKey("filter_type")) {
            return null;
        }
        this.filterType = FilterType.valueOf(ruleObject.getString("filter_type"));
        if (!ruleObject.containsKey("project_id")) {
            return null;
        }
        this.projectId = ruleObject.getString("project_id");
        if (ruleObject.containsKey("project_name")) {
            this.projectName = ruleObject.getString("project_name");
        }
        if (!this.filterType.equals((Object)FilterType.DEFAULT)) {
            if (ruleObject.containsKey("id_exp")) {
                String nodeIds = ruleObject.getString("id_exp");
                this.idExpressionList = new ArrayList<String>();
                Arrays.stream(nodeIds.split(",")).forEach(id -> this.idExpressionList.add(id.trim()));
            } else if (ruleObject.containsKey("name_exp")) {
                String nodeNames = ruleObject.getString("name_exp");
                this.nameExpressionList = new ArrayList<String>();
                Arrays.stream(nodeNames.split(",")).forEach(name -> this.nameExpressionList.add(name.trim()));
            } else {
                return null;
            }
        }
        return this;
    }

    public Boolean matchId(String str) {
        if (this.idExpressionList == null || this.idExpressionList.isEmpty()) {
            return false;
        }
        return this.idExpressionList.contains(str);
    }

    public Boolean matchName(String str) {
        if (this.nameExpressionList == null || this.nameExpressionList.isEmpty()) {
            return false;
        }
        if (this.nameExpressionList.contains(str)) {
            return true;
        }
        for (String regex : this.nameExpressionList) {
            if (!WriterProjectMappingRule.doesMatch(regex, str)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesMatch(String regex, String string) {
        if (regex == null || string == null) {
            return false;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public List<String> getIdExpressionList() {
        return this.idExpressionList;
    }

    public List<String> getNameExpressionList() {
        return this.nameExpressionList;
    }

    public static enum FilterType {
        NODE,
        WORKFLOW,
        DEFAULT;

    }
}

