/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.config;

import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.config.FilterRule;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FilterRuleGroup {
    private List<FilterRule> filterRuleList;

    public List<FilterRule> getFilterRuleList() {
        return this.filterRuleList;
    }

    public void setFilterRuleList(List<FilterRule> filterRuleList) {
        this.filterRuleList = filterRuleList;
    }

    public Boolean isMatch(Object obj) {
        if (obj instanceof WorkflowNode) {
            return this.isMatchNode((WorkflowNode)obj);
        }
        if (obj instanceof Workflow) {
            return this.isMatchWorkflow((Workflow)obj);
        }
        return true;
    }

    public Boolean isMatchNode(WorkflowNode node) {
        if (this.filterRuleList == null || this.filterRuleList.isEmpty()) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)node.getWorkflowId()) && StringUtils.isNotBlank((CharSequence)node.getWorkflowName())) {
            Boolean isWorkflowMatch = null;
            for (FilterRule filterRule : this.filterRuleList) {
                if (!filterRule.getElement().equals((Object)FilterRule.FilterElement.WORKFLOW)) continue;
                isWorkflowMatch = filterRule.isMatch(node.getWorkflowId(), node.getWorkflowName());
                break;
            }
            if (isWorkflowMatch != null && !isWorkflowMatch.booleanValue()) {
                return false;
            }
        }
        for (FilterRule filterRule : this.filterRuleList) {
            if (!filterRule.getElement().equals((Object)FilterRule.FilterElement.NODE)) continue;
            return filterRule.isMatch(node.getNodeId(), node.getNodeName());
        }
        return true;
    }

    public Boolean isMatchWorkflow(Workflow wf) {
        if (this.filterRuleList == null || this.filterRuleList.isEmpty()) {
            return true;
        }
        for (FilterRule filterRule : this.filterRuleList) {
            if (!filterRule.getElement().equals((Object)FilterRule.FilterElement.WORKFLOW)) continue;
            return filterRule.isMatch(wf.getWorkflowId(), wf.getWorkflowName());
        }
        return true;
    }
}

