/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.config;

import com.aliyun.migration.api.constant.BwmOperationStageType;
import com.aliyun.migration.api.utils.UuidUtils;
import com.aliyun.migration.teleport.cloud.entity.ExecutionRuntimeProperties;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BwmSaasConfiguration {
    private BwmOperationStageType stageType;
    private Meta meta;
    private Oss oss;
    private Mns mns;
    private Local local;
    private ExecutionRuntimeProperties runtimeProperties;

    public void setMetaVersion() {
        this.meta.setMetaVersion(UuidUtils.randomUuidByObject((Object)this.meta));
    }

    public String setMetaVersion(String metaVersion) {
        this.meta.setMetaVersion(metaVersion);
        return metaVersion;
    }

    public String getMigrationPackageZipSavePath() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.local.getOutputFileSaveRootPath()).append("/").append(this.meta.getTenantUuid()).append("/migration").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceChainUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion()).append("/package.zip");
        return sb.toString();
    }

    public String getMigrationPackageZipOssPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.oss.getRootPath()).append("/").append(this.meta.getTenantUuid()).append("/migration").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceChainUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion()).append("/package.zip");
        return sb.toString();
    }

    public String getMergeConflictXlsSavePath() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.local.getOutputFileSaveRootPath()).append("/").append(this.meta.getTenantUuid()).append("/migration").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceChainUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion()).append("/merge.xls");
        return sb.toString();
    }

    public String getMergeConflictXlsOssPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.oss.getRootPath()).append("/").append(this.meta.getTenantUuid()).append("/migration").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceChainUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion()).append("/merge.xls");
        return sb.toString();
    }

    public String getDiscoveryDiffXlsSavePath(String projectId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.local.getOutputFileSaveRootPath()).append("/").append(this.meta.getTenantUuid()).append("/discovery").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion());
        if (!StringUtils.isEmpty((CharSequence)projectId)) {
            sb.append("/").append(projectId);
        }
        sb.append("/diff.xls");
        return sb.toString();
    }

    public String getDiscoveryDiffXlsOssPath(String projectId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.oss.getRootPath()).append("/").append(this.meta.getTenantUuid()).append("/discovery").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion());
        if (!StringUtils.isEmpty((CharSequence)projectId)) {
            sb.append("/").append(projectId);
        }
        sb.append("/diff.xls");
        return sb.toString();
    }

    public String getDiscoveryApiOutputPackageZipSavePath(String projectId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.local.getOutputFileSaveRootPath()).append("/").append(this.meta.getTenantUuid()).append("/discovery").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion());
        if (!StringUtils.isEmpty((CharSequence)projectId)) {
            sb.append("/").append(projectId);
        }
        sb.append("/api_output_package.zip");
        return sb.toString();
    }

    public String getDiscoveryApiOutputPackageZipOssPath(String projectId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.oss.getRootPath()).append("/").append(this.meta.getTenantUuid()).append("/discovery").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion());
        if (!StringUtils.isEmpty((CharSequence)projectId)) {
            sb.append("/").append(projectId);
        }
        sb.append("/api_output_package.zip");
        return sb.toString();
    }

    public String getDiscoveryPackageZipSavePath(String projectId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.local.getOutputFileSaveRootPath()).append("/").append(this.meta.getTenantUuid()).append("/discovery").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion());
        if (!StringUtils.isEmpty((CharSequence)projectId)) {
            sb.append("/").append(projectId);
        }
        sb.append("/package.zip");
        return sb.toString();
    }

    public String getDiscoveryPackageZipOssPath(String projectId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.oss.getRootPath()).append("/").append(this.meta.getTenantUuid()).append("/discovery").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion());
        if (!StringUtils.isEmpty((CharSequence)projectId)) {
            sb.append("/").append(projectId);
        }
        sb.append("/package.zip");
        return sb.toString();
    }

    public String getMigrationLogFileSavePath() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.local.getOutputFileSaveRootPath()).append("/").append(this.meta.getTenantUuid()).append("/migration").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceChainUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion()).append("/logs");
        return sb.toString();
    }

    public String getMigrationLogFileOssPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.oss.getRootPath()).append("/").append(this.meta.getTenantUuid()).append("/migration").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceChainUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion()).append("/logs");
        return sb.toString();
    }

    public String getDiscoveryLogFileSavePath(String projectId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.local.getOutputFileSaveRootPath()).append("/").append(this.meta.getTenantUuid()).append("/discovery").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion());
        if (!StringUtils.isEmpty((CharSequence)projectId)) {
            sb.append("/").append(projectId);
        }
        sb.append("/logs");
        return sb.toString();
    }

    public String getDiscoveryLogFileOssPath(String projectId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.oss.getRootPath()).append("/").append(this.meta.getTenantUuid()).append("/discovery").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion());
        if (!StringUtils.isEmpty((CharSequence)projectId)) {
            sb.append("/").append(projectId);
        }
        sb.append("/logs");
        return sb.toString();
    }

    public String getMigrationInstanceStatusFileOssPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.oss.getRootPath()).append("/").append(this.meta.getTenantUuid()).append("/migration").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceChainUuid()).append("/").append(this.meta.getInstanceUuid()).append("/status.json");
        return sb.toString();
    }

    public String getDiscoveryInstanceStatusFileOssPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.oss.getRootPath()).append("/").append(this.meta.getTenantUuid()).append("/discovery").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceUuid()).append("/status.json");
        return sb.toString();
    }

    public String getMigrationSrSnapshotFileSavePath(String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.local.getOutputFileSaveRootPath()).append("/").append(this.meta.getTenantUuid()).append("/sr").append("/").append(tableName).append("/migration").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceChainUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion()).append("/snapshot.json");
        return sb.toString();
    }

    public String getMigrationSrSnapshotFileOssPath(String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.oss.getRootPath()).append("/").append(this.meta.getTenantUuid()).append("/sr").append("/").append(tableName).append("/migration").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceChainUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion()).append("/snapshot.json");
        return sb.toString();
    }

    public String getDiscoverySrSnapshotFileSavePath(String tableName, String projectId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.local.getOutputFileSaveRootPath()).append("/").append(this.meta.getTenantUuid()).append("/sr").append("/").append(tableName).append("/discovery").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion());
        if (!StringUtils.isEmpty((CharSequence)projectId)) {
            sb.append("/").append(projectId);
        }
        sb.append("/snapshot.json");
        return sb.toString();
    }

    public String getDiscoverySrSnapshotFileOssPath(String tableName, String projectId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.oss.getRootPath()).append("/").append(this.meta.getTenantUuid()).append("/sr").append("/").append(tableName).append("/discovery").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion());
        if (!StringUtils.isEmpty((CharSequence)projectId)) {
            sb.append("/").append(projectId);
        }
        sb.append("/snapshot.json");
        return sb.toString();
    }

    public String getMigrationSrStatisticsFileSavePath(String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.local.getOutputFileSaveRootPath()).append("/").append(this.meta.getTenantUuid()).append("/sr").append("/").append(tableName).append("/migration").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceChainUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion()).append("/statistics.json");
        return sb.toString();
    }

    public String getMigrationSrStatisticsFileOssPath(String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.oss.getRootPath()).append("/").append(this.meta.getTenantUuid()).append("/sr").append("/").append(tableName).append("/migration").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceChainUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion()).append("/statistics.json");
        return sb.toString();
    }

    public String getDiscoverySrStatisticsFileSavePath(String tableName, String projectId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.local.getOutputFileSaveRootPath()).append("/").append(this.meta.getTenantUuid()).append("/sr").append("/").append(tableName).append("/discovery").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion());
        if (!StringUtils.isEmpty((CharSequence)projectId)) {
            sb.append("/").append(projectId);
        }
        sb.append("/statistics.json");
        return sb.toString();
    }

    public String getDiscoverySrStatisticsFileOssPath(String tableName, String projectId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.oss.getRootPath()).append("/").append(this.meta.getTenantUuid()).append("/sr").append("/").append(tableName).append("/discovery").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(this.meta.getMetaVersion());
        if (!StringUtils.isEmpty((CharSequence)projectId)) {
            sb.append("/").append(projectId);
        }
        sb.append("/statistics.json");
        return sb.toString();
    }

    public String getOssSqlConversionFileSavePath(String tenantId, String taskUuid, String instanceUuid, String scriptId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.oss.getRootPath()).append("/").append(this.meta.getTenantUuid()).append("/migration").append("/sqlconversion").append("/").append(this.meta.getTaskUuid()).append("/").append(this.meta.getInstanceUuid()).append("/").append(scriptId).append(".script");
        return sb.toString();
    }

    public BwmOperationStageType getStageType() {
        return this.stageType;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public Oss getOss() {
        return this.oss;
    }

    public Mns getMns() {
        return this.mns;
    }

    public Local getLocal() {
        return this.local;
    }

    public ExecutionRuntimeProperties getRuntimeProperties() {
        return this.runtimeProperties;
    }

    public void setStageType(BwmOperationStageType stageType) {
        this.stageType = stageType;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public void setOss(Oss oss) {
        this.oss = oss;
    }

    public void setMns(Mns mns) {
        this.mns = mns;
    }

    public void setLocal(Local local) {
        this.local = local;
    }

    public void setRuntimeProperties(ExecutionRuntimeProperties runtimeProperties) {
        this.runtimeProperties = runtimeProperties;
    }

    public static class Meta {
        private String tenantUuid;
        private String taskUuid;
        private String instanceChainUuid;
        private String instanceUuid;
        private String metaVersion;
        private Long scheduleDatasourceUuid;
        private InputFile inputMetaVersion;

        public String getTenantUuid() {
            return this.tenantUuid;
        }

        public String getTaskUuid() {
            return this.taskUuid;
        }

        public String getInstanceChainUuid() {
            return this.instanceChainUuid;
        }

        public String getInstanceUuid() {
            return this.instanceUuid;
        }

        public String getMetaVersion() {
            return this.metaVersion;
        }

        public Long getScheduleDatasourceUuid() {
            return this.scheduleDatasourceUuid;
        }

        public InputFile getInputMetaVersion() {
            return this.inputMetaVersion;
        }

        public void setTenantUuid(String tenantUuid) {
            this.tenantUuid = tenantUuid;
        }

        public void setTaskUuid(String taskUuid) {
            this.taskUuid = taskUuid;
        }

        public void setInstanceChainUuid(String instanceChainUuid) {
            this.instanceChainUuid = instanceChainUuid;
        }

        public void setInstanceUuid(String instanceUuid) {
            this.instanceUuid = instanceUuid;
        }

        public void setMetaVersion(String metaVersion) {
            this.metaVersion = metaVersion;
        }

        public void setScheduleDatasourceUuid(Long scheduleDatasourceUuid) {
            this.scheduleDatasourceUuid = scheduleDatasourceUuid;
        }

        public void setInputMetaVersion(InputFile inputMetaVersion) {
            this.inputMetaVersion = inputMetaVersion;
        }
    }

    public static class Local {
        private InputFile inputFileReadPath;
        private String outputFileSaveRootPath;

        public void useDefault(String rootPath) {
            this.useDefaultInputFileReadPath(rootPath);
            this.setOutputFileSaveRootPath(rootPath + "/output");
        }

        public void useDefaultInputFileReadPath(String rootPath) {
            this.inputFileReadPath = new InputFile();
            this.inputFileReadPath.setMainPackage(rootPath + "/input/mainPackage.zip");
            this.inputFileReadPath.setMainPackageExtendedScriptFolder(rootPath + "/input/mainPackageExtendedScriptFolder");
            this.inputFileReadPath.setMxReaderOutputPackage(rootPath + "/input/mxReaderOutput.zip");
            this.inputFileReadPath.setOldReaderOutputPackage(rootPath + "/input/oldReaderOutput.zip");
            this.inputFileReadPath.setNewReaderOutputPackage(rootPath + "/input/newReaderOutput.zip");
            this.inputFileReadPath.setOldConverterOutputPackage(rootPath + "/input/oldConverterOutput.zip");
            this.inputFileReadPath.setOldConverterOutputPackageExtendedScriptFolder(rootPath + "/input/oldConverterOutputPackageExtendedScriptFolder");
            this.inputFileReadPath.setNewConverterOutputPackage(rootPath + "/input/newConverterOutput.zip");
            this.inputFileReadPath.setNewConverterOutputPackageExtendedScriptFolder(rootPath + "/input/newConverterOutputPackageExtendedScriptFolder");
            this.inputFileReadPath.setOldWriterOutputPackage(rootPath + "/input/oldWriterOutput.zip");
            this.inputFileReadPath.setNewDataWorksReaderOutputPackage(rootPath + "/input/newDataWorksReaderOutput.zip");
            this.inputFileReadPath.setModifyXls(rootPath + "/input/modify.xls");
            this.inputFileReadPath.setMergeXls(rootPath + "/input/merge.xls");
        }

        public InputFile getInputFileReadPath() {
            return this.inputFileReadPath;
        }

        public String getOutputFileSaveRootPath() {
            return this.outputFileSaveRootPath;
        }

        public void setInputFileReadPath(InputFile inputFileReadPath) {
            this.inputFileReadPath = inputFileReadPath;
        }

        public void setOutputFileSaveRootPath(String outputFileSaveRootPath) {
            this.outputFileSaveRootPath = outputFileSaveRootPath;
        }
    }

    public static class Oss {
        private String endpoint;
        private String ak;
        private String sk;
        private String bucket;
        private String rootPath;
        private Map<String, String> downloadPackageToLocal;

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getAk() {
            return this.ak;
        }

        public String getSk() {
            return this.sk;
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getRootPath() {
            return this.rootPath;
        }

        public Map<String, String> getDownloadPackageToLocal() {
            return this.downloadPackageToLocal;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setAk(String ak) {
            this.ak = ak;
        }

        public void setSk(String sk) {
            this.sk = sk;
        }

        public void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public void setRootPath(String rootPath) {
            this.rootPath = rootPath;
        }

        public void setDownloadPackageToLocal(Map<String, String> downloadPackageToLocal) {
            this.downloadPackageToLocal = downloadPackageToLocal;
        }
    }

    public static class Mns {
        private String endpoint;
        private String ak;
        private String sk;
        private String topicName;

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getAk() {
            return this.ak;
        }

        public String getSk() {
            return this.sk;
        }

        public String getTopicName() {
            return this.topicName;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setAk(String ak) {
            this.ak = ak;
        }

        public void setSk(String sk) {
            this.sk = sk;
        }

        public void setTopicName(String topicName) {
            this.topicName = topicName;
        }
    }

    public static class InputFile {
        private String mainPackage;
        private String mainPackageExtendedScriptFolder;
        private String mxReaderOutputPackage;
        private String oldReaderOutputPackage;
        private String newReaderOutputPackage;
        private String oldConverterOutputPackage;
        private String oldConverterOutputPackageExtendedScriptFolder;
        private String newConverterOutputPackage;
        private String newConverterOutputPackageExtendedScriptFolder;
        private String oldWriterOutputPackage;
        private String newDataWorksReaderOutputPackage;
        private String mergeXls;
        private String modifyXls;

        public String getMainPackage() {
            return this.mainPackage;
        }

        public String getMainPackageExtendedScriptFolder() {
            return this.mainPackageExtendedScriptFolder;
        }

        public String getMxReaderOutputPackage() {
            return this.mxReaderOutputPackage;
        }

        public String getOldReaderOutputPackage() {
            return this.oldReaderOutputPackage;
        }

        public String getNewReaderOutputPackage() {
            return this.newReaderOutputPackage;
        }

        public String getOldConverterOutputPackage() {
            return this.oldConverterOutputPackage;
        }

        public String getOldConverterOutputPackageExtendedScriptFolder() {
            return this.oldConverterOutputPackageExtendedScriptFolder;
        }

        public String getNewConverterOutputPackage() {
            return this.newConverterOutputPackage;
        }

        public String getNewConverterOutputPackageExtendedScriptFolder() {
            return this.newConverterOutputPackageExtendedScriptFolder;
        }

        public String getOldWriterOutputPackage() {
            return this.oldWriterOutputPackage;
        }

        public String getNewDataWorksReaderOutputPackage() {
            return this.newDataWorksReaderOutputPackage;
        }

        public String getMergeXls() {
            return this.mergeXls;
        }

        public String getModifyXls() {
            return this.modifyXls;
        }

        public void setMainPackage(String mainPackage) {
            this.mainPackage = mainPackage;
        }

        public void setMainPackageExtendedScriptFolder(String mainPackageExtendedScriptFolder) {
            this.mainPackageExtendedScriptFolder = mainPackageExtendedScriptFolder;
        }

        public void setMxReaderOutputPackage(String mxReaderOutputPackage) {
            this.mxReaderOutputPackage = mxReaderOutputPackage;
        }

        public void setOldReaderOutputPackage(String oldReaderOutputPackage) {
            this.oldReaderOutputPackage = oldReaderOutputPackage;
        }

        public void setNewReaderOutputPackage(String newReaderOutputPackage) {
            this.newReaderOutputPackage = newReaderOutputPackage;
        }

        public void setOldConverterOutputPackage(String oldConverterOutputPackage) {
            this.oldConverterOutputPackage = oldConverterOutputPackage;
        }

        public void setOldConverterOutputPackageExtendedScriptFolder(String oldConverterOutputPackageExtendedScriptFolder) {
            this.oldConverterOutputPackageExtendedScriptFolder = oldConverterOutputPackageExtendedScriptFolder;
        }

        public void setNewConverterOutputPackage(String newConverterOutputPackage) {
            this.newConverterOutputPackage = newConverterOutputPackage;
        }

        public void setNewConverterOutputPackageExtendedScriptFolder(String newConverterOutputPackageExtendedScriptFolder) {
            this.newConverterOutputPackageExtendedScriptFolder = newConverterOutputPackageExtendedScriptFolder;
        }

        public void setOldWriterOutputPackage(String oldWriterOutputPackage) {
            this.oldWriterOutputPackage = oldWriterOutputPackage;
        }

        public void setNewDataWorksReaderOutputPackage(String newDataWorksReaderOutputPackage) {
            this.newDataWorksReaderOutputPackage = newDataWorksReaderOutputPackage;
        }

        public void setMergeXls(String mergeXls) {
            this.mergeXls = mergeXls;
        }

        public void setModifyXls(String modifyXls) {
            this.modifyXls = modifyXls;
        }
    }
}

