/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.bean;

import com.aliyun.migration.workflow.migration.common.bean.BwmJsonArray;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BwmJsonObject
extends JSONObject {
    private static final Logger log = LoggerFactory.getLogger(BwmJsonObject.class);

    public BwmJsonObject() {
    }

    public BwmJsonObject(Map<?, ?> m) {
        super(m);
    }

    public BwmJsonObject(Object bean) {
        super(bean);
    }

    public BwmJsonObject(String source) throws JSONException {
        super(source);
    }

    public BwmJsonObject(JSONObject jo, String ... names) {
        super(jo, names);
    }

    public BwmJsonObject(JSONTokener x) throws JSONException {
        super(x);
    }

    public BwmJsonObject(Object object, String ... names) {
        super(object, names);
    }

    public BwmJsonObject(String baseName, Locale locale) throws JSONException {
        super(baseName, locale);
    }

    public Object get(String key) {
        try {
            return super.get(key);
        }
        catch (JSONException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public Double getDoubleWrap(String key) {
        try {
            return super.getDouble(key);
        }
        catch (JSONException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public Float getFloatWrap(String key) {
        try {
            return Float.valueOf(super.getFloat(key));
        }
        catch (JSONException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public Integer getIntWrap(String key) {
        try {
            return super.getInt(key);
        }
        catch (JSONException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public boolean getBoolean(String key) throws JSONException {
        Object object = this.get(key);
        if (!(Boolean.FALSE.equals(object) || object instanceof String && ((String)object).equalsIgnoreCase("false"))) {
            if (!(Boolean.TRUE.equals(object) || object instanceof String && ((String)object).equalsIgnoreCase("true"))) {
                throw BwmJsonObject.wrongValueFormatException(key, "Boolean", null);
            }
            return true;
        }
        return false;
    }

    private static JSONException wrongValueFormatException(String key, String valueType, Throwable cause) {
        return new JSONException("JSONObject[" + BwmJsonObject.quote((String)key) + "] is not a " + valueType + ".", cause);
    }

    public Boolean getBooleanWrap(String key) {
        try {
            return this.getBoolean(key);
        }
        catch (JSONException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public BwmJsonArray getJsonArrayWrap(String key) {
        try {
            Object object = this.get(key);
            if (object instanceof BwmJsonArray) {
                return (BwmJsonArray)((Object)object);
            }
            if (object instanceof JSONArray) {
                BwmJsonArray array = new BwmJsonArray(BwmJsonUtil.toJsonString(object));
                this.put(key, (Object)array);
                return array;
            }
            throw new JSONException("JSONObjet[" + key + "] is not a BwmJsonArray.", null);
        }
        catch (JSONException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public BwmJsonObject getJsonObjectWrap(String key) {
        try {
            Object object = this.get(key);
            if (object instanceof BwmJsonObject) {
                return (BwmJsonObject)((Object)object);
            }
            if (object instanceof JSONObject) {
                BwmJsonObject BwmJsonObject2 = new BwmJsonObject(BwmJsonUtil.toJsonString(object));
                this.put(key, (Object)BwmJsonObject2);
                return BwmJsonObject2;
            }
            throw new JSONException("JSONObjet[" + key + "] is not a BwmJsonObject.", null);
        }
        catch (JSONException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public Long getLongWrap(String key) {
        try {
            return super.getLong(key);
        }
        catch (JSONException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public String getStringWrap(String key) {
        try {
            Object value = this.get(key);
            if (value == null) {
                return null;
            }
            return value.toString();
        }
        catch (JSONException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public String toJsonString() {
        return BwmJsonUtil.toJsonString((Object)this);
    }
}

