/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks.client.command.CommandApp;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DataWorksPackage;
import com.aliyun.dataworks.migrationx.transformer.dataworks.apps.DataWorksAdfTransformerApp;
import com.aliyun.dataworks.migrationx.transformer.dataworks.apps.DataWorksAirflowV2TransformerApp;
import com.aliyun.dataworks.migrationx.transformer.dataworks.apps.DataWorksDolphinschedulerTransformerApp;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.StatisticOp;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.api.plugin.Converter;
import com.aliyun.migration.spec.domain.dataworks.CycleWorkflowSingleSpec;
import com.aliyun.migration.spec.domain.dataworks.common.DependencySingleSpec;
import com.aliyun.migration.spec.domain.dataworks.common.output.NodeOutputSpec;
import com.aliyun.migration.spec.domain.dataworks.common.output.OutputBatchSpec;
import com.aliyun.migration.spec.domain.dataworks.node.NodeSingleSpec;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.migration.common.DataworksConverter;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvert;
import com.aliyun.migration.workflow.migration.common.convert.DwSpec2WorkflowConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataworksMxConverter
extends DataworksConverter {
    private static final Logger log = LoggerFactory.getLogger(DataworksMxConverter.class);
    protected String mxConfigStr;
    protected String tempFilePath;
    protected String mxConfigFilePath;
    protected String mxSourceFilePath;
    protected String mxOutputPath;
    protected String tempTaskId;
    protected DwSpec2WorkflowConvert dwSpec2WorkflowConvert;

    @Override
    public Converter init(TaskContext taskContext) throws IOException {
        super.init(taskContext);
        Datasource readerDatasource = taskContext.getReaderDatasource();
        Map readerDatasourceProperties = readerDatasource.getProperties();
        this.mxSourceFilePath = (String)readerDatasourceProperties.get("source-file-path");
        this.tempTaskId = UUID.randomUUID().toString();
        taskContext.setTaskId(this.tempTaskId);
        this.tempFilePath = "data/tmp/" + taskContext.getTaskId();
        this.mxOutputPath = this.tempFilePath;
        File tempFile = new File(this.tempFilePath);
        FileUtils.deleteDirectory((File)tempFile);
        FileUtils.forceMkdirParent((File)tempFile);
        FileUtils.forceMkdir((File)tempFile);
        BwmConfiguration bwmConfiguration = BwmConfiguration.from(taskContext.getBwmConfiguration());
        this.mxConfigStr = bwmConfiguration.getString("conf", "{}");
        File mxConfigFile = new File(tempFile, "mx_transform.json");
        FileUtils.writeStringToFile((File)mxConfigFile, (String)this.mxConfigStr, (Charset)StandardCharsets.UTF_8);
        this.mxConfigFilePath = mxConfigFile.getAbsolutePath();
        return this;
    }

    @Override
    protected DataWorksPackage convertUseMxTransform(String mxConfigFilePath, String sourceFilePath, String targetFilePath) {
        return null;
    }

    @Override
    public WorkflowProjectPackage convertUseMx() {
        WorkflowProjectPackage workflowProjectPackage = null;
        if (this.taskContext.getIsUserDataWorksFlowSpec().booleanValue()) {
            Pair<CommandApp, String[]> transformerAppAndArgs = this.getCommandApp();
            if (Objects.isNull(transformerAppAndArgs)) {
                return null;
            }
            CommandApp commandApp = (CommandApp)transformerAppAndArgs.getLeft();
            String[] args = (String[])transformerAppAndArgs.getRight();
            try {
                commandApp.run(args);
            }
            catch (Exception e) {
                log.info("user migrationx convert error ", (Throwable)e);
                throw new RuntimeException(e);
            }
            return this.dealNewMxResult();
        }
        DataWorksPackage dataWorksPackage = this.convertUseMxTransform(this.mxConfigFilePath, this.sourceFilePath, this.targetFilePath);
        if (Objects.isNull(dataWorksPackage)) {
            log.error("convert user mx res is null");
            return null;
        }
        workflowProjectPackage = this.dwSpec2WorkflowConvert.convertDwPackage2WorkflowPackage(dataWorksPackage);
        return workflowProjectPackage;
    }

    protected Pair<CommandApp, String[]> getCommandApp() {
        Datasource readerDatasource = this.taskContext.getReaderDatasource();
        Datasource.Type type = readerDatasource.getType();
        String version = readerDatasource.getVersion();
        if (version == null && readerDatasource.getProperties().containsKey("version")) {
            version = (String)readerDatasource.getProperties().get("version");
        }
        DataWorksAirflowV2TransformerApp commandApp = null;
        String[] args = null;
        if (type == Datasource.Type.DolphinScheduler) {
            if (version == null) {
                log.error("not support this convert by mx {} {}", (Object)type, (Object)version);
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.NOT_SUPPORTED, (String)(type + " not supoprt convert by mx"));
            }
            switch (version) {
                case "1.3.9": 
                case "2.0.0": 
                case "3.2.0": {
                    commandApp = new DataWorksDolphinschedulerTransformerApp();
                    args = new String[]{"-c", this.mxConfigFilePath, "-s", this.mxSourceFilePath, "-t", this.mxOutputPath};
                    break;
                }
                default: {
                    log.error("not support this convert by mx {} {}", (Object)type, (Object)version);
                    throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.NOT_SUPPORTED, (String)(type + " not supoprt convert by mx"));
                }
            }
        } else if (type == Datasource.Type.Airflow) {
            commandApp = new DataWorksAirflowV2TransformerApp();
            args = new String[]{"-d", this.mxSourceFilePath, "-o", this.mxOutputPath, "-m", this.mxConfigFilePath};
        } else if (type == Datasource.Type.Adf) {
            commandApp = new DataWorksAdfTransformerApp();
            args = new String[]{"-c", this.mxConfigFilePath, "-s", this.mxSourceFilePath, "-t", this.mxOutputPath};
        } else {
            log.error("not support this convert by mx");
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.NOT_SUPPORTED, (String)(type + " not supoprt convert by mx"));
        }
        Pair res = Pair.of((Object)commandApp, (Object)args);
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<WorkflowNode> convertSingleNode(Workflow workflow, WorkflowNode workflowNode) {
        log.info("Node Convert In process: {}", (Object)workflowNode.getNodeName());
        ArrayList<WorkflowNode> needConvertNodes = new ArrayList<WorkflowNode>();
        try {
            AbstractConvert<List<WorkflowNode>> convert;
            if (!BooleanUtils.isTrue((Boolean)this.taskContext.getIsUserMx())) {
                needConvertNodes.add(workflowNode);
                convert = this.convertFactory.getNodeListConvert(workflowNode.getNodeType(), this.taskContext, workflow);
                return DataworksMxConverter.convertAll(convert, needConvertNodes, workflowNode.getNodeId(), workflowNode.getNodeName(), this.taskContext.getStatisticOp().getWorkflowNodeTotalStatisticOp(), this.taskContext.getStatisticOp().getWorkflowNodeSuccessStatisticOp(), this.taskContext.getStatisticOp().getWorkflowNodeFailureStatisticOp());
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)workflowNode.getTempType(), (CharSequence)"custom")) {
                needConvertNodes.add(this.getCustomWorkflowNode(workflowNode));
                convert = this.convertFactory.getCustomNodeConvert(this.taskContext, workflowNode, workflow);
                return DataworksMxConverter.convertAll(convert, needConvertNodes, workflowNode.getNodeId(), workflowNode.getNodeName(), this.taskContext.getStatisticOp().getWorkflowNodeTotalStatisticOp(), this.taskContext.getStatisticOp().getWorkflowNodeSuccessStatisticOp(), this.taskContext.getStatisticOp().getWorkflowNodeFailureStatisticOp());
            }
            needConvertNodes.add(workflowNode);
            return needConvertNodes;
        }
        catch (Exception e) {
            log.error("get convert error", (Throwable)e);
            this.taskContext.getStatisticOp().getWorkflowNodeTotalStatisticOp().increment(1);
            this.taskContext.getStatisticOp().getWorkflowNodeFailureStatisticOp().incrementFailedOne(workflowNode.getNodeName(), e.getMessage());
            return null;
        }
    }

    @Override
    public void close() {
        super.close();
        try {
            FileUtils.deleteDirectory((File)new File(this.tempFilePath));
        }
        catch (IOException e) {
            log.error("delete temp file error", (Throwable)e);
        }
    }

    protected WorkflowProjectPackage dealNewMxResult() {
        WorkflowProjectPackage targetWorkflowProjectPackage = new WorkflowProjectPackage();
        String dataWorksPackage = this.getMxTransform2SpecJson();
        targetWorkflowProjectPackage.setWorkflowList(new ArrayList());
        ArrayList<CycleWorkflowSingleSpec> specList = new ArrayList<CycleWorkflowSingleSpec>();
        HashMap<String, String> mxWfIdOutputMap = new HashMap<String, String>();
        HashMap<String, String> mxNodeIdOutputMap = new HashMap<String, String>();
        for (Object workflowSpec : JSONArray.parseArray((String)dataWorksPackage, (JSONReader.Feature[])new JSONReader.Feature[0])) {
            if (workflowSpec instanceof JSONObject) {
                JSONObject workflowSpecJson = (JSONObject)workflowSpec;
                JSONObject specJson = workflowSpecJson.getJSONObject("spec");
                if (Objects.isNull(specJson)) {
                    log.error("workflow spec is null no need parse");
                    continue;
                }
                CycleWorkflowSingleSpec wfSpec = CycleWorkflowSingleSpec.getCycleWorkflowSingleSpec((String)((JSONObject)((JSONArray)specJson.get("workflows")).get(0)).toJSONString(new JSONWriter.Feature[0]));
                specList.add(wfSpec);
                mxWfIdOutputMap.put(wfSpec.getId(), ((NodeOutputSpec)wfSpec.getOutputs().getNodeOutputs().get(0)).getData());
                for (NodeSingleSpec nodeSpec : wfSpec.getNodes()) {
                    mxNodeIdOutputMap.put(nodeSpec.getId(), ((NodeOutputSpec)nodeSpec.getOutputs().getNodeOutputs().get(0)).getData());
                }
                continue;
            }
            log.error("workflow spec is not json, no need parse {}", workflowSpec);
        }
        for (CycleWorkflowSingleSpec wfSpec : specList) {
            for (NodeSingleSpec nodeSpec : wfSpec.getNodes()) {
                nodeSpec.setInputs(new OutputBatchSpec());
                nodeSpec.getInputs().setNodeOutputs(new ArrayList());
                wfSpec.getDependencies().stream().filter(depend -> depend.getNodeId().equals(nodeSpec.getId())).forEach(depend -> {
                    NodeOutputSpec nodeOutputSpec = new NodeOutputSpec();
                    nodeOutputSpec.setData(((DependencySingleSpec)depend.getDepends().get(0)).getOutput());
                    nodeOutputSpec.setRefTableName(((DependencySingleSpec)depend.getDepends().get(0)).getRefTableName());
                    nodeOutputSpec.setArtifactType("NodeOutput");
                    nodeSpec.getInputs().getNodeOutputs().add(nodeOutputSpec);
                });
            }
        }
        targetWorkflowProjectPackage.getWorkflowList().addAll(CycleWorkflowSingleSpec.getWorkflowList(specList));
        if (this.taskContext.getWorkflowProjectPackage() != null && this.taskContext.getWorkflowProjectPackage().getWorkflowProject() != null) {
            targetWorkflowProjectPackage.setWorkflowProject(this.taskContext.getWorkflowProjectPackage().getWorkflowProject());
        } else {
            targetWorkflowProjectPackage.setWorkflowProject(new WorkflowProject());
            targetWorkflowProjectPackage.getWorkflowProject().setName((String)this.taskContext.getReaderDatasource().getProperties().get("projectName"));
            targetWorkflowProjectPackage.getWorkflowProject().setProjectId((String)this.taskContext.getReaderDatasource().getProperties().get("projectId"));
        }
        if (this.taskContext.getWorkflowProjectPackage() == null) {
            this.taskContext.setWorkflowProjectPackage(this.getWorkflowPackage());
        }
        this.mxTransPair(this.taskContext.getWorkflowProjectPackage(), targetWorkflowProjectPackage);
        this.taskContext.setTargetWorkflowProjectPackage(targetWorkflowProjectPackage);
        this.taskContext.setWorkflowProjectPackage(targetWorkflowProjectPackage);
        return targetWorkflowProjectPackage;
    }

    protected String getMxTransform2SpecJson() {
        HashMap<String, String> workflowSpecs = new HashMap<String, String>();
        this.getAllFileContent(new File(this.mxOutputPath), workflowSpecs);
        StringBuilder sb = new StringBuilder();
        if (workflowSpecs.size() > 0) {
            sb.append("[");
            workflowSpecs.forEach((k, v) -> {
                sb.append((String)v);
                sb.deleteCharAt(sb.length() - 1);
                sb.append(",\n");
            });
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.append("]");
        }
        return sb.toString();
    }

    protected void getAllFileContent(File file, Map<String, String> fileContents) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files.length > 0) {
                Arrays.stream(files).forEach(f -> this.getAllFileContent((File)f, fileContents));
            }
        } else if (file.getName().endsWith(".json")) {
            fileContents.put(file.getName().substring(0, file.getName().length() - 5), this.readFileToString(file.getAbsolutePath()));
        }
    }

    protected String readFileToString(String filePath) {
        StringBuilder contentBuilder = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(filePath));){
            String currentLine;
            while ((currentLine = br.readLine()) != null) {
                contentBuilder.append(currentLine).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contentBuilder.toString();
    }

    protected void mxTransPair(WorkflowProjectPackage pkg, WorkflowProjectPackage resultPkg) {
        if (pkg == null || resultPkg == null) {
            return;
        }
        if (pkg.getWorkflowList() == null || resultPkg.getWorkflowList() == null || pkg.getWorkflowList().size() == 0 || resultPkg.getWorkflowList().size() == 0) {
            log.info("workflow list is null or empty");
            return;
        }
        HashMap<String, String> mxTransIdMap = new HashMap<String, String>();
        block0: for (Workflow resultWf : resultPkg.getWorkflowList()) {
            for (Workflow wf : pkg.getWorkflowList()) {
                if (!resultWf.getWorkflowName().equals(wf.getProjectName() + "_" + wf.getWorkflowName())) continue;
                mxTransIdMap.put(resultWf.getWorkflowId(), wf.getWorkflowId());
                resultWf.setWorkflowId(wf.getWorkflowId());
                if (resultWf.getWorkflowNodes() == null || wf.getWorkflowNodes() == null || resultWf.getWorkflowNodes().size() == 0 || wf.getWorkflowNodes().size() == 0) continue;
                block2: for (WorkflowNode resultNode : resultWf.getWorkflowNodes()) {
                    for (WorkflowNode node : wf.getWorkflowNodes()) {
                        if (!resultNode.getNodeName().equals(node.getNodeName())) continue;
                        mxTransIdMap.put(resultNode.getNodeId(), node.getNodeId());
                        resultNode.setNodeId(node.getNodeId());
                        continue block2;
                    }
                }
                continue block0;
            }
        }
        for (Workflow resultWf : resultPkg.getWorkflowList()) {
            if (resultWf.getNodeRelations() == null || resultWf.getNodeRelations().size() <= 0) continue;
            for (RelationPackage relation : resultWf.getNodeRelations()) {
                if (mxTransIdMap.containsKey(relation.getFrom())) {
                    relation.setFrom((String)mxTransIdMap.get(relation.getFrom()));
                }
                if (!mxTransIdMap.containsKey(relation.getTo())) continue;
                relation.setTo((String)mxTransIdMap.get(relation.getTo()));
            }
        }
        for (Workflow resultWf : resultPkg.getWorkflowList()) {
            resultWf.getCustomProperties().put("spec", this.batchStringReplace((String)resultWf.getCustomProperties().get("spec"), mxTransIdMap));
            if (resultWf.getWorkflowNodes() == null || resultWf.getWorkflowNodes().size() <= 0) continue;
            for (WorkflowNode resultNode : resultWf.getWorkflowNodes()) {
                resultNode.getCustomProperties().put("spec", this.batchStringReplace((String)resultNode.getCustomProperties().get("spec"), mxTransIdMap));
            }
        }
        this.taskContext.getStatisticOp().addWorkflowTotal(pkg.getWorkflowList().size());
        ArrayList ids = new ArrayList();
        resultPkg.getWorkflowList().forEach(workflow -> {
            ids.add(workflow.getWorkflowId());
            workflow.getWorkflowNodes().forEach(workflowNode -> ids.add(workflowNode.getNodeId()));
        });
        pkg.getWorkflowList().forEach(workflow -> {
            if (ids.contains(workflow.getWorkflowId())) {
                this.taskContext.getStatisticOp().addWorkflowSuccess(workflow.getWorkflowId());
            } else {
                this.taskContext.getStatisticOp().addWorkflowFailure(workflow.getWorkflowId(), "migrationx transform error");
            }
            workflow.getWorkflowNodes().forEach(workflowNode -> {
                if (ids.contains(workflowNode.getNodeId())) {
                    this.taskContext.getStatisticOp().addWorkflowNodeSuccess(workflowNode.getNodeId());
                    StatisticOp.NodeMapping nodeMapping = new StatisticOp.NodeMapping();
                    nodeMapping.setSrcNodeId(workflowNode.getNodeId());
                    nodeMapping.setSrcNodeName(workflowNode.getNodeName());
                    nodeMapping.setTgtNodeId(workflowNode.getNodeId());
                    nodeMapping.setTgtNodeName(workflowNode.getNodeName());
                    nodeMapping.setWorkflowName(workflow.getWorkflowName());
                    nodeMapping.setProjectName(workflow.getProjectName());
                    this.taskContext.getStatisticOp().addNodeMap(nodeMapping);
                } else {
                    this.taskContext.getStatisticOp().addWorkflowNodeFailure(workflowNode.getNodeId(), "migrationx transform error");
                }
            });
        });
    }

    protected String batchStringReplace(String str, Map<String, String> map) {
        String formatStr1 = "\"%s\"";
        String formatStr2 = "\"%s\\\\";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!str.contains(entry.getKey())) continue;
            str = str.replaceAll(String.format(formatStr1, entry.getKey()), String.format(formatStr1, entry.getValue()));
            str = str.replaceAll(String.format(formatStr2, entry.getKey()), String.format(formatStr2, entry.getValue()));
        }
        return str;
    }
}

