/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.circuitbreaker.event;

import com.aliyun.rapt.commons.circuitbreaker.ThresholdCircuitBreakerEvent;
import com.aliyun.rapt.commons.circuitbreaker.event.EventFactory;
import com.aliyun.rapt.commons.circuitbreaker.event.OsThresholdCircuitBreakerEvent;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;

public class OsThresholdCircuitBreakerEventFactory
implements EventFactory<OsThresholdCircuitBreakerEvent> {
    private final double cpuThreshold;
    private final double osMemoryThreshold;
    private OperatingSystemMXBean operatingSystemMXBean;

    public OsThresholdCircuitBreakerEventFactory(double cpuThreshold, double osMemoryThreshold) {
        this(cpuThreshold, osMemoryThreshold, ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class));
    }

    public OsThresholdCircuitBreakerEventFactory(double cpuThreshold, double osMemoryThreshold, OperatingSystemMXBean operatingSystemMXBean) {
        this.cpuThreshold = cpuThreshold;
        this.osMemoryThreshold = osMemoryThreshold;
        this.operatingSystemMXBean = operatingSystemMXBean;
    }

    @Override
    public ThresholdCircuitBreakerEvent createEvent() {
        double memoryRatio = (double)this.operatingSystemMXBean.getFreePhysicalMemorySize() / (double)this.operatingSystemMXBean.getTotalPhysicalMemorySize();
        boolean exceedThreshold = this.cpuThreshold > 0.0 && this.operatingSystemMXBean.getSystemLoadAverage() > this.cpuThreshold * (double)this.operatingSystemMXBean.getAvailableProcessors() || this.osMemoryThreshold > 0.0 && memoryRatio > this.osMemoryThreshold;
        return new OsThresholdCircuitBreakerEvent(this.operatingSystemMXBean, exceedThreshold);
    }
}

