/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.circuitbreaker.breaker;

import com.aliyun.rapt.commons.circuitbreaker.AbstractCircuitBreaker;
import java.util.concurrent.atomic.AtomicLong;

public class ThresholdCircuitBreaker
extends AbstractCircuitBreaker<Long> {
    private static final long INITIAL_COUNT = 0L;
    private final long threshold;
    private final AtomicLong used = new AtomicLong(0L);

    public ThresholdCircuitBreaker(long threshold) {
        this.threshold = threshold;
    }

    public long getThreshold() {
        return this.threshold;
    }

    @Override
    public boolean checkState() {
        return !this.isOpen();
    }

    @Override
    public void close0() {
        super.close0();
        this.used.set(0L);
    }

    @Override
    public boolean incrementAndCheckState(Long increment) {
        long used;
        if (this.threshold == 0L) {
            this.open();
        }
        if ((used = this.used.addAndGet(increment)) > this.threshold) {
            this.open();
        }
        return this.checkState();
    }

    @Override
    public Class<? extends Long> getValueClass() {
        return Long.class;
    }
}

