/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.circuitbreaker.breaker;

import com.aliyun.rapt.commons.circuitbreaker.CircuitBreakEventListener;
import com.aliyun.rapt.commons.circuitbreaker.CircuitBreaker;
import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.rapt.commons.utils.watchers.FileWatchEventListener;
import com.aliyun.rapt.commons.utils.watchers.FileWatcher;
import com.aliyun.rapt.commons.utils.watchers.FileWatcherHelper;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public class ManualCircuitBreaker
implements CircuitBreaker<String> {
    private static final Logger logger = SecurityLogManager.getLogger(ManualCircuitBreaker.class);
    public static final String INDICATOR_DIR = "/opt/aliyun-security";
    private FileWatcher watcher;
    private Path indicatorPath;
    private AtomicBoolean state = new AtomicBoolean(true);
    private CircuitBreakEventListener listener;

    public ManualCircuitBreaker(String indicatorFile) throws IOException {
        this.indicatorPath = Paths.get(INDICATOR_DIR, indicatorFile);
        if (Files.exists(this.indicatorPath, new LinkOption[0]) && Files.isReadable(this.indicatorPath)) {
            this.setStateByProperties();
        }
        this.createFileWatcher();
    }

    private Properties getCircuitBreakProperty() {
        Properties properties = null;
        if (!Files.exists(this.indicatorPath, new LinkOption[0]) || !Files.isReadable(this.indicatorPath)) {
            return properties;
        }
        try {
            properties = new Properties();
            properties.load(new FileInputStream(this.indicatorPath.toFile()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    private void setStateByProperties() {
        Properties properties = this.getCircuitBreakProperty();
        if (properties != null && properties.getProperty("manual-breaker", "false").equalsIgnoreCase("true")) {
            logger.info("Manual circuit breaker is opened, skipping security check");
            this.open();
        } else {
            logger.info("Manual circuit breaker is closed, activating security check");
            this.close();
        }
    }

    @Override
    public boolean isOpen() {
        return !this.state.get();
    }

    @Override
    public boolean isClosed() {
        return this.state.get();
    }

    @Override
    public boolean checkState() {
        return this.state.get();
    }

    @Override
    public void close() {
        if (this.state.compareAndSet(false, true) && this.listener != null) {
            this.listener.statusChanged(this.checkState());
        }
    }

    @Override
    public void open() {
        if (this.state.compareAndSet(true, false) && this.listener != null) {
            this.listener.statusChanged(this.checkState());
        }
    }

    @Override
    public boolean incrementAndCheckState(String increment) {
        return this.checkState();
    }

    private void createFileWatcher() throws IOException {
        this.watcher = new FileWatcher(Paths.get(INDICATOR_DIR, new String[0]), false, false, true, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("watcher for circuit breaker");
                t.setDaemon(true);
                return t;
            }
        });
        this.watcher.registerListener(new FileWatchEventListener(){

            public void onDeleteEvent(WatchKey watchKey, WatchEvent event) {
                this.handleDelete(watchKey, event);
            }

            public void onModifyEvent(WatchKey watchKey, WatchEvent event) {
                this.handleContentChange(watchKey, event);
            }

            public void onCreateEvent(WatchKey watchKey, WatchEvent event) {
                this.handleContentChange(watchKey, event);
            }

            private void handleContentChange(WatchKey watchKey, WatchEvent event) {
                Path path = FileWatcherHelper.resolvePath((WatchKey)watchKey, (WatchEvent)event);
                if (!Objects.equals(path, ManualCircuitBreaker.this.indicatorPath)) {
                    return;
                }
                if (!Files.exists(ManualCircuitBreaker.this.indicatorPath, new LinkOption[0]) || !Files.isReadable(ManualCircuitBreaker.this.indicatorPath)) {
                    return;
                }
                if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE || event.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                    ManualCircuitBreaker.this.setStateByProperties();
                }
            }

            private void handleDelete(WatchKey watchKey, WatchEvent event) {
                Path path = FileWatcherHelper.resolvePath((WatchKey)watchKey, (WatchEvent)event);
                if (!Objects.equals(path, ManualCircuitBreaker.this.indicatorPath)) {
                    return;
                }
                if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                    logger.info("Manual circuit breaker is closed, activating security check");
                    ManualCircuitBreaker.this.close();
                }
            }
        });
        this.watcher.start();
    }

    @Override
    public Class<? extends String> getValueClass() {
        return String.class;
    }

    @Override
    public void setEventListener(CircuitBreakEventListener circuitBreakEventListener) {
        this.listener = circuitBreakEventListener;
    }

    @Override
    public void shutdown() {
        try {
            this.watcher.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

