/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.enums;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.CycleType;
import com.google.common.collect.Maps;
import java.util.Map;

public enum ScheduleTypeEnum {
    DEFAULT("0"),
    SECOND("1"),
    HOUR("2"),
    DAY("3"),
    WEEK("4"),
    MONTH("5");

    private final String type;
    private static final Map<String, ScheduleTypeEnum> ALL_VALUES;

    public static ScheduleTypeEnum fromType(String type) {
        return ALL_VALUES.get(type);
    }

    private ScheduleTypeEnum(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static CycleType toCycleType(String type) {
        if (ScheduleTypeEnum.SECOND.type.equals(type) || ScheduleTypeEnum.HOUR.type.equals(type)) {
            return CycleType.NOT_DAY;
        }
        return CycleType.DAY;
    }

    static {
        ALL_VALUES = Maps.newHashMap();
        for (ScheduleTypeEnum type : ScheduleTypeEnum.values()) {
            ALL_VALUES.put(type.getType(), type);
        }
    }
}

