/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian;

import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.DgDatasource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Datasource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwDatasource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.connection.AbstractConnection;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.tenant.EnvType;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DgDatasourceUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger(DgDatasourceUtil.class);
    public static final String DATASOURCE_EXCEL = "datasource.xlsx";

    public static Map<String, DgDatasource> processDatasource(File datasourceExcelFile) throws IOException {
        HashMap<String, DgDatasource> datasources = new HashMap<String, DgDatasource>();
        if (!datasourceExcelFile.exists()) {
            return datasources;
        }
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)new FileInputStream(datasourceExcelFile));
        if (workbook.getNumberOfSheets() == 0) {
            return datasources;
        }
        Sheet sheet = workbook.getSheetAt(0);
        List rows = IteratorUtils.toList((Iterator)sheet.rowIterator());
        ((Stream)rows.stream().parallel()).forEach(row -> DgDatasourceUtil.processRow(row, datasources));
        return datasources;
    }

    private static String getCellStringValue(Row row, String columnName) {
        Sheet sheet = row.getSheet();
        Row titleRow = sheet.getRow(0);
        ArrayList columnCellList = Lists.newArrayList((Iterator)titleRow.cellIterator());
        Integer index = columnCellList.stream().filter(cell -> columnName.equalsIgnoreCase(StringUtils.strip((String)cell.getStringCellValue()))).map(Cell::getColumnIndex).findFirst().orElseThrow(() -> new RuntimeException("column not found: " + columnName));
        Cell cell2 = row.getCell(index.intValue());
        if (cell2 != null) {
            cell2.setCellType(CellType.STRING);
        }
        return cell2 == null ? "" : ((String)StringUtils.defaultIfBlank((CharSequence)cell2.getStringCellValue(), (CharSequence)"")).trim();
    }

    private static void processRow(Row row, Map<String, DgDatasource> datasources) {
        if (row.getRowNum() == 0) {
            return;
        }
        DgDatasource dgDatasource = new DgDatasource();
        String id = DgDatasourceUtil.getCellStringValue(row, "\u6570\u636e\u6e90ID");
        String type = DgDatasourceUtil.getCellStringValue(row, "\u6570\u636e\u6e90\u7c7b\u578b");
        String name = DgDatasourceUtil.getCellStringValue(row, "\u6570\u636e\u6e90\u540d\u79f0");
        String host = DgDatasourceUtil.getCellStringValue(row, "host");
        String port = DgDatasourceUtil.getCellStringValue(row, "port");
        String rootPath = DgDatasourceUtil.getCellStringValue(row, "\u8def\u5f84");
        String username = DgDatasourceUtil.getCellStringValue(row, "\u7528\u6237\u540d");
        String password = DgDatasourceUtil.getCellStringValue(row, "\u5bc6\u7801");
        dgDatasource.setId(StringUtils.isBlank((CharSequence)id) ? null : Long.valueOf(id));
        dgDatasource.setName(name);
        dgDatasource.setType(type);
        dgDatasource.setRootPath(rootPath);
        dgDatasource.setUsername(username);
        dgDatasource.setPassword(password);
        dgDatasource.setHost(host);
        dgDatasource.setPort(port);
        datasources.put(name, dgDatasource);
    }

    public static List<Datasource> convertDatasources(Map<String, DgDatasource> datasourceMap) {
        ArrayList<Datasource> datasourceList = new ArrayList<Datasource>();
        MapUtils.emptyIfNull(datasourceMap).forEach((name, dgDatasource) -> {
            DwDatasource dwDatasource = new DwDatasource();
            dwDatasource.setName(name);
            dwDatasource.setType(dgDatasource.getType());
            dwDatasource.setDescription("data go datasource id: " + dgDatasource.getId());
            if ("sftp".equalsIgnoreCase(dgDatasource.getType())) {
                dwDatasource.setType("ftp");
            }
            if ("oceanbase".equalsIgnoreCase(dgDatasource.getType())) {
                dwDatasource.setType("apsaradb_for_oceanbase");
            }
            AbstractConnection conn = dgDatasource.toConnection();
            dwDatasource.setConnection(GsonUtils.toJsonString((Object)conn));
            dwDatasource.setEnvType(EnvType.PRD.name());
            if (datasourceList.stream().noneMatch(ds -> ds.getName().equalsIgnoreCase((String)name))) {
                datasourceList.add((Datasource)dwDatasource);
            }
        });
        return datasourceList;
    }
}

