/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DateParser {
    static Pattern patternVariable = Pattern.compile("@@(\\{[^\\}]+\\}|\\[[^\\]]+\\])");
    static Pattern patternOffset = Pattern.compile("[+-]\\s*\\d+(y|m|d|h|mi|s)?$");
    static Pattern patternFormat = Pattern.compile("(yy|yyyy|mm|dd|hh24|hh|mi|ss|-|:|_|\\s)+");
    public static final String VAR_BIZDATE_START = "{";
    public static final String VAR_BIZDATE_END = "}";
    public static final String VAR_DUE_TIME_START = "[";
    public static final String VAR_DUE_TIME_END = "]";
    public static final String VAR_D2_SYMBOL = "$";
    public static final String VAR_DATAGO_SYMBOL = "@@";

    public static Pattern getPattern() {
        return patternVariable;
    }

    public static String parse(String param) {
        Matcher m = DateParser.getPattern().matcher(param);
        while (m.find()) {
            param = param.replace(m.group(), DateParser.parseExpr(m.group()));
        }
        return param;
    }

    public static String parseExpr(String expr) {
        String symbolType = DateParser.getSymbol(expr);
        if (StringUtils.isBlank((CharSequence)symbolType)) {
            return expr;
        }
        expr = expr.replace(VAR_DATAGO_SYMBOL, VAR_D2_SYMBOL).replace("mm", "mi").replace("MM", "mm").replace("HH", "hh24");
        String var = expr.substring(2, expr.length() - 1);
        String formatStr = null;
        String offsetStr = null;
        StringBuffer sb = new StringBuffer();
        Matcher m = patternOffset.matcher(var);
        while (m.find()) {
            offsetStr = m.group().trim();
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        var = sb.toString();
        m = patternFormat.matcher(var);
        if (!m.matches()) {
            return expr;
        }
        formatStr = m.group().trim();
        if (offsetStr != null) {
            return DateParser.toD2Format(symbolType, formatStr, offsetStr);
        }
        return expr;
    }

    static String getSymbol(String expr) {
        String symbol = expr.substring(2, 3);
        if (expr.contains(VAR_DATAGO_SYMBOL) && (VAR_BIZDATE_START.equals(symbol) || VAR_DUE_TIME_START.equals(symbol))) {
            return symbol;
        }
        return "";
    }

    private static String toDateFormat(String symbolType, String formatStr, String offsetStr) {
        StringBuilder d2Format = new StringBuilder();
        int offset = 0;
        String symbol = offsetStr.substring(0, 1);
        String period = offsetStr.substring(1).trim();
        offset = Integer.valueOf(period.replaceAll("\\D.*", ""));
        if ("-".equals(symbol)) {
            offset = -offset;
        }
        if (VAR_DUE_TIME_START.equals(symbolType)) {
            if (period.endsWith("mi")) {
                period = period.replace("mi", "/24/60").trim();
            } else if (period.endsWith("h")) {
                period = period.replace("h", "/24").trim();
            } else if (period.endsWith("d")) {
                period = period.replace("d", "").trim();
            } else {
                if (period.endsWith("y")) {
                    return d2Format.append("add_months(").append(formatStr).append(",").append(12 * offset).append(")").toString();
                }
                if (period.endsWith("m")) {
                    return d2Format.append("add_months(").append(formatStr).append(",").append(offset).append(")").toString();
                }
            }
        } else {
            period = period.replaceAll("(y|m|d|)", "").trim();
        }
        return d2Format.append(formatStr).append(symbol).append(period).toString();
    }

    private static String toD2Format(String symbolType, String formatStr, String offsetStr) {
        StringBuilder sb = new StringBuilder();
        String d2Format = DateParser.toDateFormat(symbolType, formatStr, offsetStr);
        if (VAR_BIZDATE_START.equals(symbolType)) {
            sb.append(VAR_D2_SYMBOL).append(VAR_BIZDATE_START).append(d2Format).append(VAR_BIZDATE_END);
        } else {
            sb.append(VAR_D2_SYMBOL).append(VAR_DUE_TIME_START).append(d2Format).append(VAR_DUE_TIME_END);
        }
        return sb.toString();
    }

    public static String parsePartition(String pt) {
        if (pt.contains("=")) {
            pt = pt.split("=")[1];
        }
        return pt;
    }
}

