/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.datago.model;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.DITask;
import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.enums.CDPTypeEnum;
import com.aliyun.dataworks.migrationx.domain.dataworks.datago.MergeSqlUtil;
import com.aliyun.dataworks.migrationx.domain.dataworks.datago.enums.DataImportMethodEnum;
import com.aliyun.dataworks.migrationx.domain.dataworks.datago.enums.DataSyncTypeEnum;
import com.aliyun.dataworks.migrationx.domain.dataworks.datago.enums.TypeofEnum;
import com.aliyun.dataworks.migrationx.domain.dataworks.datago.model.cdp.BaseModel;
import com.aliyun.dataworks.migrationx.domain.dataworks.datago.model.cdp.WriterModel;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeIo;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldDataX2DI {
    private static final Logger log = LoggerFactory.getLogger(OldDataX2DI.class);
    @SerializedName(value="reader_config")
    private Config readerConfig;
    @SerializedName(value="writer_config")
    private Config writerConfig;
    @SerializedName(value="data_sync_config")
    private DataSyncConfig dataSyncConfig;
    @SerializedName(value="data_import_config")
    private DataImportConfig dataImportConfig;
    @SerializedName(value="input_param")
    private Config inputParam;
    private static final String SPLIT_PK = "splitPk";
    private static final String FILTER_SQL = "filterSql";
    private static final String COLUMNS = "columns";
    private static final String PT = "pt";
    private static final String DI_TYPE = "diType";
    private static final String INDEX = "index";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String FIELD_DELIMITER = "fieldDelimiter";
    private static final String MARK_DONE_FILE_NAME = "markDoneFileWithAbsolutePath";

    public DITask.Step toReader() {
        String readerConfig = this.readerConfig.value;
        JsonObject parameter = this.readerConfig.getSerializeValue();
        this.toDIParameter(parameter, readerConfig);
        if (null != parameter) {
            String type = parameter.get(DI_TYPE).getAsString();
            return new DITask.Step(type, parameter, type, "reader");
        }
        return new DITask.Step();
    }

    public DITask.Step toWriter() {
        String writerConfig = this.writerConfig.value;
        JsonObject parameter = this.writerConfig.getSerializeValue();
        this.toDIParameter(parameter, writerConfig);
        if (null != parameter) {
            String type = parameter.get(DI_TYPE).getAsString();
            return new DITask.Step(type, parameter, type, "writer");
        }
        return new DITask.Step();
    }

    public List<DwNode> convertMergeNode(DwNode originalNode, String workflow) throws Exception {
        if (null != this.dataImportConfig && StringUtils.isNotBlank((CharSequence)this.dataImportConfig.value)) {
            DataImportConfig.DataImportConfigValue dataImportConfigValue = this.dataImportConfig.getSerializeConfig();
            boolean isDaily = false;
            if (originalNode.getCycleType() == 0) {
                isDaily = true;
            }
            WriterModel.OdpsWriterModel odpsWriterModel = (WriterModel.OdpsWriterModel)GsonUtils.defaultGson.fromJson(this.writerConfig.value, new TypeToken<WriterModel.OdpsWriterModel>(){}.getType());
            DataImportMethodEnum dataImportMethodEnum = dataImportConfigValue.getDataImportMethodEnum();
            if (DataImportMethodEnum.DB_TIMESTANMP.equals((Object)dataImportMethodEnum) && StringUtils.isNotBlank((CharSequence)dataImportConfigValue.getIncrColumn())) {
                DITask diTask = (DITask)GsonUtils.defaultGson.fromJson(originalNode.getCode(), new TypeToken<DITask>(){}.getType());
                boolean finalIsDaily = isDaily;
                diTask.getSteps().forEach(step -> {
                    if ("reader".equals(step.getCategory())) {
                        try {
                            step.getParameter().addProperty("where", MergeSqlUtil.generateWhere(finalIsDaily, odpsWriterModel, dataImportConfigValue.getIncrColumn()));
                        }
                        catch (Exception e) {
                            log.error("[DataGO] generateWhere exception, nodeName:{}", (Object)originalNode.getName(), (Object)e);
                        }
                    }
                });
                originalNode.setCode(diTask.toString());
            }
            DataSyncTypeEnum dataSyncTypeEnum = this.dataSyncConfig.getDataSyncTypeEnum();
            if (originalNode.getCycleType() != 0 && DataSyncTypeEnum.INCREMENT.equals((Object)dataSyncTypeEnum) || originalNode.getCycleType() == 0 && DataSyncTypeEnum.INCREMENT_FULL.equals((Object)dataSyncTypeEnum)) {
                ArrayList<DwNode> nodes = new ArrayList<DwNode>();
                DwNode diNode = this.copyNode(originalNode);
                diNode.setName(diNode.getName() + "_DI");
                diNode.getOutputs().clear();
                diNode.getOutputs().add(this.convertNodeIo(diNode.getName(), workflow));
                nodes.add(diNode);
                DwNode odpsNode = this.copyNode(originalNode);
                odpsNode.setName(odpsNode.getName() + "_ODPS_SQL");
                odpsNode.setType(CodeProgramType.ODPS_SQL.name());
                String code = MergeSqlUtil.generateMergeSql(isDaily, odpsWriterModel, dataImportConfigValue.getJoinKey());
                odpsNode.setCode(code);
                odpsNode.getInputs().clear();
                odpsNode.getInputs().add(this.convertNodeIo(diNode.getName(), workflow));
                odpsNode.getOutputs().clear();
                odpsNode.getOutputs().add(this.convertNodeIo(odpsNode.getName(), workflow));
                nodes.add(odpsNode);
                DwNode virtualNode = this.copyNode(originalNode);
                virtualNode.setCode("");
                virtualNode.setType(CodeProgramType.VIRTUAL.name());
                virtualNode.getInputs().clear();
                virtualNode.getInputs().add(this.convertNodeIo(odpsNode.getName(), workflow));
                nodes.add(virtualNode);
                return nodes;
            }
        }
        return Collections.singletonList(originalNode);
    }

    private void toDIParameter(JsonObject parameter, String config) {
        if (StringUtils.isNotBlank((CharSequence)config)) {
            BaseModel baseModel = (BaseModel)GsonUtils.defaultGson.fromJson(config, new TypeToken<BaseModel>(){}.getType());
            CDPTypeEnum cdpTypeEnum = baseModel.getResourceType();
            parameter.addProperty(DI_TYPE, cdpTypeEnum.getD2DataXType());
            if (CollectionUtils.isNotEmpty(baseModel.getColumns())) {
                JsonArray columnArr = new JsonArray();
                if (TypeofEnum.OSS_READER.equals((Object)baseModel.getTypedef()) || TypeofEnum.SFTP_READER.equals((Object)baseModel.getTypedef())) {
                    baseModel.getColumns().forEach(column -> {
                        JsonObject object = new JsonObject();
                        object.addProperty(INDEX, (Number)column.getIndex());
                        object.addProperty(TYPE, column.getType());
                        object.addProperty("name", (Number)column.getIndex());
                        columnArr.add((JsonElement)object);
                    });
                } else {
                    baseModel.getColumns().forEach(column -> columnArr.add(column.getName()));
                }
                parameter.add("column", (JsonElement)columnArr);
                parameter.remove(COLUMNS);
            }
            parameter.addProperty("datasource", baseModel.getDatasourceName());
            if (parameter.has("tableName")) {
                String tableName = parameter.get("tableName").getAsString();
                String[] parts = StringUtils.split((String)tableName, (String)".");
                if (parts != null && parts.length > 1) {
                    tableName = parts[parts.length - 1];
                }
                parameter.addProperty("table", tableName);
                parameter.remove("tableName");
            }
            if (parameter.has(FILTER_SQL)) {
                parameter.addProperty("where", parameter.get(FILTER_SQL).getAsString());
                parameter.remove(FILTER_SQL);
            }
            if (parameter.has(SPLIT_PK)) {
                parameter.addProperty("splitPK", parameter.get(SPLIT_PK).getAsString());
                parameter.remove(SPLIT_PK);
            }
            if (TypeofEnum.MYSQL_READER.equals((Object)baseModel.getTypedef()) && parameter.has("tableName")) {
                DITask.Connection connection = new DITask.Connection();
                connection.setDatasource(baseModel.getDatasourceName());
                connection.setTable(parameter.get("tableName").getAsString().split(","));
                ArrayList<DITask.Connection> connectionList = new ArrayList<DITask.Connection>();
                connectionList.add(connection);
                parameter.add("connection", GsonUtils.defaultGson.toJsonTree(connectionList));
            }
            if (parameter.has(PT)) {
                String param = parameter.get(PT).getAsString();
                if (param.contains("hour") && !param.contains("hour=")) {
                    param = param.replace("hour", "hour=@@[HH-1h]");
                }
                if (TypeofEnum.ODPS_READER.equals((Object)baseModel.getTypedef()) && StringUtils.isNotBlank((CharSequence)param)) {
                    JsonArray partition = new JsonArray();
                    if (StringUtils.isNotBlank((CharSequence)param)) {
                        Arrays.stream(param.split(",")).forEach(s -> {
                            if (!s.contains("=") && s.contains("hour")) {
                                partition.add("hour=@@[HH-1h]");
                            } else {
                                partition.add(s);
                            }
                        });
                    }
                    parameter.add("partition", (JsonElement)partition);
                } else {
                    parameter.addProperty("partition", param);
                }
                parameter.remove(PT);
            }
            if (parameter.has("writeNode")) {
                String writeMode = parameter.get("writeNode").getAsString();
                if ("insert".equals(writeMode)) {
                    parameter.addProperty("writeNode", "insert into");
                } else if ("update".equals(writeMode)) {
                    parameter.addProperty("writeNode", "on duplicate key update");
                } else if ("replace".equals(writeMode)) {
                    parameter.addProperty("writeNode", "replace into");
                }
            }
            if (parameter.has(FIELD_DELIMITER)) {
                String fieldDelimiter = parameter.get(FIELD_DELIMITER).getAsString();
                parameter.addProperty("fieldDelimiterOrigin", StringEscapeUtils.escapeJava((String)fieldDelimiter));
                if (fieldDelimiter.length() > 1 && !parameter.has("fileFormat")) {
                    parameter.addProperty("fileFormat", "text");
                }
            }
            if (parameter.has(MARK_DONE_FILE_NAME)) {
                parameter.addProperty("markDoneFileName", parameter.get(MARK_DONE_FILE_NAME).getAsString());
            }
        }
    }

    private DwNode copyNode(DwNode originNode) {
        return (DwNode)GsonUtils.gson.fromJson(GsonUtils.gson.toJson((Object)originNode), new TypeToken<DwNode>(){}.getType());
    }

    private NodeIo convertNodeIo(String name, String workflowName) {
        NodeIo output = new NodeIo();
        output.setParseType(Integer.valueOf(1));
        if (name.contains(".")) {
            output.setData(name);
        } else {
            output.setData(Joiner.on((String)".").join((Object)workflowName, (Object)name, new Object[0]));
        }
        return output;
    }

    public Config getReaderConfig() {
        return this.readerConfig;
    }

    public Config getWriterConfig() {
        return this.writerConfig;
    }

    public DataSyncConfig getDataSyncConfig() {
        return this.dataSyncConfig;
    }

    public DataImportConfig getDataImportConfig() {
        return this.dataImportConfig;
    }

    public Config getInputParam() {
        return this.inputParam;
    }

    public void setReaderConfig(Config readerConfig) {
        this.readerConfig = readerConfig;
    }

    public void setWriterConfig(Config writerConfig) {
        this.writerConfig = writerConfig;
    }

    public void setDataSyncConfig(DataSyncConfig dataSyncConfig) {
        this.dataSyncConfig = dataSyncConfig;
    }

    public void setDataImportConfig(DataImportConfig dataImportConfig) {
        this.dataImportConfig = dataImportConfig;
    }

    public void setInputParam(Config inputParam) {
        this.inputParam = inputParam;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OldDataX2DI)) {
            return false;
        }
        OldDataX2DI other = (OldDataX2DI)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Config this$readerConfig = this.getReaderConfig();
        Config other$readerConfig = other.getReaderConfig();
        if (this$readerConfig == null ? other$readerConfig != null : !((Object)this$readerConfig).equals(other$readerConfig)) {
            return false;
        }
        Config this$writerConfig = this.getWriterConfig();
        Config other$writerConfig = other.getWriterConfig();
        if (this$writerConfig == null ? other$writerConfig != null : !((Object)this$writerConfig).equals(other$writerConfig)) {
            return false;
        }
        DataSyncConfig this$dataSyncConfig = this.getDataSyncConfig();
        DataSyncConfig other$dataSyncConfig = other.getDataSyncConfig();
        if (this$dataSyncConfig == null ? other$dataSyncConfig != null : !((Object)this$dataSyncConfig).equals(other$dataSyncConfig)) {
            return false;
        }
        DataImportConfig this$dataImportConfig = this.getDataImportConfig();
        DataImportConfig other$dataImportConfig = other.getDataImportConfig();
        if (this$dataImportConfig == null ? other$dataImportConfig != null : !((Object)this$dataImportConfig).equals(other$dataImportConfig)) {
            return false;
        }
        Config this$inputParam = this.getInputParam();
        Config other$inputParam = other.getInputParam();
        return !(this$inputParam == null ? other$inputParam != null : !((Object)this$inputParam).equals(other$inputParam));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OldDataX2DI;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Config $readerConfig = this.getReaderConfig();
        result = result * 59 + ($readerConfig == null ? 43 : ((Object)$readerConfig).hashCode());
        Config $writerConfig = this.getWriterConfig();
        result = result * 59 + ($writerConfig == null ? 43 : ((Object)$writerConfig).hashCode());
        DataSyncConfig $dataSyncConfig = this.getDataSyncConfig();
        result = result * 59 + ($dataSyncConfig == null ? 43 : ((Object)$dataSyncConfig).hashCode());
        DataImportConfig $dataImportConfig = this.getDataImportConfig();
        result = result * 59 + ($dataImportConfig == null ? 43 : ((Object)$dataImportConfig).hashCode());
        Config $inputParam = this.getInputParam();
        result = result * 59 + ($inputParam == null ? 43 : ((Object)$inputParam).hashCode());
        return result;
    }

    public String toString() {
        return "OldDataX2DI(readerConfig=" + this.getReaderConfig() + ", writerConfig=" + this.getWriterConfig() + ", dataSyncConfig=" + this.getDataSyncConfig() + ", dataImportConfig=" + this.getDataImportConfig() + ", inputParam=" + this.getInputParam() + ")";
    }

    public static class Config {
        private String name;
        private String value;

        private JsonObject getSerializeValue() {
            JsonParser parser = new JsonParser();
            return parser.parse(this.value).getAsJsonObject();
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "OldDataX2DI.Config(name=" + this.getName() + ", value=" + this.getValue() + ")";
        }
    }

    public static class DataImportConfig {
        private String value;

        public DataImportConfigValue getSerializeConfig() {
            return (DataImportConfigValue)GsonUtils.defaultGson.fromJson(this.value, new TypeToken<DataImportConfigValue>(){}.getType());
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataImportConfig)) {
                return false;
            }
            DataImportConfig other = (DataImportConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataImportConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "OldDataX2DI.DataImportConfig(value=" + this.getValue() + ")";
        }

        public static class DataImportConfigValue {
            private DataImportMethodEnum dataImportMethodEnum;
            private String incrColumn;
            private List<String> joinKey;

            public DataImportMethodEnum getDataImportMethodEnum() {
                return this.dataImportMethodEnum;
            }

            public String getIncrColumn() {
                return this.incrColumn;
            }

            public List<String> getJoinKey() {
                return this.joinKey;
            }

            public void setDataImportMethodEnum(DataImportMethodEnum dataImportMethodEnum) {
                this.dataImportMethodEnum = dataImportMethodEnum;
            }

            public void setIncrColumn(String incrColumn) {
                this.incrColumn = incrColumn;
            }

            public void setJoinKey(List<String> joinKey) {
                this.joinKey = joinKey;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DataImportConfigValue)) {
                    return false;
                }
                DataImportConfigValue other = (DataImportConfigValue)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                DataImportMethodEnum this$dataImportMethodEnum = this.getDataImportMethodEnum();
                DataImportMethodEnum other$dataImportMethodEnum = other.getDataImportMethodEnum();
                if (this$dataImportMethodEnum == null ? other$dataImportMethodEnum != null : !((Object)((Object)this$dataImportMethodEnum)).equals((Object)other$dataImportMethodEnum)) {
                    return false;
                }
                String this$incrColumn = this.getIncrColumn();
                String other$incrColumn = other.getIncrColumn();
                if (this$incrColumn == null ? other$incrColumn != null : !this$incrColumn.equals(other$incrColumn)) {
                    return false;
                }
                List<String> this$joinKey = this.getJoinKey();
                List<String> other$joinKey = other.getJoinKey();
                return !(this$joinKey == null ? other$joinKey != null : !((Object)this$joinKey).equals(other$joinKey));
            }

            protected boolean canEqual(Object other) {
                return other instanceof DataImportConfigValue;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                DataImportMethodEnum $dataImportMethodEnum = this.getDataImportMethodEnum();
                result = result * 59 + ($dataImportMethodEnum == null ? 43 : ((Object)((Object)$dataImportMethodEnum)).hashCode());
                String $incrColumn = this.getIncrColumn();
                result = result * 59 + ($incrColumn == null ? 43 : $incrColumn.hashCode());
                List<String> $joinKey = this.getJoinKey();
                result = result * 59 + ($joinKey == null ? 43 : ((Object)$joinKey).hashCode());
                return result;
            }

            public String toString() {
                return "OldDataX2DI.DataImportConfig.DataImportConfigValue(dataImportMethodEnum=" + (Object)((Object)this.getDataImportMethodEnum()) + ", incrColumn=" + this.getIncrColumn() + ", joinKey=" + this.getJoinKey() + ")";
            }
        }
    }

    public static class DataSyncConfig {
        private String value;

        public DITask.Setting getSerializeSetting() {
            Setting setting = (Setting)GsonUtils.defaultGson.fromJson(this.value, new TypeToken<Setting>(){}.getType());
            DITask.Setting diSetting = new DITask.Setting();
            diSetting.getErrorLimit().setRecord(setting.errorRecordLimit);
            diSetting.getSpeed().setConcurrent(setting.concurrency);
            if (null != setting.speed) {
                diSetting.getSpeed().setMbps(setting.speed);
            }
            return diSetting;
        }

        public DataSyncTypeEnum getDataSyncTypeEnum() {
            Setting setting = (Setting)GsonUtils.defaultGson.fromJson(this.value, new TypeToken<Setting>(){}.getType());
            return setting.getDataSyncTypeEnum();
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataSyncConfig)) {
                return false;
            }
            DataSyncConfig other = (DataSyncConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataSyncConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "OldDataX2DI.DataSyncConfig(value=" + this.getValue() + ")";
        }

        private static class Setting {
            private Integer errorRecordLimit;
            private Integer concurrency;
            private Integer speed;
            private DataSyncTypeEnum dataSyncTypeEnum;

            public Integer getErrorRecordLimit() {
                return this.errorRecordLimit;
            }

            public Integer getConcurrency() {
                return this.concurrency;
            }

            public Integer getSpeed() {
                return this.speed;
            }

            public DataSyncTypeEnum getDataSyncTypeEnum() {
                return this.dataSyncTypeEnum;
            }

            public void setErrorRecordLimit(Integer errorRecordLimit) {
                this.errorRecordLimit = errorRecordLimit;
            }

            public void setConcurrency(Integer concurrency) {
                this.concurrency = concurrency;
            }

            public void setSpeed(Integer speed) {
                this.speed = speed;
            }

            public void setDataSyncTypeEnum(DataSyncTypeEnum dataSyncTypeEnum) {
                this.dataSyncTypeEnum = dataSyncTypeEnum;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Setting)) {
                    return false;
                }
                Setting other = (Setting)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$errorRecordLimit = this.getErrorRecordLimit();
                Integer other$errorRecordLimit = other.getErrorRecordLimit();
                if (this$errorRecordLimit == null ? other$errorRecordLimit != null : !((Object)this$errorRecordLimit).equals(other$errorRecordLimit)) {
                    return false;
                }
                Integer this$concurrency = this.getConcurrency();
                Integer other$concurrency = other.getConcurrency();
                if (this$concurrency == null ? other$concurrency != null : !((Object)this$concurrency).equals(other$concurrency)) {
                    return false;
                }
                Integer this$speed = this.getSpeed();
                Integer other$speed = other.getSpeed();
                if (this$speed == null ? other$speed != null : !((Object)this$speed).equals(other$speed)) {
                    return false;
                }
                DataSyncTypeEnum this$dataSyncTypeEnum = this.getDataSyncTypeEnum();
                DataSyncTypeEnum other$dataSyncTypeEnum = other.getDataSyncTypeEnum();
                return !(this$dataSyncTypeEnum == null ? other$dataSyncTypeEnum != null : !((Object)((Object)this$dataSyncTypeEnum)).equals((Object)other$dataSyncTypeEnum));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Setting;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $errorRecordLimit = this.getErrorRecordLimit();
                result = result * 59 + ($errorRecordLimit == null ? 43 : ((Object)$errorRecordLimit).hashCode());
                Integer $concurrency = this.getConcurrency();
                result = result * 59 + ($concurrency == null ? 43 : ((Object)$concurrency).hashCode());
                Integer $speed = this.getSpeed();
                result = result * 59 + ($speed == null ? 43 : ((Object)$speed).hashCode());
                DataSyncTypeEnum $dataSyncTypeEnum = this.getDataSyncTypeEnum();
                result = result * 59 + ($dataSyncTypeEnum == null ? 43 : ((Object)((Object)$dataSyncTypeEnum)).hashCode());
                return result;
            }

            public String toString() {
                return "OldDataX2DI.DataSyncConfig.Setting(errorRecordLimit=" + this.getErrorRecordLimit() + ", concurrency=" + this.getConcurrency() + ", speed=" + this.getSpeed() + ", dataSyncTypeEnum=" + (Object)((Object)this.getDataSyncTypeEnum()) + ")";
            }
        }
    }
}

