/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dataarts.util;

import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfig;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigInput;
import com.aliyun.migration.spec.domain.links.DataArtsLink;
import com.aliyun.migration.workflow.migration.dataarts.enums.DataSourceTypeMappingEnum;
import java.util.List;

public class DataArtsLinkUtils {
    public static DataSourceTypeMappingEnum getDatabaseType(DataArtsLink dataArtsLink) {
        String dataArtsDataBaseType = null;
        for (DataSourceTypeMappingEnum item : DataSourceTypeMappingEnum.values()) {
            if (!item.getDataArtsConnector().equalsIgnoreCase(dataArtsLink.getConnectorName())) continue;
            if (!item.getDataArtsConnector().equalsIgnoreCase("generic-jdbc-connector")) {
                return item;
            }
            if (dataArtsDataBaseType != null) {
                dataArtsDataBaseType = DataArtsLinkUtils.getDatabaseTypeFromLink(dataArtsLink);
            }
            if (!item.getDataArstDataSourceType().equalsIgnoreCase(dataArtsDataBaseType)) continue;
            return item;
        }
        return null;
    }

    private static String getDatabaseTypeFromLink(DataArtsLink dataArtsLink) {
        List inputs = ((DataArtsCdmJobConfig)dataArtsLink.getLinkConfigValues().getConfigs().get(0)).getInputs();
        for (DataArtsCdmJobConfigInput input : inputs) {
            if (!input.getName().equals("linkConfig.databaseType")) continue;
            return input.getValue();
        }
        return null;
    }

    public static String getMysqlDatabaseName(DataArtsLink dataArtsLink) {
        for (DataArtsCdmJobConfig config : dataArtsLink.getLinkConfigValues().getConfigs()) {
            List inputs = config.getInputs();
            for (DataArtsCdmJobConfigInput input : inputs) {
                if (!input.getName().equals("linkConfig.database")) continue;
                return input.getValue();
            }
        }
        return null;
    }
}

