/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dataarts.convert;

import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.spec.domain.DataArtsJob;
import com.aliyun.migration.spec.domain.DataArtsJobNodePropertiesDTO;
import com.aliyun.migration.spec.domain.DataArtsJobScheduleCronDTO;
import com.aliyun.migration.spec.domain.DataArtsJobScheduleCronDependJobsDTO;
import com.aliyun.migration.spec.domain.DataArtsJobScheduleDTO;
import com.aliyun.migration.spec.domain.DataArtsNode;
import com.aliyun.migration.spec.domain.DataArtsNodeTypeEnum;
import com.aliyun.migration.spec.domain.DataArtsPackage;
import com.aliyun.migration.spec.domain.DataArtsProject;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJob;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.common.type.DbType;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migration.workflow.migration.dataarts.util.DataArtsNodeUtils;
import com.cronutils.utils.StringUtils;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DataArts2WorkflowConvert {
    private static final Logger log = LoggerFactory.getLogger(DataArts2WorkflowConvert.class);

    public WorkflowProjectPackage convert(DataArtsPackage dataArtsPackage) {
        WorkflowProjectPackage workflowProjectPackage = new WorkflowProjectPackage();
        DataArtsProject dataArtsProject = dataArtsPackage.getDataArtsProject();
        WorkflowProject workflowProject = this.convertProject(dataArtsProject);
        workflowProjectPackage.setWorkflowProject(workflowProject);
        Map dataArtsCdms = dataArtsPackage.getDataArtsCdms();
        List<Workflow> workflows = this.convertWorkflows(workflowProject, dataArtsPackage.getDataArtsJobList(), dataArtsCdms);
        workflows.forEach(wf -> wf.getNodeRelations().forEach(relation -> {
            if (relation.getReType().equals((Object)RelationPackage.ReType.WORKFLOW)) {
                if (!relation.getTo().equals(wf.getWorkflowId())) {
                    workflows.stream().filter(wf1 -> wf1.getWorkflowId().equals(relation.getTo())).findFirst().ifPresent(wf1 -> relation.setTo(wf1.getWorkflowName()));
                } else {
                    relation.setTo(wf.getWorkflowName());
                }
                if (!relation.getFrom().equals(wf.getWorkflowId())) {
                    workflows.stream().filter(wf1 -> wf1.getWorkflowId().equals(relation.getFrom())).findFirst().ifPresent(wf1 -> relation.setFrom(wf1.getWorkflowName()));
                } else {
                    relation.setFrom(wf.getWorkflowName());
                }
            }
        }));
        workflowProjectPackage.setWorkflowList(workflows);
        return workflowProjectPackage;
    }

    private WorkflowProject convertProject(DataArtsProject dataArtsProject) {
        WorkflowProject workflowProject = new WorkflowProject();
        workflowProject.setProjectId(dataArtsProject.getDataArtsWorkSpaceId());
        workflowProject.setName(dataArtsProject.getDataArtsWorkspaceName());
        return workflowProject;
    }

    private List<Workflow> convertWorkflows(WorkflowProject workflowProject, List<DataArtsJob> dataArtsJobList, Map<String, List<DataArtsCdmJob>> dataArtsCdms) {
        ArrayList<Workflow> res = new ArrayList<Workflow>();
        ((List)Optional.ofNullable(dataArtsJobList).orElse(new ArrayList())).forEach(x -> {
            DataArtsJobScheduleDTO schedule;
            WorkflowTrigger workflowTrigger;
            Workflow workflow = new Workflow();
            String name = x.getName();
            workflow.setWorkflowName(name);
            workflow.setWorkflowId(x.getId());
            workflow.setCategoryValue(x.getDirectory());
            workflow.setProjectId(workflowProject.getProjectId());
            workflow.setProjectName(workflowProject.getName());
            workflow.setCustomProperties(new HashMap());
            if (Objects.nonNull(x.getParams())) {
                workflow.getCustomProperties().put("param", x.getParams());
            }
            if (Objects.nonNull(workflowTrigger = this.convertTrigger(schedule = x.getSchedule(), workflowProject, workflow))) {
                workflow.setTriggers(Arrays.asList(workflowTrigger));
            }
            res.add(workflow);
            ArrayList relationPackages = new ArrayList();
            DataArtsJobScheduleCronDTO cron = x.getSchedule().getCron();
            if (Objects.nonNull(cron)) {
                DataArtsJobScheduleCronDependJobsDTO dependJobs = cron.getDependJobs();
                List jobs = dependJobs.getJobs();
                ((List)Optional.ofNullable(jobs).orElse(new ArrayList())).forEach(y -> {
                    RelationPackage relationPackage = RelationPackage.builder().from(y).to(workflow.getWorkflowId()).reType(RelationPackage.ReType.WORKFLOW).build();
                    relationPackages.add(relationPackage);
                });
                log.debug("{} depend job is {}", (Object)name, (Object)jobs);
            }
            ArrayList nodes = new ArrayList();
            List dataArtsNodeList = x.getDataArtsNodeList();
            ((List)Optional.ofNullable(dataArtsNodeList).orElse(new ArrayList())).forEach(y -> {
                WorkflowNode workflowNode = this.convertWorkflowNode((DataArtsNode)y, workflowProject, workflow, dataArtsCdms);
                nodes.add(workflowNode);
                List preNodeName = y.getPreNodeName();
                if (!CollectionUtils.isEmpty((Collection)preNodeName)) {
                    preNodeName.forEach(z -> {
                        RelationPackage relationPackage = RelationPackage.builder().from(this.getNodeId(workflow.getWorkflowId(), (String)z)).to(this.getNodeId(workflow.getWorkflowId(), y.getName())).reType(RelationPackage.ReType.NODE).build();
                        relationPackages.add(relationPackage);
                    });
                }
            });
            workflow.setNodeRelations(relationPackages);
            workflow.setWorkflowNodes(nodes);
        });
        return res;
    }

    private String getNodeId(String workflowId, String nodeName) {
        return workflowId + "_" + nodeName;
    }

    private WorkflowTrigger convertTrigger(DataArtsJobScheduleDTO schedule, WorkflowProject workflowProject, Workflow workflow) {
        if (Objects.isNull(schedule)) {
            log.warn("schedule is null ");
            return null;
        }
        WorkflowTrigger trigger = new WorkflowTrigger();
        DataArtsJobScheduleCronDTO cron = schedule.getCron();
        if (Objects.isNull(cron)) {
            return null;
        }
        String expression = cron.getExpression();
        String startTime = cron.getStartTime();
        String endTime = cron.getEndTime();
        trigger.setCron(expression);
        trigger.setStartTime(this.parseStartTime(startTime));
        trigger.setEndTime(this.parseEndTime(endTime));
        trigger.setWorkflowName(workflow.getWorkflowName());
        trigger.setWorkflowId(workflow.getWorkflowId());
        trigger.setName("trigger");
        trigger.setProjectName(workflowProject.getName());
        trigger.setProjectId(workflowProject.getProjectId());
        return trigger;
    }

    private LocalDateTime parseStartTime(String timeStr) {
        if (StringUtils.isEmpty((CharSequence)timeStr)) {
            return LocalDateTime.now();
        }
        try {
            return ZonedDateTime.parse(timeStr).toLocalDateTime();
        }
        catch (Exception e) {
            log.error("parse trigger time error {}", (Object)timeStr, (Object)e);
            return LocalDateTime.now();
        }
    }

    private LocalDateTime parseEndTime(String timeStr) {
        if (StringUtils.isEmpty((CharSequence)timeStr)) {
            return LocalDateTime.parse("9999-12-31T23:59:59");
        }
        try {
            return ZonedDateTime.parse(timeStr).toLocalDateTime();
        }
        catch (Exception e) {
            log.error("parse trigger time error {}", (Object)timeStr, (Object)e);
            return LocalDateTime.parse("9999-12-31T23:59:59");
        }
    }

    public static DataArtsCdmJob getDataArtsCdmJob(String clusterName, String dataArtsJobNodeName, Map<String, List<DataArtsCdmJob>> dataArtsCdms) {
        List<DataArtsCdmJob> cmdJobList = dataArtsCdms.get(clusterName);
        if (CollectionUtils.isEmpty(cmdJobList)) {
            return null;
        }
        for (DataArtsCdmJob dataArtsCdmJob : cmdJobList) {
            if (!dataArtsCdmJob.getName().equals(dataArtsJobNodeName)) continue;
            return dataArtsCdmJob;
        }
        return null;
    }

    private String getScript(DataArtsNode dataArtsNode, Map<String, List<DataArtsCdmJob>> dataArtsCdms) {
        if (Objects.isNull(dataArtsNode)) {
            return null;
        }
        String type = dataArtsNode.getType();
        if (type.equals(DataArtsNodeTypeEnum.TYPE_CDMJob.getDataArtsNodeType())) {
            String clusterName = DataArtsNodeUtils.getDataArtsClusterName(dataArtsNode);
            if (StringUtils.isEmpty((CharSequence)clusterName)) {
                throw new RuntimeException("cluster name is empty");
            }
            String cdmJobName = DataArtsNodeUtils.getCdmJobName(dataArtsNode);
            DataArtsCdmJob dataArtsCdmJob = DataArts2WorkflowConvert.getDataArtsCdmJob(clusterName, cdmJobName, dataArtsCdms);
            if (Objects.isNull(dataArtsCdmJob)) {
                log.error("not found dataArtsCdmJob dataArtsNode={} clustername={} cdmJobName={}", new Object[]{dataArtsNode.getName(), clusterName, cdmJobName});
                return null;
            }
            return BwmJsonUtil.toJsonString((Object)dataArtsCdmJob);
        }
        return dataArtsNode.getScriptContent();
    }

    private WorkflowNode convertWorkflowNode(DataArtsNode dataArtsNode, WorkflowProject workflowProject, Workflow workflow, Map<String, List<DataArtsCdmJob>> dataArtsCdms) {
        String owner = dataArtsNode.getOwner();
        String scriptContent = this.getScript(dataArtsNode, dataArtsCdms);
        DataArtsJobScheduleDTO schedule = dataArtsNode.getSchedule();
        DataArtsJobScheduleCronDTO cron = schedule.getCron();
        List jobs = null;
        if (Objects.nonNull(cron)) {
            DataArtsJobScheduleCronDependJobsDTO dependJobs = cron.getDependJobs();
            jobs = dependJobs.getJobs();
        }
        ArrayList nodeRelations = new ArrayList();
        String workflowId = workflow.getWorkflowId();
        ((List)Optional.ofNullable(jobs).orElse(new ArrayList())).forEach(x -> nodeRelations.add(new RelationPackage(workflowId, x, RelationPackage.ReType.WORKFLOW)));
        List workflowNodeRelations = workflow.getNodeRelations();
        if (CollectionUtils.isEmpty((Collection)workflowNodeRelations)) {
            workflow.setNodeRelations(new ArrayList());
        }
        workflow.getNodeRelations().addAll(nodeRelations);
        WorkflowNode workflowNode = new WorkflowNode();
        workflowNode.setNodeType(dataArtsNode.getType());
        workflowNode.setDbType(this.getDbTypeByDataArtsNodeType(dataArtsNode.getType()));
        workflowNode.setNodeId(this.getNodeId(workflowId, dataArtsNode.getName()));
        workflowNode.setNodeName(dataArtsNode.getName());
        workflowNode.setOwner(owner);
        workflowNode.setCategoryValue(dataArtsNode.getDirectory());
        workflowNode.setParamMap(this.convertNodeParam(dataArtsNode));
        workflowNode.setScript(scriptContent);
        if (workflowNode.getCustomProperties() == null) {
            workflowNode.setCustomProperties(new HashMap());
        }
        if (dataArtsNode.getProperties() != null && !dataArtsNode.getProperties().isEmpty()) {
            dataArtsNode.getProperties().forEach(p -> workflowNode.getCustomProperties().put(p.getName(), p.getValue()));
        }
        return workflowNode;
    }

    private String getDbTypeByDataArtsNodeType(String dataArtsNodeType) {
        if (dataArtsNodeType.equals(DataArtsNodeTypeEnum.TYPE_HIVE_SQL.getDataArtsNodeType())) {
            return DbType.HIVE.getDescp();
        }
        if (dataArtsNodeType.equals(DataArtsNodeTypeEnum.TYPE_RDSSQL.getDataArtsNodeType())) {
            return DbType.MYSQL.getDescp();
        }
        if (dataArtsNodeType.equals(DataArtsNodeTypeEnum.TYPE_DWSSQL.getDataArtsNodeType())) {
            return DbType.GAUSSDB.getDescp();
        }
        if (dataArtsNodeType.equals(DataArtsNodeTypeEnum.TYPE_DLISQL.getDataArtsNodeType())) {
            return DbType.DLI.getDescp();
        }
        if (dataArtsNodeType.equals(DataArtsNodeTypeEnum.TYPE_SPRKSQL.getDataArtsNodeType())) {
            return DbType.SPARK.getDescp();
        }
        return null;
    }

    private Map<String, Object> convertNodeParam(DataArtsNode dataArtsNode) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        List params = dataArtsNode.getParams();
        ((List)Optional.ofNullable(params).orElse(new ArrayList())).forEach(x -> res.put(x.getName(), x.getValue()));
        List properties = dataArtsNode.getProperties();
        String scriptArgs = ((List)Optional.ofNullable(properties).orElse(new ArrayList())).stream().filter(x -> x.getName().equals("scriptArgs")).map(DataArtsJobNodePropertiesDTO::getValue).findFirst().orElse("");
        if (!StringUtils.isEmpty((CharSequence)scriptArgs)) {
            String[] scriptArgsArr;
            for (String singleArg : scriptArgsArr = scriptArgs.split("\n")) {
                String[] split = singleArg.split("=");
                if (split.length != 2) continue;
                String key = split[0];
                String value = split[1];
                res.put(key, value);
            }
        }
        return res;
    }
}

