/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.utils.watchers;

import com.aliyun.rapt.commons.utils.watchers.FileWatchEventListener;
import com.aliyun.rapt.commons.utils.watchers.FileWatcher;
import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;

public class WatchSubDirFileWatchEventListener
implements FileWatchEventListener {
    private FileWatcher fileWatcher;

    public WatchSubDirFileWatchEventListener(FileWatcher fileWatcher) {
        this.fileWatcher = fileWatcher;
    }

    @Override
    public void onDeleteEvent(WatchKey watchKey, WatchEvent event) {
    }

    @Override
    public void onModifyEvent(WatchKey watchKey, WatchEvent event) {
    }

    @Override
    public void onCreateEvent(WatchKey watchKey, WatchEvent event) {
        Path dir = (Path)watchKey.watchable();
        if (dir.equals(this.fileWatcher.getTargetWatchDir())) {
            return;
        }
        WatchEvent cast = WatchSubDirFileWatchEventListener.cast(event);
        Path resolvedPath = dir.resolve((Path)cast.context());
        if (!resolvedPath.toFile().isDirectory()) {
            return;
        }
        if (!this.fileWatcher.getTargetWatchDir().startsWith(resolvedPath)) {
            return;
        }
        try {
            this.fileWatcher.register(resolvedPath, SensitivityWatchEventModifier.HIGH);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }
}

