/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.utils.watchers;

import com.aliyun.rapt.commons.utils.watchers.FileWatchEventListener;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;

public class MatchablePathFileWatchEventListenerWrapper
implements FileWatchEventListener {
    private final PathMatcher pathMatcher;
    private final FileWatchEventListener delegate;

    public MatchablePathFileWatchEventListenerWrapper(PathMatcher pathMatcher, FileWatchEventListener listener) {
        this.pathMatcher = pathMatcher;
        this.delegate = listener;
    }

    @Override
    public void onDeleteEvent(WatchKey watchKey, WatchEvent event) {
        if (this.matches(watchKey)) {
            this.delegate.onDeleteEvent(watchKey, event);
        }
    }

    @Override
    public void onModifyEvent(WatchKey watchKey, WatchEvent event) {
        if (this.matches(watchKey)) {
            this.delegate.onModifyEvent(watchKey, event);
        }
    }

    @Override
    public void onCreateEvent(WatchKey watchKey, WatchEvent event) {
        if (this.matches(watchKey)) {
            this.delegate.onCreateEvent(watchKey, event);
        }
    }

    private boolean matches(WatchKey watchKey) {
        return Path.class.isInstance(watchKey.watchable()) && this.pathMatcher.matches((Path)watchKey.watchable());
    }

    public static MatchablePathFileWatchEventListenerWrapper pathEqualsFileWatchEventListener(final Path path, FileWatchEventListener listener) {
        return new MatchablePathFileWatchEventListenerWrapper(new PathMatcher(){

            @Override
            public boolean matches(Path thePath) {
                return thePath.equals(path);
            }
        }, listener);
    }
}

