/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.reader.dolphinscheduler;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.BatchExportProcessDefinitionByIdsRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerApi;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerApiService;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DownloadResourceRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.PaginateData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.PaginateResponse;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.QueryDataSourceListByPaginateRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.QueryProcessDefinitionByPaginateRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.QueryResourceListRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.QueryUdfFuncListByPaginateRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.Response;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DolphinSchedulerApiV2Service;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.ResourceComponent;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DolphinschedulerApiV3Service;
import com.aliyun.migrationx.common.utils.Config;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.aliyun.migrationx.common.utils.JSONUtils;
import com.aliyun.migrationx.common.utils.PaginateUtils;
import com.aliyun.migrationx.common.utils.ZipUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinSchedulerReader {
    private static final Logger log = LoggerFactory.getLogger(DolphinSchedulerReader.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(DolphinSchedulerReader.class);
    private static final String PACKAGE_INFO_JSON = "package_info.json";
    private static final String PROCESS_DEFINITION = "processDefinition";
    private static final String RESOURCE = "resource";
    private static final String UDF_FUNCTION = "udfFunction";
    private static final String DATASOURCE = "datasource";
    private static final String PROJECTS = "projects";
    private static final String PROJECTS_JSON = "projects.json";
    private static final int PAGE_SIZE = 1000;
    private final String version;
    private List<String> projects;
    private List<Long> codes;
    private List<Project> projectInfoList = new ArrayList<Project>();
    private Map<String, Long> projectNameToCodeMap = new HashMap<String, Long>();
    private final File exportFile;
    private Boolean skipResources = true;
    private final DolphinSchedulerApi dolphinSchedulerApiService;

    public DolphinSchedulerReader(String endpoint, String token, String version, List<String> projects, List<Long> codes, File exportFile) {
        this.version = version;
        this.projects = projects;
        this.codes = codes;
        this.exportFile = exportFile;
        if (this.isVersion1()) {
            this.dolphinSchedulerApiService = new DolphinSchedulerApiService(endpoint, token);
        } else if (this.isVersion2()) {
            this.dolphinSchedulerApiService = new DolphinSchedulerApiV2Service(endpoint, token);
        } else if (this.isVersion3()) {
            this.dolphinSchedulerApiService = new DolphinschedulerApiV3Service(endpoint, token);
        } else {
            throw new RuntimeException("unsupported dolphinscheduler version: " + version);
        }
        Config.init();
        Config.get().setVersion(version);
    }

    public File export() throws Exception {
        File parent = new File(this.exportFile.getParentFile(), StringUtils.split((String)this.exportFile.getName(), (String)".")[0]);
        if (!parent.exists() && !parent.mkdirs()) {
            LOGGER.error("failed create file directory for: {}", (Object)this.exportFile);
            return null;
        }
        LOGGER.info("workspace directory: {}", (Object)parent);
        File tmpDir = new File(parent, ".tmp");
        if (tmpDir.exists()) {
            FileUtils.deleteDirectory((File)tmpDir);
        }
        this.doExport(tmpDir);
        if (this.exportFile.getName().endsWith("zip")) {
            return this.doPackage(tmpDir, this.exportFile);
        }
        return tmpDir;
    }

    private File doPackage(File tmpDir, File exportFile) throws IOException {
        return ZipUtils.zipDir((File)tmpDir, (File)exportFile);
    }

    private void doExport(File tmpDir) throws Exception {
        this.writePackageInfoJson(tmpDir);
        this.exportProjects(tmpDir);
        this.exportResourceFiles(tmpDir);
        this.exportUdfFunctions(tmpDir);
        this.exportDataSources(tmpDir);
        ListUtils.emptyIfNull(this.projects).forEach(project -> {
            try {
                File projects = new File(tmpDir, PROJECTS);
                this.exportProcessDefinition(new File(projects, (String)project), (String)project);
            }
            catch (Exception e) {
                LOGGER.error("export project: {} process definition failed: ", project);
                throw new RuntimeException(e);
            }
        });
    }

    private void exportProjects(File tmpDir) throws Exception {
        Response response = this.dolphinSchedulerApiService.queryAllProjectList(new DolphinSchedulerRequest());
        List projectsList = (List)response.getData();
        projectsList = ListUtils.emptyIfNull((List)projectsList).stream().filter(proj -> {
            if (proj.has("name") && this.projects.contains(proj.get("name").getAsString())) {
                return true;
            }
            return proj.has("code") && this.codes.contains(proj.get("code").getAsLong());
        }).peek(proj -> {
            if (this.isVersion2() || this.isVersion3()) {
                String name = proj.get("name").getAsString();
                Long code = proj.get("code").getAsLong();
                this.projectNameToCodeMap.put(name, code);
            }
        }).collect(Collectors.toList());
        if (this.projects.isEmpty()) {
            this.projects.addAll(this.projectNameToCodeMap.keySet());
        }
        this.projectInfoList = ListUtils.emptyIfNull(projectsList).stream().map(proj -> GsonUtils.fromJsonString((String)GsonUtils.toJsonString((Object)proj), (Type)new TypeToken<Project>(){}.getType())).map(proj -> (Project)proj).collect(Collectors.toList());
        File projectFile = new File(tmpDir, PROJECTS_JSON);
        FileUtils.writeStringToFile((File)projectFile, (String)GsonUtils.toJsonString(projectsList), (Charset)StandardCharsets.UTF_8);
    }

    private void exportDataSources(File tmpDir) throws InterruptedException {
        File datasourceDir = new File(tmpDir, DATASOURCE);
        if (!datasourceDir.exists() && !datasourceDir.mkdirs()) {
            LOGGER.error("error make datasource directory: {}", (Object)datasourceDir);
            return;
        }
        QueryDataSourceListByPaginateRequest request = new QueryDataSourceListByPaginateRequest();
        PaginateUtils.Paginator paginator = new PaginateUtils.Paginator();
        paginator.setPageNum(1);
        paginator.setPageSize(20);
        PaginateUtils.doPaginate((PaginateUtils.Paginator)paginator, p -> {
            try {
                request.setPageNo(Integer.valueOf(p.getPageNum()));
                request.setPageSize(Integer.valueOf(p.getPageSize()));
                PaginateResponse response = this.dolphinSchedulerApiService.queryDataSourceListByPaging(request);
                log.info("response: {}", (Object)response);
                FileUtils.writeStringToFile((File)new File(datasourceDir, "datasource_page_" + p.getPageNum() + ".json"), (String)GsonUtils.toJsonString(Optional.ofNullable(response).map(Response::getData).map(PaginateData::getTotalList).orElse(null)), (Charset)StandardCharsets.UTF_8);
                PaginateUtils.PaginateResult paginateResult = new PaginateUtils.PaginateResult();
                paginateResult.setPageNum(p.getPageNum());
                paginateResult.setPageSize(p.getPageSize());
                paginateResult.setData((List)Optional.ofNullable(response).map(Response::getData).map(PaginateData::getTotalList).orElse(null));
                paginateResult.setTotalCount(Optional.ofNullable(response).map(Response::getData).map(PaginateData::getTotal).orElse(0).intValue());
                return paginateResult;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void exportUdfFunctions(File tmpDir) throws Exception {
        File udfFunctionDir = new File(tmpDir, UDF_FUNCTION);
        if (!udfFunctionDir.exists() && !udfFunctionDir.mkdirs()) {
            LOGGER.error("error make udf function directory: {}", (Object)udfFunctionDir);
            return;
        }
        QueryUdfFuncListByPaginateRequest request = new QueryUdfFuncListByPaginateRequest();
        PaginateUtils.Paginator paginator = new PaginateUtils.Paginator();
        paginator.setPageNum(1);
        paginator.setPageSize(20);
        PaginateUtils.doPaginate((PaginateUtils.Paginator)paginator, p -> {
            try {
                request.setPageNo(Integer.valueOf(p.getPageNum()));
                request.setPageSize(Integer.valueOf(p.getPageSize()));
                PaginateResponse response = this.dolphinSchedulerApiService.queryUdfFuncListByPaging(request);
                FileUtils.writeStringToFile((File)new File(udfFunctionDir, "udf_function_page_" + p.getPageNum() + ".json"), (String)GsonUtils.toJsonString((Object)((PaginateData)response.getData()).getTotalList()), (Charset)StandardCharsets.UTF_8);
                PaginateUtils.PaginateResult paginateResult = new PaginateUtils.PaginateResult();
                paginateResult.setPageNum(p.getPageNum());
                paginateResult.setPageSize(p.getPageSize());
                paginateResult.setData(((PaginateData)response.getData()).getTotalList());
                paginateResult.setTotalCount(((PaginateData)response.getData()).getTotal().intValue());
                return paginateResult;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void exportResourceFiles(File tmpDir) {
        File resourceDir = new File(tmpDir, RESOURCE);
        if (!resourceDir.exists() && !resourceDir.mkdirs()) {
            LOGGER.error("error make resource directory: {}", (Object)resourceDir);
            return;
        }
        ArrayList resources = new ArrayList();
        Arrays.asList("FILE", "UDF").forEach(type -> {
            if (this.isVersion3()) {
                this.visitResourceByPage((String)type, null, -1, resourceDir, resources);
            } else {
                this.visitResource((String)type, null, -1, resourceDir, resources);
            }
        });
        try {
            FileUtils.writeStringToFile((File)new File(resourceDir, "resources.json"), (String)GsonUtils.toJsonString(resources), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void visitResourceByPage(String type, String fullName, int dirId, File resourceDir, List<JsonElement> resources) {
        try {
            List<JsonElement> data;
            int pageNum = 1;
            int pageSize = 1000;
            while (!CollectionUtils.isEmpty(data = this.getResource(type, fullName, dirId, pageNum, pageSize))) {
                resources.addAll(data);
                List resourceComponents = (List)GsonUtils.fromJsonString((String)GsonUtils.toJsonString(data), (Type)new com.google.common.reflect.TypeToken<List<ResourceComponent>>(){}.getType());
                for (ResourceComponent component : resourceComponents) {
                    if (component.isDirctory() || component.isDirectory()) {
                        String currentDir = resourceDir.getAbsolutePath();
                        if (component.getFileName() != null) {
                            currentDir = currentDir + File.separator + component.getFileName();
                        }
                        File visitDir = new File(currentDir);
                        this.visitResourceByPage(type, component.getFullName(), component.getId(), visitDir, resources);
                        continue;
                    }
                    if (BooleanUtils.isTrue((Boolean)this.skipResources)) continue;
                    if (!resourceDir.exists()) {
                        resourceDir.mkdirs();
                    }
                    this.downloadResource(component, resourceDir.getAbsolutePath());
                }
                if (data.size() == pageSize) {
                    ++pageNum;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void visitResource(String type, String fullName, int dirId, File resourceDir, List<JsonElement> resources) {
        try {
            List<JsonElement> data = this.getResource(type, fullName, dirId, 1, 1000);
            this.visitResource(data, resources);
            this.downloadResource(resources, resourceDir);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void visitResource(List<JsonElement> data, List<JsonElement> resources) {
        for (JsonElement jsonElement : data) {
            if (!jsonElement.isJsonObject()) continue;
            JsonObject obj = jsonElement.getAsJsonObject();
            if (obj.has("children") && obj.get("children").isJsonArray()) {
                JsonArray array = obj.get("children").getAsJsonArray();
                List children = array.asList();
                this.visitResource(children, resources);
                jsonElement.getAsJsonObject().remove("children");
            }
            resources.add(jsonElement);
        }
    }

    private void downloadResource(List<JsonElement> resources, File resourceDir) {
        List resourceComponents = (List)GsonUtils.fromJsonString((String)GsonUtils.toJsonString(resources), (Type)new com.google.common.reflect.TypeToken<List<ResourceComponent>>(){}.getType());
        for (ResourceComponent component : resourceComponents) {
            File visitDir;
            if (component.isDirctory() || component.isDirectory()) continue;
            String dir = resourceDir.getAbsolutePath();
            if (!component.getFullName().equals(component.getName())) {
                dir = dir + File.separator + component.getFullName().replace(component.getName(), "");
            }
            if (!(visitDir = new File(dir)).exists()) {
                visitDir.mkdirs();
            }
            this.downloadResource(component, dir);
        }
    }

    private List<JsonElement> getResource(String type, String fullName, int dirId, int pageNum, int pageSize) throws Exception {
        QueryResourceListRequest queryResourceListRequest = new QueryResourceListRequest();
        queryResourceListRequest.setType(type);
        queryResourceListRequest.setFullName(fullName);
        queryResourceListRequest.setDirId(dirId);
        List response = this.dolphinSchedulerApiService.queryResourceListByPage(queryResourceListRequest, pageNum, pageSize);
        return response;
    }

    private void downloadResource(ResourceComponent resource, String currentDir) {
        DownloadResourceRequest downloadResourceRequest = new DownloadResourceRequest();
        downloadResourceRequest.setId(Integer.valueOf(resource.getId()));
        downloadResourceRequest.setFullName(resource.getFullName());
        downloadResourceRequest.setDir(currentDir);
        try {
            this.dolphinSchedulerApiService.downloadResource(downloadResourceRequest);
        }
        catch (Exception e) {
            LOGGER.error("download resource error: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void visitAndDownloadResource(List<ResourceComponent> components, String parentDir) {
        for (ResourceComponent resource : components) {
            String currentDir = parentDir;
            if (resource.isDirctory()) {
                File file;
                if (resource.getName() != null) {
                    currentDir = currentDir + File.separator + resource.getName();
                }
                if (!(file = new File(currentDir)).exists()) {
                    file.mkdirs();
                }
                this.visitAndDownloadResource(resource.getChildren(), currentDir);
                continue;
            }
            DownloadResourceRequest downloadResourceRequest = new DownloadResourceRequest();
            downloadResourceRequest.setId(Integer.valueOf(resource.getId()));
            downloadResourceRequest.setDir(currentDir);
            try {
                this.dolphinSchedulerApiService.downloadResource(downloadResourceRequest);
            }
            catch (Exception e) {
                LOGGER.error("download resource error: {}", (Object)e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    private void exportProcessDefinition(File projectDir, String project) throws Exception {
        int count = this.queryProcessDefinitionCount(project);
        if (count == 0) {
            LOGGER.warn("total process definition count: {}", (Object)count);
            return;
        }
        LOGGER.info("total process definition count: {}", (Object)count);
        LOGGER.info("exporting process definition by page");
        File processDefinitionDir = new File(projectDir, PROCESS_DEFINITION);
        if (!processDefinitionDir.mkdirs()) {
            LOGGER.error("error create process definition directory: {}", (Object)processDefinitionDir);
            return;
        }
        PaginateUtils.Paginator paginator = new PaginateUtils.Paginator();
        paginator.setPageSize(5);
        paginator.setPageNum(1);
        PaginateUtils.doPaginate((PaginateUtils.Paginator)paginator, p -> {
            try {
                List<JsonObject> processDefinitions = this.queryProcessDefinitionByPage((PaginateUtils.Paginator)p, project);
                List<String> idList = ListUtils.emptyIfNull(processDefinitions).stream().map(js -> {
                    if (this.isVersion1()) {
                        return js.getAsJsonObject().get("id").getAsString();
                    }
                    return js.getAsJsonObject().get("code").getAsString();
                }).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(idList)) {
                    String response = this.batchExportProcessDefinitionByIds(idList, project);
                    if (StringUtils.isEmpty((CharSequence)response)) {
                        throw new RuntimeException("get response by export process empty, project " + project + "id " + String.join((CharSequence)",", idList));
                    }
                    JsonNode jsonNode = JSONUtils.parseObject((String)response);
                    if (jsonNode.has("code") && jsonNode.get("code").asInt() > 0) {
                        throw new RuntimeException(response);
                    }
                    if (this.isVersion1()) {
                        this.setProcessId(processDefinitions, jsonNode);
                    }
                    FileUtils.writeStringToFile((File)new File(processDefinitionDir, "process_definitions_page_" + p.getPageNum() + ".json"), (String)JSONUtils.toPrettyString((Object)jsonNode), (Charset)StandardCharsets.UTF_8);
                }
                PaginateUtils.PaginateResult paginateResult = new PaginateUtils.PaginateResult();
                paginateResult.setPageNum(p.getPageNum());
                paginateResult.setPageSize(p.getPageSize());
                paginateResult.setData(processDefinitions);
                paginateResult.setTotalCount(count);
                return paginateResult;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void setProcessId(List<JsonObject> processDefinitions, JsonNode jsonNode) {
        HashMap nameIdMap = Maps.newHashMap();
        for (JsonObject process : processDefinitions) {
            Integer id = null;
            String name = null;
            if (process.has("name")) {
                name = process.get("name").getAsString();
            }
            if (process.has("id")) {
                id = process.get("id").getAsInt();
            }
            nameIdMap.put(name, id);
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode;
        for (int i = 0; i < arrayNode.size(); ++i) {
            JsonNode process = arrayNode.get(i);
            Integer id = (Integer)nameIdMap.get(process.get("processDefinitionName").asText());
            ((ObjectNode)process).put("processDefinitionId", id);
        }
    }

    private int queryProcessDefinitionCount(String project) throws Exception {
        QueryProcessDefinitionByPaginateRequest request = new QueryProcessDefinitionByPaginateRequest();
        request.setPageSize(Integer.valueOf(1));
        request.setPageNo(Integer.valueOf(1));
        request.setProjectName(project);
        Long code = this.getCodeByName(project);
        request.setProjectCode(code);
        PaginateResponse response = this.dolphinSchedulerApiService.queryProcessDefinitionByPaging(request);
        return Optional.ofNullable(response).map(Response::getData).map(PaginateData::getTotal).orElse(0);
    }

    private List<JsonObject> queryProcessDefinitionByPage(PaginateUtils.Paginator p, String project) throws Exception {
        QueryProcessDefinitionByPaginateRequest request = new QueryProcessDefinitionByPaginateRequest();
        request.setPageNo(Integer.valueOf(p.getPageNum()));
        request.setPageSize(Integer.valueOf(p.getPageSize()));
        Long code = this.getCodeByName(project);
        request.setProjectCode(code);
        request.setProjectName(project);
        PaginateResponse response = this.dolphinSchedulerApiService.queryProcessDefinitionByPaging(request);
        return Optional.ofNullable(response).map(Response::getData).map(PaginateData::getTotalList).orElse(new ArrayList(1));
    }

    private String batchExportProcessDefinitionByIds(List<String> ids, String project) throws Exception {
        BatchExportProcessDefinitionByIdsRequest request = new BatchExportProcessDefinitionByIdsRequest();
        request.setIds(ids);
        Long code = this.getCodeByName(project);
        request.setProjectCode(code);
        request.setProjectName(project);
        return this.dolphinSchedulerApiService.batchExportProcessDefinitionByIds(request);
    }

    private void writePackageInfoJson(File tmpDir) throws IOException {
        File packageInfoJson = new File(tmpDir, PACKAGE_INFO_JSON);
        LOGGER.info("writing {}", (Object)packageInfoJson);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("version", this.version);
        FileUtils.writeStringToFile((File)packageInfoJson, (String)GsonUtils.toJsonString((Object)jsonObject), (Charset)StandardCharsets.UTF_8);
        LOGGER.info("writing {} done", (Object)packageInfoJson);
    }

    public DolphinSchedulerReader setSkipResources(Boolean skipResources) {
        this.skipResources = skipResources;
        return this;
    }

    private boolean isVersion1() {
        return StringUtils.startsWith((CharSequence)this.version, (CharSequence)"1.");
    }

    private boolean isVersion2() {
        return StringUtils.startsWith((CharSequence)this.version, (CharSequence)"2.");
    }

    private boolean isVersion3() {
        return StringUtils.startsWith((CharSequence)this.version, (CharSequence)"3.");
    }

    private Long getCodeByName(String projectName) {
        Long code = this.projectNameToCodeMap.get(projectName);
        if ((this.isVersion2() || this.isVersion3()) && code == null) {
            throw new RuntimeException("project code not found by name: " + projectName);
        }
        return code;
    }
}

