/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.reader.dolphinscheduler;

import com.aliyun.dataworks.client.command.CommandApp;
import com.aliyun.dataworks.migrationx.reader.dolphinscheduler.DolphinSchedulerReader;
import com.aliyun.migrationx.common.utils.JSONUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinSchedulerCommandApp
extends CommandApp {
    private static final Logger log = LoggerFactory.getLogger(DolphinSchedulerCommandApp.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(DolphinSchedulerCommandApp.class);
    private static final String LONG_OPT_SKIP_RESOURCES = "skip-resources";
    private static final String OPT_SKIP_RESOURCES = "sr";
    private static final String CODE_LABEL = "code";
    private static final String NAME_LABEL = "name";

    public void run(String[] args) {
        Options options = this.getOptions();
        String javaVersion = System.getProperty("java.version");
        log.info("running with java version: {}", (Object)javaVersion);
        log.info("args: {}", (Object)JSONUtils.toJsonString((Object)args));
        HelpFormatter helpFormatter = new HelpFormatter();
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine commandLine = parser.parse(options, args);
            String endpoint = commandLine.getOptionValue("e");
            String token = commandLine.getOptionValue("t");
            String version = commandLine.getOptionValue("v");
            String projectStr = commandLine.getOptionValue("p");
            Pair<List<String>, List<Long>> pair = this.parseProjects(projectStr);
            String file = commandLine.getOptionValue("f", "output");
            DolphinSchedulerReader exporter = new DolphinSchedulerReader(endpoint, token, version, (List)pair.getLeft(), (List)pair.getRight(), new File(new File(file).getAbsolutePath()));
            String sr = commandLine.getOptionValue(OPT_SKIP_RESOURCES, "true");
            exporter.setSkipResources(Boolean.parseBoolean(sr));
            File exportedFile = exporter.export();
            LOGGER.info("exported file: {}", (Object)exportedFile);
        }
        catch (ParseException e) {
            LOGGER.error("parser command error: {}", (Object)e.getMessage());
            helpFormatter.printHelp("Options", options);
            System.exit(-1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addRequiredOption("e", "endpoint", true, "DolphinScheduler Web API endpoint url, example: http://123.123.123.12:12343");
        options.addRequiredOption("t", "token", true, "DolphinScheduler API token");
        options.addRequiredOption("v", "version", true, "DolphinScheduler version");
        options.addOption("p", "projects", true, "DolphinScheduler project names, example: project_a,project_b,project_c");
        options.addOption("f", "file", true, "Output zip file");
        options.addOption(OPT_SKIP_RESOURCES, LONG_OPT_SKIP_RESOURCES, true, "skip exporting resources");
        return options;
    }

    private Pair<List<String>, List<Long>> parseProjects(String projectStr) {
        List<Object> projects = new ArrayList();
        List<Object> codes = new ArrayList();
        String[] projectTypes = projectStr.split(":");
        if (projectTypes.length == 2) {
            if (CODE_LABEL.equalsIgnoreCase(projectTypes[0])) {
                String[] codeStr = projectTypes[1].split(",");
                codes = Arrays.stream(codeStr).map(Long::parseLong).collect(Collectors.toList());
            } else {
                String[] codeStr = projectTypes[1].split(",");
                projects = Arrays.asList(codeStr);
            }
        } else {
            projects = Arrays.asList(StringUtils.split((String)projectStr, (String)","));
        }
        return Pair.of(projects, codes);
    }

    public static void main(String[] args) {
        DolphinSchedulerCommandApp app = new DolphinSchedulerCommandApp();
        app.run(args);
    }
}

