/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.reader.dataworks;

import com.aliyun.dataworks.client.command.CommandApp;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.openapi.DataWorksOpenApiService;
import com.aliyun.dataworks_public20240518.models.GetWorkflowDefinitionResponseBody;
import com.aliyun.dataworks_public20240518.models.ListWorkflowDefinitionsResponseBody;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWorksFlowSpecReader
extends CommandApp {
    private static final Logger log = LoggerFactory.getLogger(DataWorksFlowSpecReader.class);

    public static void main(String[] args) throws Exception {
        new DataWorksFlowSpecReader().run(args);
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addRequiredOption("e", "endpoint", true, "dataworks endpoint, example: dataworks.cn-hangzhou.aliyuncs.com");
        options.addRequiredOption("p", "projectId", true, "dataworks project id");
        options.addRequiredOption("f", "file", true, "flow spec json file");
        options.addOption("ak", "accessKeyId", true, "dataworks access key id");
        options.addOption("sk", "accessKeySecret", true, "dataworks access key secret");
        Option workflowIdOption = Option.builder((String)"w").longOpt("workflowId").numberOfArgs(-2).desc("workflow id, multiple ids separated by space").build();
        options.addOption(workflowIdOption);
        return options;
    }

    protected void doCommandRun(Options options, CommandLine cli, String[] args) {
        String endpoint = cli.getOptionValue("e");
        String projectId = cli.getOptionValue("p");
        String filePath = cli.getOptionValue("f");
        String[] workflowIds = cli.getOptionValues("w");
        String accessKeyId = cli.getOptionValue("ak");
        String accessKeySecret = cli.getOptionValue("sk");
        DataWorksOpenApiService dataWorksOpenApiService = new DataWorksOpenApiService(endpoint, projectId, accessKeyId, accessKeySecret);
        File file = new File(filePath);
        if (file.exists() && !file.delete()) {
            log.error("target file exists and can not be deleted, file: {}", (Object)filePath);
            throw new BizException(ErrorCode.NO_PERMISSION, new Object[]{"delete file " + filePath});
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            this.readFlowSpec(dataWorksOpenApiService, projectId, new HashSet<String>(Arrays.asList((String[])ObjectUtils.defaultIfNull((Object)workflowIds, (Object)new String[0]))), writer);
        }
        catch (IOException e) {
            log.error("write to target file error", (Throwable)e);
        }
        log.info("read dataworks workflow success, flow spec json target path: {}", (Object)file);
    }

    public void readFlowSpec(DataWorksOpenApiService dataWorksOpenApiService, String projectId, Set<String> workflowIds, BufferedWriter writer) {
        int pageNo = 0;
        int pageSize = 10;
        int total = 0;
        boolean isFirst = true;
        boolean conditionEmpty = CollectionUtils.isEmpty(workflowIds);
        do {
            log.info("read dataworks workflow, page: {}, total: {}", (Object)(++pageNo), (Object)total);
            try {
                ListWorkflowDefinitionsResponseBody.ListWorkflowDefinitionsResponseBodyPagingInfo listWorkflowDefinitionsResponseBodyPagingInfo = dataWorksOpenApiService.listWorkflows(projectId, Integer.valueOf(pageNo), Integer.valueOf(pageSize));
                if (listWorkflowDefinitionsResponseBodyPagingInfo == null) {
                    log.warn("error occur when list workflow, response is null, projectId: {}, pageNum: {}, pageSize: {}", new Object[]{projectId, pageNo, pageSize});
                    continue;
                }
                total = listWorkflowDefinitionsResponseBodyPagingInfo.getTotalCount();
                List workflowIdList = ListUtils.emptyIfNull((List)listWorkflowDefinitionsResponseBodyPagingInfo.getWorkflowDefinitions()).stream().map(ListWorkflowDefinitionsResponseBody.ListWorkflowDefinitionsResponseBodyPagingInfoWorkflowDefinitions::getId).filter(id -> conditionEmpty || workflowIds.contains(id)).collect(Collectors.toList());
                for (String workflowId : workflowIdList) {
                    try {
                        GetWorkflowDefinitionResponseBody.GetWorkflowDefinitionResponseBodyWorkflowDefinition workflow = dataWorksOpenApiService.getWorkflow(projectId, workflowId);
                        String spec = Optional.ofNullable(workflow).map(GetWorkflowDefinitionResponseBody.GetWorkflowDefinitionResponseBodyWorkflowDefinition::getSpec).orElse(null);
                        if (!StringUtils.isNotBlank((CharSequence)spec)) continue;
                        if (isFirst) {
                            writer.write("[");
                            isFirst = false;
                        } else {
                            writer.write(",");
                            writer.newLine();
                        }
                        writer.newLine();
                        writer.write(spec);
                    }
                    catch (Exception e) {
                        log.error("read single workflow data error, workflow id: {}", (Object)workflowId, (Object)e);
                    }
                }
                writer.flush();
            }
            catch (Exception e) {
                log.error("read dataworks workflow data error, pageNum: {}, pageSize: {}", new Object[]{pageNo, pageSize, e});
            }
        } while (pageNo * pageSize < total);
        try {
            writer.newLine();
            writer.write("]");
            writer.flush();
        }
        catch (IOException e) {
            log.error("write json array end token error", (Throwable)e);
        }
    }
}

