/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dsv3.convert;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.subprocess.SubProcessParameters;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.BwmDAGUtil;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubProcessNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(SubProcessNodeConvert.class);

    public SubProcessNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    private Boolean isNewIde() {
        Boolean isNewIde;
        try {
            isNewIde = ((JSONObject)BwmConfiguration.from((String)this.taskContext.getBwmConfiguration()).get("self")).getBoolean("if.use.dataworks.newidea");
        }
        catch (Exception e) {
            log.info("\u672a\u8bc6\u522b\u5230if.use.dataworks.newidea\u914d\u7f6e\u9879\uff0c\u9ed8\u8ba4\u5411\u65e7\u7248IDE\u8f6c\u6362\u3002");
            return false;
        }
        if (isNewIde == null) {
            log.info("\u672a\u8bc6\u522b\u5230if.use.dataworks.newidea\u914d\u7f6e\u9879\uff0c\u9ed8\u8ba4\u5411\u65e7\u7248IDE\u8f6c\u6362\u3002");
            return false;
        }
        return isNewIde;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (this.isNewIde().booleanValue()) {
            return this.newIdeConvert(workflowNodes);
        }
        return this.oldIdeConvert(workflowNodes);
    }

    public List<WorkflowNode> newIdeConvert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        SubProcessParameters parameter = (SubProcessParameters)GsonUtils.fromJsonString((String)workflowNode.getScript(), (Type)TypeToken.get(SubProcessParameters.class).getType());
        long processDefinitionCode = parameter.getProcessDefinitionCode();
        tgtworkflowNode.setScript(String.valueOf(processDefinitionCode));
        tgtworkflowNode.setNodeType(CodeProgramType.SUB_PROCESS.name());
        tgtNodes.add(tgtworkflowNode);
        Map ownerMap = this.getOwnerMapping(this.bwmConfiguration);
        tgtNodes.forEach(node -> {
            if (ownerMap.containsKey(node.getOwner())) {
                node.setOwner((String)ownerMap.get(node.getOwner()));
            }
        });
        return tgtNodes;
    }

    public List<WorkflowNode> oldIdeConvert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        SubProcessParameters parameter = (SubProcessParameters)GsonUtils.fromJsonString((String)workflowNode.getScript(), (Type)TypeToken.get(SubProcessParameters.class).getType());
        long processDefinitionCode = parameter.getProcessDefinitionCode();
        List workflowList = this.taskContext.getWorkflowProjectPackage().getWorkflowList();
        List dependWorkflowList = ListUtils.emptyIfNull((List)workflowList).stream().filter(x -> x.getWorkflowId().equalsIgnoreCase(String.valueOf(processDefinitionCode))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(dependWorkflowList)) {
            Workflow dependWorkflow = (Workflow)dependWorkflowList.get(0);
            List headNodeIds = BwmDAGUtil.findHeadNodeIds((Workflow)dependWorkflow);
            List tailNodeIds = BwmDAGUtil.findTailNodeIds((Workflow)dependWorkflow);
            WorkflowNode startNode = new WorkflowNode();
            startNode.setNodeType(CodeProgramType.VIRTUAL.name());
            startNode.setNodeName(Joiner.on((String)"_").join((Object)workflowNode.getNodeName(), (Object)this.workflow.getWorkflowId(), new Object[]{"start"}));
            startNode.setNodeId(startNode.getNodeName());
            WorkflowNode endNode = new WorkflowNode();
            endNode.setNodeType(CodeProgramType.VIRTUAL.name());
            endNode.setNodeName(Joiner.on((String)"_").join((Object)workflowNode.getNodeName(), (Object)this.workflow.getWorkflowId(), new Object[]{"end"}));
            endNode.setNodeId(endNode.getNodeName());
            if (CollectionUtils.isEmpty((Collection)this.workflow.getNodeRelations())) {
                this.workflow.setNodeRelations(new ArrayList());
            }
            List parentNodeIds = this.getParentNodeIds(workflowNode);
            ListUtils.emptyIfNull((List)parentNodeIds).forEach(x -> this.workflow.getNodeRelations().add(new RelationPackage(x, startNode.getNodeId(), RelationPackage.ReType.NODE)));
            ListUtils.emptyIfNull((List)headNodeIds).forEach(x -> this.workflow.getNodeRelations().add(new RelationPackage(startNode.getNodeId(), x, RelationPackage.ReType.NODE)));
            ListUtils.emptyIfNull((List)tailNodeIds).forEach(x -> this.workflow.getNodeRelations().add(new RelationPackage(x, endNode.getNodeId(), RelationPackage.ReType.NODE)));
            List childrenNodeIds = this.getChildrenNodeIds(workflowNode);
            ListUtils.emptyIfNull((List)childrenNodeIds).forEach(x -> this.workflow.getNodeRelations().add(new RelationPackage(endNode.getNodeId(), x, RelationPackage.ReType.NODE)));
            this.supplyBaseMsg(startNode);
            this.supplyBaseMsg(endNode);
            tgtNodes.add(startNode);
            tgtNodes.add(endNode);
        } else {
            tgtworkflowNode.setNodeType(CodeProgramType.VIRTUAL.getName());
            this.supplyBaseMsg(tgtworkflowNode);
            tgtNodes.add(tgtworkflowNode);
        }
        return tgtNodes;
    }
}

