/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dsv3.convert;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.domain.dw.types.CalcEngineType;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.dw.types.LabelType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.hivecli.HiveCliParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.transformer.DataWorksTransformerConfig;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCliNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(HiveCliNodeConvert.class);

    public HiveCliNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("deepcopy node failed {}", (Object)workflowNode.getNodeId());
            return new ArrayList<WorkflowNode>();
        }
        HiveCliParameters hiveCliParameters = (HiveCliParameters)GsonUtils.fromJsonString((String)workflowNode.getScript(), (Type)TypeToken.get(HiveCliParameters.class).getType());
        String nodeType = this.getNodeType(workflowNode);
        tgtworkflowNode.setNodeType(nodeType);
        if (CodeProgramType.EMR_SHELL.name().equalsIgnoreCase(nodeType)) {
            this.convertEmrShellNode(tgtworkflowNode, hiveCliParameters);
        } else if (CodeProgramType.ODPS_SQL.name().equalsIgnoreCase(nodeType)) {
            this.convertOdpsNode(tgtworkflowNode, hiveCliParameters);
        } else {
            String hiveSqlScript = hiveCliParameters.getHiveSqlScript();
            tgtworkflowNode.setScript(hiveSqlScript);
        }
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }

    private void convertOdpsNode(WorkflowNode workflowNode, HiveCliParameters hiveCliParameters) {
        String hiveCliTaskExecutionType = hiveCliParameters.getHiveCliTaskExecutionType();
        if ("FILE".equals(hiveCliTaskExecutionType)) {
            List resourceList = hiveCliParameters.getResourceList();
            ListUtils.emptyIfNull((List)resourceList).forEach(x -> {
                String resourceName = x.getResourceName();
                String baseDirPath = this.taskContext.getBaseDirPath();
                File file = new File(new File(baseDirPath), resourceName);
                if (file.exists()) {
                    try {
                        workflowNode.setScript(FileUtils.readFileToString((File)file.getAbsoluteFile()));
                    }
                    catch (IOException e) {
                        log.warn("not found hive cli file");
                    }
                }
            });
        } else {
            workflowNode.setScript(hiveCliParameters.getHiveSqlScript());
        }
    }

    private void convertEmrShellNode(WorkflowNode workflowNode, HiveCliParameters hiveCliParameters) {
        String cmd = this.buildCommand(hiveCliParameters, workflowNode);
        workflowNode.setScript(cmd);
        workflowNode.setScript(HiveCliNodeConvert.wfToEmrCode((WorkflowNode)workflowNode));
    }

    private String buildCommand(HiveCliParameters hiveCliParameters, WorkflowNode node) {
        String type = hiveCliParameters.getHiveCliTaskExecutionType();
        String resName = "";
        if ("FILE".equals(type)) {
            List resourceInfos = hiveCliParameters.getResourceList();
            if (resourceInfos != null && resourceInfos.size() > 0) {
                resName = ((ResourceInfo)resourceInfos.get(0)).getResourceName();
            }
        } else {
            String sqlContent = hiveCliParameters.getHiveSqlScript();
            try {
                resName = this.generateSqlScriptFile(sqlContent, node);
            }
            catch (IOException e) {
                log.error("generateSqlScriptFile error ", (Throwable)e);
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.NODE_CONVERT_FAILED);
            }
        }
        ArrayList<Object> args = new ArrayList<Object>();
        ArrayList<String> resources = new ArrayList<String>();
        resources.add(resName);
        String resourceRef = DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.valueOf((String)node.getNodeType()), (String)"", resources);
        args.add(resourceRef + "hive -f");
        args.add(resName);
        String hiveCliOptions = hiveCliParameters.getHiveCliOptions();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)hiveCliOptions)) {
            args.add(hiveCliOptions);
        }
        String command = String.join((CharSequence)" ", args);
        return command;
    }

    private String generateSqlScriptFile(String rawScript, WorkflowNode workflowNode) throws IOException {
        WorkflowFileResource fileResource = new WorkflowFileResource();
        fileResource.setProjectId(this.workflow.getProjectId());
        fileResource.setName(Joiner.on((String)"_").join((Object)this.workflow.getWorkflowName(), (Object)workflowNode.getNodeName(), new Object[0]) + ".sql");
        if (CollectionUtils.isEmpty((Collection)this.workflow.getFiles())) {
            this.workflow.setFiles(new ArrayList());
        }
        ArrayList<String> paths = new ArrayList<String>();
        DataWorksTransformerConfig config = DataWorksTransformerConfig.getConfig();
        if (config != null) {
            paths.add(CalcEngineType.EMR.getDisplayName(config.getLocale()));
            paths.add(LabelType.RESOURCE.getDisplayName(config.getLocale()));
        } else {
            paths.add(CalcEngineType.EMR.getDisplayName(Locale.SIMPLIFIED_CHINESE));
            paths.add(LabelType.RESOURCE.getDisplayName(Locale.SIMPLIFIED_CHINESE));
        }
        fileResource.setFolder(Joiner.on((String)File.separator).join(paths));
        fileResource.setFileType(CodeProgramType.EMR_FILE.name());
        File tmpFIle = new File(FileUtils.getTempDirectory(), fileResource.getName());
        FileUtils.writeStringToFile((File)tmpFIle, (String)rawScript, (Charset)StandardCharsets.UTF_8);
        fileResource.setPath(tmpFIle.getAbsolutePath());
        this.workflow.getFiles().add(fileResource);
        return fileResource.getName();
    }

    protected String getNodeType(WorkflowNode workflowNode) {
        Map nodeConfMap = this.getNodeConfMap(workflowNode);
        String orDefault = ((Map)Optional.ofNullable(nodeConfMap).orElse(new HashMap())).getOrDefault("workflow.converter.dolphinscheduler.sqlNodeTypeMapping", CodeProgramType.SQL_COMPONENT.name());
        if (orDefault instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)orDefault;
            String dbType = jsonObject.getString("HIVE");
            if (StringUtils.isNotBlank((String)dbType)) {
                return dbType;
            }
            dbType = jsonObject.getString("Hive");
            if (StringUtils.isNotBlank((String)dbType)) {
                return dbType;
            }
            dbType = jsonObject.getString("hive");
            if (StringUtils.isNotBlank((String)dbType)) {
                return dbType;
            }
        }
        return CodeProgramType.EMR_HIVE.name();
    }
}

