/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dsv3.convert;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.dependent.DependentParameters;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmDAGUtil;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependentNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(DependentNodeConvert.class);

    public DependentNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        JsonObject param = (JsonObject)GsonUtils.fromJsonString((String)workflowNode.getScript(), JsonObject.class);
        DependentParameters dependentParameters = null;
        if (param.get("dependence") != null) {
            dependentParameters = (DependentParameters)GsonUtils.fromJson((JsonObject)param.getAsJsonObject("dependence"), DependentParameters.class);
        }
        if (dependentParameters == null || dependentParameters.getDependTaskList() == null || dependentParameters.getDependTaskList().isEmpty()) {
            log.warn("no dependence param {}", (Object)workflowNode.getScript());
            tgtworkflowNode.setNodeType(CodeProgramType.VIRTUAL.getName());
            this.supplyBaseMsg(tgtworkflowNode);
            tgtNodes.add(tgtworkflowNode);
            return tgtNodes;
        }
        if (CollectionUtils.isEmpty((Collection)this.workflow.getNodeRelations())) {
            this.workflow.setNodeRelations(new ArrayList());
        }
        List dependencies = dependentParameters.getDependTaskList();
        ListUtils.emptyIfNull((List)dependencies).forEach(dependModel -> ListUtils.emptyIfNull((List)dependModel.getDependItemList()).forEach(depItem -> {
            long depTaskCode = depItem.getDepTaskCode();
            if (depTaskCode != 0L) {
                this.workflow.getNodeRelations().add(new RelationPackage("" + depTaskCode, workflowNode.getNodeId(), RelationPackage.ReType.NODE));
            } else {
                long processCode = depItem.getDefinitionCode();
                this.taskContext.getWorkflowProjectPackage().getWorkflowList().stream().filter(wf -> wf.getWorkflowId().equals(String.valueOf(processCode))).findFirst().ifPresent(wf -> BwmDAGUtil.findTailNodeIds((Workflow)wf).forEach(wfTail -> this.workflow.getNodeRelations().add(new RelationPackage(wfTail, workflowNode.getNodeId(), RelationPackage.ReType.NODE))));
            }
        }));
        tgtworkflowNode.setNodeType(CodeProgramType.VIRTUAL.getName());
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }
}

