/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.util;

import com.aliyun.securitysdk.rass.util.ClassUtils;

public enum WebApplicationType {
    NONE,
    SERVLET,
    REACTIVE;

    private static final String SERVLET_INDICATOR_CLASS = "javax.servlet.Servlet";
    private static final String[] SERVLET_SERVICE_INDICATOR_CLASSES;
    private static final String WEBX_INDICATOR_CLASS = "com.alibaba.citrus.webx.context.WebxContextLoaderListener";
    private static final String WEBMVC_INDICATOR_CLASS = "org.springframework.web.servlet.DispatcherServlet";
    private static final String WEBFLUX_INDICATOR_CLASS = "org.springframework.web.reactive.DispatcherHandler";
    private static final String JERSEY_INDICATOR_CLASS = "org.glassfish.jersey.servlet.ServletContainer";
    public static WebApplicationType CURRENT_TYPE;

    public static WebApplicationType deduceFromClasspath() {
        if (ClassUtils.isPresent(WEBFLUX_INDICATOR_CLASS, null) && !ClassUtils.isPresent(WEBMVC_INDICATOR_CLASS, null) && !ClassUtils.isPresent(JERSEY_INDICATOR_CLASS, null) && !ClassUtils.isPresent(WEBX_INDICATOR_CLASS, null)) {
            return REACTIVE;
        }
        if (!ClassUtils.isPresent(SERVLET_INDICATOR_CLASS, null)) {
            return NONE;
        }
        for (String className : SERVLET_SERVICE_INDICATOR_CLASSES) {
            if (!ClassUtils.isPresent(className, null)) continue;
            return SERVLET;
        }
        return NONE;
    }

    static {
        SERVLET_SERVICE_INDICATOR_CLASSES = new String[]{"org.springframework.web.context.ConfigurableWebApplicationContext", WEBX_INDICATOR_CLASS};
        CURRENT_TYPE = WebApplicationType.deduceFromClasspath();
    }
}

