/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class FileUtils {
    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static FileInputStream openInputStreamQuietly(File file) {
        try {
            return FileUtils.openInputStream(file);
        }
        catch (IOException ex) {
            return null;
        }
    }
}

