/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.resolver.transformer;

import com.aliyun.securitysdk.rass.api.PermissionMode;
import com.aliyun.securitysdk.rass.api.condition.Action;
import com.aliyun.securitysdk.rass.config.schema.Domains;
import com.aliyun.securitysdk.rass.config.schema.ExcludedHosts;
import com.aliyun.securitysdk.rass.config.schema.Hosts;
import com.aliyun.securitysdk.rass.config.schema.IntranetHosts;
import com.aliyun.securitysdk.rass.config.schema.Ips;
import com.aliyun.securitysdk.rass.config.schema.Socket;
import com.aliyun.securitysdk.rass.config.schema.TrustedHosts;
import com.aliyun.securitysdk.rass.permission.checker.SocketPermissionChecker;
import com.aliyun.securitysdk.rass.resolver.formatter.StringMatcherParamsFormatters;
import com.aliyun.securitysdk.rass.resolver.transformer.BasePermissionCheckerTransformer;
import com.aliyun.securitysdk.rass.util.matcher.StringMatcher;
import com.aliyun.securitysdk.rass.util.matcher.StringMatcherEnum;
import com.aliyun.securitysdk.rass.util.matcher.TrieStringMatcher;
import com.aliyun.securitysdk.rass.util.matcher.trie.converter.BinaryTrieNodeConverter;
import com.aliyun.securitysdk.rass.util.matcher.trie.converter.HostLetterTrieNodeConverter;
import com.aliyun.securitysdk.rass.util.tuple.MutableTriple;
import com.aliyun.securitysdk.rass.util.tuple.Triple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Socket2SocketPermissionCheckerTransformer
extends BasePermissionCheckerTransformer {
    public List<SocketPermissionChecker> transform(Socket socket) {
        ArrayList<SocketPermissionChecker> resultCheckers = new ArrayList<SocketPermissionChecker>();
        for (Socket.PermChecker permChecker : socket.getPermChecker()) {
            if (!permChecker.isEnabled()) continue;
            IntranetHosts intranetHosts = permChecker.getIntranetHosts();
            Triple<StringMatcher, StringMatcher, StringMatcher> intranetTriple = this.parseHosts(intranetHosts, StringMatcherEnum.DISALLOWED_DOMAIN, StringMatcherEnum.INTRANET_IP, StringMatcherEnum.INTRANET_IPV6);
            ExcludedHosts excludedHosts = permChecker.getExcludedHosts();
            Triple<StringMatcher, StringMatcher, StringMatcher> excludedTriple = this.parseHosts(excludedHosts, StringMatcherEnum.ALLOWED_DOMAIN, StringMatcherEnum.ALLOWED_IP, StringMatcherEnum.ALLOWED_IPV6);
            TrustedHosts trustedHosts = permChecker.getTrustedHosts();
            Triple<StringMatcher, StringMatcher, StringMatcher> trustedTriple = this.parseHosts(trustedHosts, StringMatcherEnum.TRUSTED_DOMAIN, null, null);
            PermissionMode permissionMode = PermissionMode.toMode((String)permChecker.getMode().value());
            Action[] actions = this.getActions(permChecker);
            SocketPermissionChecker socketPermissionChecker = new SocketPermissionChecker(intranetTriple.getMiddle(), excludedTriple.getMiddle(), intranetTriple.getRight(), excludedTriple.getRight(), intranetTriple.getLeft(), excludedTriple.getLeft(), permissionMode, trustedTriple.getLeft(), true, actions);
            socketPermissionChecker.setShouldCheckStackMatcher(this.resolveStack(permChecker.getEnabledStackMatchers()));
            socketPermissionChecker.setAllowedStackMatcher(this.resolveStack(permChecker.getAllowStackMatchers()));
            socketPermissionChecker.setDisallowedStackMatcher(this.resolveStack(permChecker.getDisallowStackMatchers()));
            resultCheckers.add(socketPermissionChecker);
        }
        return resultCheckers;
    }

    private Triple<StringMatcher, StringMatcher, StringMatcher> parseHosts(Hosts hosts, StringMatcherEnum domainEnum, StringMatcherEnum ipEnum, StringMatcherEnum ipv6Enum) {
        MutableTriple<StringMatcher, StringMatcher, StringMatcher> triple = new MutableTriple<StringMatcher, StringMatcher, StringMatcher>();
        if (hosts != null) {
            Ips ips;
            Domains domains = hosts.getDomains();
            if (domains != null && domainEnum != null) {
                ArrayList<String> domainPatterns = new ArrayList<String>();
                for (Domains.Domain domain : domains.getDomain()) {
                    domainPatterns.add(domain.getPattern());
                }
                triple.setLeft(this.toDomainTrieStringMatcher(domainPatterns));
            }
            if ((ips = hosts.getIps()) != null && ipEnum != null && ipv6Enum != null) {
                triple.setMiddle(this.toIpTrieStringMatcher(StringMatcherParamsFormatters.format(ipEnum, ips.getIp())));
                triple.setRight(this.toIpTrieStringMatcher(StringMatcherParamsFormatters.format(ipv6Enum, ips.getIpv6())));
            }
        }
        return triple;
    }

    private StringMatcher toIpTrieStringMatcher(Collection<String> expressions) {
        if (expressions == null || expressions.isEmpty()) {
            return null;
        }
        return new TrieStringMatcher(new BinaryTrieNodeConverter()).addItems(expressions);
    }

    private StringMatcher toDomainTrieStringMatcher(Collection<String> expressions) {
        if (expressions == null || expressions.isEmpty()) {
            return null;
        }
        return new TrieStringMatcher(new HostLetterTrieNodeConverter(), false).addItems(expressions);
    }
}

