/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.resolver.formatter.mask;

import com.aliyun.securitysdk.rass.resolver.formatter.mask.DomainMask;
import com.aliyun.securitysdk.rass.resolver.formatter.mask.FilePathMask;
import com.aliyun.securitysdk.rass.resolver.formatter.mask.MatcherMask;
import com.aliyun.securitysdk.rass.resolver.formatter.mask.SubnetMask;
import java.util.HashMap;
import java.util.Map;

public abstract class MatcherMasksParsers {
    private static final Map<Class<? extends MatcherMask>, MatcherMasksParser> PARSERS = new HashMap<Class<? extends MatcherMask>, MatcherMasksParser>();
    private static MatcherMasksParser<FilePathMask> fileMaskParser = new MatcherMasksParser<FilePathMask>(){

        @Override
        public FilePathMask parse(String format) {
            return new FilePathMask(format);
        }

        @Override
        public Class<FilePathMask> getMatcherMaskType() {
            return FilePathMask.class;
        }
    };
    private static MatcherMasksParser<SubnetMask> subnetMaskParser = new MatcherMasksParser<SubnetMask>(){

        @Override
        public SubnetMask parse(String format) {
            return new SubnetMask(format);
        }

        @Override
        public Class<SubnetMask> getMatcherMaskType() {
            return SubnetMask.class;
        }
    };
    private static MatcherMasksParser<DomainMask> domainMaskParser = new MatcherMasksParser<DomainMask>(){

        @Override
        public DomainMask parse(String format) {
            return new DomainMask(format);
        }

        @Override
        public Class<DomainMask> getMatcherMaskType() {
            return DomainMask.class;
        }
    };

    private static void register(MatcherMasksParser<? extends MatcherMask> matcherMasksParser) {
        PARSERS.put(matcherMasksParser.getMatcherMaskType(), matcherMasksParser);
    }

    public static <T extends MatcherMask> T parse(String mask, Class<T> clazz) {
        try {
            return PARSERS.get(clazz).parse(mask);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        MatcherMasksParsers.register(fileMaskParser);
        MatcherMasksParsers.register(subnetMaskParser);
        MatcherMasksParsers.register(domainMaskParser);
    }

    static interface MatcherMasksParser<T extends MatcherMask> {
        public T parse(String var1);

        public Class<T> getMatcherMaskType();
    }
}

