/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.permission.checker;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.api.CheckResult;
import com.aliyun.securitysdk.rass.api.Permission;
import com.aliyun.securitysdk.rass.api.PermissionMode;
import com.aliyun.securitysdk.rass.api.condition.Action;
import com.aliyun.securitysdk.rass.api.condition.action.NetAction;
import com.aliyun.securitysdk.rass.api.exception.PermissionException;
import com.aliyun.securitysdk.rass.api.ext.BooleanCheckResult;
import com.aliyun.securitysdk.rass.net.NetHooksEvent;
import com.aliyun.securitysdk.rass.permission.SocketPermission;
import com.aliyun.securitysdk.rass.permission.checker.BasePermissionChecker;
import com.aliyun.securitysdk.rass.util.InetAddressResolver;
import com.aliyun.securitysdk.rass.util.IpAddressUtil;
import com.aliyun.securitysdk.rass.util.StackTraceUtils;
import com.aliyun.securitysdk.rass.util.matcher.DummyStringMatcher;
import com.aliyun.securitysdk.rass.util.matcher.StringMatcher;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;

public class SocketPermissionChecker
extends BasePermissionChecker<SocketPermission> {
    private static final Logger logger = SecurityLogManager.getLogger(SocketPermissionChecker.class);
    private final StringMatcher ipv4IntranetMatcher;
    private final StringMatcher ipv4ExcludedMatcher;
    private final StringMatcher ipv6IntranetMatcher;
    private final StringMatcher ipv6ExcludedMatcher;
    private final StringMatcher domainAllowedMatcher;
    private final StringMatcher domainDisallowedMatcher;
    private final InetAddressResolver inetAddressResolver;
    private final StringMatcher trustedMatcher;
    private List<StringMatcher> stackMatchers;

    public SocketPermissionChecker(StringMatcher ipv4IntranetMatcher, StringMatcher ipv4ExcludedMatcher, StringMatcher ipv6IntranetMatcher, StringMatcher ipv6ExcludedMatcher, StringMatcher disallowedDomainMatcher, StringMatcher allowedDomainMatcher, PermissionMode permissionMode, StringMatcher trustedMatcher, boolean enabled, Action ... actions) {
        super(enabled, "socket checker", permissionMode, actions);
        this.ipv4IntranetMatcher = this.emptyToDummy(ipv4IntranetMatcher);
        this.ipv4ExcludedMatcher = this.emptyToDummy(ipv4ExcludedMatcher);
        this.ipv6IntranetMatcher = this.emptyToDummy(ipv6IntranetMatcher);
        this.ipv6ExcludedMatcher = this.emptyToDummy(ipv6ExcludedMatcher);
        this.domainAllowedMatcher = this.emptyToDummy(allowedDomainMatcher);
        this.domainDisallowedMatcher = this.emptyToDummy(disallowedDomainMatcher);
        this.trustedMatcher = this.emptyToDummy(trustedMatcher);
        this.inetAddressResolver = new InetAddressResolver();
    }

    private boolean checkPermission(SocketPermission permission) {
        if (permission == null) {
            return false;
        }
        if (!this.isEnabledStack()) {
            return true;
        }
        if (!this.shouldCheck((Permission)permission)) {
            return true;
        }
        if (this.checkAllowStack()) {
            return true;
        }
        if (this.checkDisallowStack()) {
            return false;
        }
        NetHooksEvent event = (NetHooksEvent)permission.getResource();
        InetAddress inetAddress = event.getInetAddress();
        return this.checkInetAddress(inetAddress);
    }

    public CheckResult observe(SocketPermission permission) {
        boolean b = this.checkPermission(permission);
        if (!b) {
            logger.info("[observe] check net permission: " + permission.getResource() + " : " + b);
        }
        return BooleanCheckResult.of((boolean)this.checkPermission(permission));
    }

    public CheckResult handle(SocketPermission permission) {
        boolean b = this.checkPermission(permission);
        if (b) {
            return BooleanCheckResult.of((boolean)this.checkPermission(permission));
        }
        logger.info("[block] check net permission: " + permission.getResource() + " : " + b + "\nStackTrace:\n" + StackTraceUtils.stackTraceAsString(Thread.currentThread().getStackTrace()));
        throw new PermissionException("The socket access of " + permission.getResource() + " has been denied.");
    }

    private StringMatcher emptyToDummy(StringMatcher stringMatcher) {
        return stringMatcher == null ? new DummyStringMatcher(false) : stringMatcher;
    }

    private boolean checkDomain(String hostName) {
        return !this.domainDisallowedMatcher.matches(hostName) || this.domainAllowedMatcher.matches(hostName);
    }

    public List<Action> getDefaultActionList() {
        return Arrays.asList(NetAction.Bind, NetAction.Connect);
    }

    public boolean checkInetAddress(InetAddress inetAddress) {
        String hostName = this.inetAddressResolver.findInetAddressHoldingHostName(inetAddress);
        byte[] addressBytes = inetAddress.getAddress();
        if (addressBytes == null) {
            return false;
        }
        String ipString = IpAddressUtil.convertIpBytesToString(addressBytes);
        boolean isIPv6 = inetAddress instanceof Inet6Address;
        return this.checkHostAndIPString(hostName, ipString, isIPv6);
    }

    public boolean checkHostAndIPString(String hostName, String ipString, boolean isIPv6) {
        if (hostName != null && this.trustedMatcher != null && this.trustedMatcher.matches(hostName)) {
            return true;
        }
        if (isIPv6) {
            if (this.ipv6IntranetMatcher.matches(ipString) || this.domainDisallowedMatcher.matches(hostName)) {
                return this.ipv6ExcludedMatcher.matches(ipString) || this.domainAllowedMatcher.matches(hostName);
            }
            return true;
        }
        if (this.ipv4IntranetMatcher.matches(ipString) || this.domainDisallowedMatcher.matches(hostName)) {
            return this.ipv4ExcludedMatcher.matches(ipString) || this.domainAllowedMatcher.matches(hostName);
        }
        return true;
    }

    public boolean isTrusted(String host) {
        return this.trustedMatcher != null && this.trustedMatcher.matches(host);
    }
}

