/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.modifier;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.modifier.PropertyModifier;
import com.aliyun.securitysdk.rass.util.ClassUtils;
import com.aliyun.securitysdk.rass.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.security.action.GetIntegerAction;

public class UdpPropertiesModifier
implements PropertyModifier {
    private static final Logger logger = SecurityLogManager.getLogger(UdpPropertiesModifier.class);
    private static final String RESOURCE_MANAGER_CLASS_NAME = "sun.net.ResourceManager";
    private static final String MAX_SOCKETS_FIELD_NAME = "maxSockets";
    private static final String MAX_DATAGRAM_SOCKETS_NAME = "sun.net.maxDatagramSockets";
    private int maxDatagramSockets;
    private boolean force;

    public UdpPropertiesModifier(int maxDatagramSockets, boolean force) {
        this.maxDatagramSockets = maxDatagramSockets;
        this.force = force;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyProperty() {
        Field field;
        Integer maxDatagramSockets;
        logger.info("Set {} = {}", (Object)MAX_DATAGRAM_SOCKETS_NAME, (Object)this.maxDatagramSockets);
        if (!this.force && (maxDatagramSockets = AccessController.doPrivileged(new GetIntegerAction(MAX_DATAGRAM_SOCKETS_NAME))) != null) {
            this.maxDatagramSockets = maxDatagramSockets;
            logger.info("sun.net.maxDatagramSockets has been set to {}, which won't be forced to be {}", (Object)maxDatagramSockets, (Object)this.maxDatagramSockets);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.setProperty(UdpPropertiesModifier.MAX_DATAGRAM_SOCKETS_NAME, String.valueOf(UdpPropertiesModifier.this.maxDatagramSockets));
            }
        });
        Class<?> clazz = ClassUtils.forNameQuietly(RESOURCE_MANAGER_CLASS_NAME, ClassLoader.getSystemClassLoader());
        if (clazz != null && (field = ReflectionUtils.findField(clazz, MAX_SOCKETS_FIELD_NAME)) != null) {
            boolean isAccessible = field.isAccessible();
            field.setAccessible(true);
            try {
                ReflectionUtils.setFinalField(field, null, this.maxDatagramSockets);
            }
            catch (Exception ex) {
                logger.warn("Failed to reset max sockets of ResourceManager", (Throwable)ex);
            }
            finally {
                field.setAccessible(isAccessible);
            }
        }
    }
}

