/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.modifier;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.config.schema.Serialization;
import com.aliyun.securitysdk.rass.modifier.FastJsonDenyListModifier;
import com.aliyun.securitysdk.rass.modifier.ForkJoinPoolPropertyModifier;
import com.aliyun.securitysdk.rass.modifier.JndiPropertyModifier;
import com.aliyun.securitysdk.rass.modifier.Log4jModifier;
import com.aliyun.securitysdk.rass.modifier.PandoraPropertyModifier;
import com.aliyun.securitysdk.rass.modifier.UdpPropertiesModifier;

public abstract class PropertyModifiers {
    private static final Logger logger = SecurityLogManager.getLogger(PropertyModifiers.class);

    public static void modifyJndiProperties() {
        new JndiPropertyModifier().modifyProperty();
    }

    public static void modifyPandoraProperties() {
        new PandoraPropertyModifier().modifyProperty();
    }

    public static void setMaxDatagramSockets(int maxDatagramSockets) {
        new UdpPropertiesModifier(maxDatagramSockets, false).modifyProperty();
    }

    public static void modifyForkJoinPoolProperties() {
        new ForkJoinPoolPropertyModifier().modifyProperty();
    }

    public static void modifyFastJsonProperties(Serialization serialization) {
        try {
            new FastJsonDenyListModifier(serialization).modifyProperty();
        }
        catch (Throwable ex) {
            logger.warn("Cannot modify fastjson denylist");
        }
    }

    public static void modifyLog4j2LookupProperties() {
        try {
            new Log4jModifier().modifyProperty();
        }
        catch (Throwable t) {
            logger.warn("Cannot remove log4j2 jndi plugin");
        }
    }

    public static void modifyProperties() {
        PropertyModifiers.modifyPandoraProperties();
        PropertyModifiers.modifyJndiProperties();
        PropertyModifiers.modifyForkJoinPoolProperties();
        PropertyModifiers.setMaxDatagramSockets(Integer.MAX_VALUE);
    }
}

