/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.modifier;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.modifier.PropertyModifier;
import com.aliyun.securitysdk.rass.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ForkJoinPoolPropertyModifier
implements PropertyModifier {
    private static final Logger logger = SecurityLogManager.getLogger(ForkJoinPoolPropertyModifier.class);
    private static final String THREAD_FACTORY_NAME = "java.util.concurrent.ForkJoinPool.common.threadFactory";
    private static final String FORK_JOIN_POOL_DEFAULT_FACTORY_NAME = "com.aliyun.securitysdk.rass.modifier.ForkJoinPoolPropertyModifier$DefaultForkJoinWorkerThreadFactory";

    @Override
    public void modifyProperty() {
        ForkJoinPool pool;
        logger.info("Set {} = {}", (Object)THREAD_FACTORY_NAME, (Object)FORK_JOIN_POOL_DEFAULT_FACTORY_NAME);
        String factory = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(ForkJoinPoolPropertyModifier.THREAD_FACTORY_NAME);
            }
        });
        if (factory == null) {
            AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.setProperty(ForkJoinPoolPropertyModifier.THREAD_FACTORY_NAME, ForkJoinPoolPropertyModifier.FORK_JOIN_POOL_DEFAULT_FACTORY_NAME);
                }
            });
        }
        if ((pool = ForkJoinPool.commonPool()).getFactory().getClass().getName().equals("java.util.concurrent.ForkJoinPool$InnocuousForkJoinWorkerThreadFactory") || pool.getFactory().getClass().getName().equals("java.util.concurrent.ForkJoinPool$DefaultForkJoinWorkerThreadFactory") || pool.getFactory().getClass().getName().equals("java.util.concurrent.ForkJoinPool$DefaultCommonPoolForkJoinWorkerThreadFactory")) {
            logger.info("Set {} by property failed. using fallback.", (Object)THREAD_FACTORY_NAME);
            try {
                Field f = pool.getClass().getDeclaredField("factory");
                f.setAccessible(true);
                ReflectionUtils.setFinalField(f, pool, new DefaultForkJoinWorkerThreadFactory());
            }
            catch (Exception e) {
                logger.warn("modify factory field error", (Throwable)e);
            }
        }
    }

    public static class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        static Constructor<ForkJoinWorkerThread> forkJoinWorkerThreadConstructor = null;
        private static final AccessControlContext ACC;

        static AccessControlContext contextWithPermissions(Permission ... perms) {
            Permissions permissions = new Permissions();
            for (Permission perm : perms) {
                permissions.add(perm);
            }
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
        }

        @Override
        public final ForkJoinWorkerThread newThread(final ForkJoinPool pool) {
            return AccessController.doPrivileged(new PrivilegedAction<ForkJoinWorkerThread>(){

                @Override
                public ForkJoinWorkerThread run() {
                    try {
                        Objects.requireNonNull(forkJoinWorkerThreadConstructor);
                        return forkJoinWorkerThreadConstructor.newInstance(pool, ClassLoader.getSystemClassLoader());
                    }
                    catch (Exception e) {
                        return new RassForkJoinWorkerThread(pool);
                    }
                }
            }, ACC);
        }

        static {
            try {
                forkJoinWorkerThreadConstructor = ForkJoinWorkerThread.class.getDeclaredConstructor(ForkJoinPool.class, ClassLoader.class);
                forkJoinWorkerThreadConstructor.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ACC = DefaultForkJoinWorkerThreadFactory.contextWithPermissions(new RuntimePermission("getClassLoader"), new RuntimePermission("setContextClassLoader"));
        }
    }

    public static class RassForkJoinWorkerThread
    extends ForkJoinWorkerThread {
        public RassForkJoinWorkerThread(ForkJoinPool pool) {
            super(pool);
        }
    }
}

