/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.oozie.convert;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(JoinNodeConvert.class);

    public JoinNodeConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public JoinNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        tgtworkflowNode.setNodeType(this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.joinNodeType", CodeProgramType.VIRTUAL.getName()));
        return List.of(tgtworkflowNode);
    }

    public void buildScript(WorkflowNode node, Workflow workflow) {
        StringBuilder script = new StringBuilder();
        script.append("<Code><![CDATA[{\\&quot;branchList\\&quot;:\\&quot;[");
        for (WorkflowNode parent : workflow.getWorkflowNodes()) {
            if (parent.getChildren() == null || !parent.getChildren().contains(node)) continue;
            script.append("{\\\\\\&quot;logic\\\\\\&quot;:1,\\\\\\&quot;node\\\\\\&quot;:\\\\\\&quot;");
            script.append(parent.getNodeName() + "_to_" + node.getNodeName());
            script.append("\\\\\\&quot;,\\\\\\&quot;runStatus\\\\\\&quot;:[\\\\\\&quot;1\\\\\\&quot;]},");
        }
        script.deleteCharAt(script.length() - 1);
        script.append("]\\&quot;,\\&quot;resultStatus\\&quot;:\\&quot;1\\&quot;}]]");
        node.setScript(script.toString());
    }
}

