/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.oozie.convert;

import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConverter {
    private static final Logger log = LoggerFactory.getLogger(DefaultConverter.class);

    public WorkflowProject convertProject(WorkflowProject workflowProject) {
        WorkflowProject targetProject = (WorkflowProject)BwmJsonUtil.deepCopy((Object)workflowProject, WorkflowProject.class);
        return targetProject;
    }

    public List<Workflow> convertWorkflows(List<Workflow> workflows) {
        List<Workflow> targetWorkflowList = workflows.stream().map(this::convertWorkflow).collect(Collectors.toList());
        return targetWorkflowList;
    }

    public Workflow convertWorkflow(Workflow workflow) {
        List triggers = workflow.getTriggers();
        List<WorkflowTrigger> targetTriggers = this.convertTriggers(triggers);
        List workflowNodes = workflow.getWorkflowNodes();
        List targetNodes = workflowNodes.stream().map(this::convertNode).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toList());
        Workflow targetWorkflow = (Workflow)BwmJsonUtil.deepCopy((Object)workflow, Workflow.class);
        targetWorkflow.setTriggers(targetTriggers);
        targetWorkflow.setWorkflowNodes(targetNodes);
        return targetWorkflow;
    }

    public List<WorkflowNode> convertNode(WorkflowNode workflowNode) {
        ArrayList<WorkflowNode> targetNodes = new ArrayList<WorkflowNode>();
        WorkflowNode targetNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        targetNodes.add(targetNode);
        return targetNodes;
    }

    public List<WorkflowFileResource> convertResources(List<WorkflowFileResource> resourceList) {
        List<WorkflowFileResource> targetResourceList = ((List)Optional.ofNullable(resourceList).orElse(new ArrayList())).stream().map(this::convertResource).collect(Collectors.toList());
        return targetResourceList;
    }

    public WorkflowFileResource convertResource(WorkflowFileResource resource) {
        WorkflowFileResource workflowFileResource = (WorkflowFileResource)BwmJsonUtil.deepCopy((Object)resource, WorkflowFileResource.class);
        return workflowFileResource;
    }

    public List<WorkflowFunctionResource> convertFunctions(List<WorkflowFunctionResource> functions) {
        List<WorkflowFunctionResource> targetFunctionList = ((List)Optional.ofNullable(functions).orElse(new ArrayList())).stream().map(this::convertFunction).collect(Collectors.toList());
        return targetFunctionList;
    }

    public WorkflowFunctionResource convertFunction(WorkflowFunctionResource function) {
        WorkflowFunctionResource workflowFunctionResource = (WorkflowFunctionResource)BwmJsonUtil.deepCopy((Object)function, WorkflowFunctionResource.class);
        return workflowFunctionResource;
    }

    public List<WorkflowTrigger> convertTriggers(List<WorkflowTrigger> triggers) {
        List<WorkflowTrigger> triggerList = triggers.stream().map(this::convertTrigger).collect(Collectors.toList());
        return triggerList;
    }

    public WorkflowTrigger convertTrigger(WorkflowTrigger trigger) {
        WorkflowTrigger targetWorkflowTrigger = (WorkflowTrigger)BwmJsonUtil.deepCopy((Object)trigger, WorkflowTrigger.class);
        return targetWorkflowTrigger;
    }
}

