/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.datago.enums;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.CycleType;
import com.google.common.collect.Maps;
import java.util.Map;

public enum FrequencyTypeEnum {
    ONE_TIME("ONE_TIME"),
    QUASI("QUASI"),
    HOUR("HOUR"),
    DAY("DAY");

    private final String type;
    private static final Map<String, FrequencyTypeEnum> ALL_VALUES;

    public static FrequencyTypeEnum fromType(String type) {
        return ALL_VALUES.get(type);
    }

    private FrequencyTypeEnum(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static CycleType toCycleType(String type) {
        if (FrequencyTypeEnum.QUASI.type.equals(type) || FrequencyTypeEnum.HOUR.type.equals(type)) {
            return CycleType.NOT_DAY;
        }
        return CycleType.DAY;
    }

    static {
        ALL_VALUES = Maps.newHashMap();
        for (FrequencyTypeEnum type : FrequencyTypeEnum.values()) {
            ALL_VALUES.put(type.getType(), type);
        }
    }
}

