/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.utils.resource.matcher;

import com.aliyun.migration.teleport.common.utils.resource.antlr.PartitionFilterBaseVisitor;
import com.aliyun.migration.teleport.common.utils.resource.antlr.PartitionFilterParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;

public class PartitionVisitor
extends PartitionFilterBaseVisitor<Boolean> {
    Map<String, String> kvMap = new HashMap<String, String>();
    String partitionName;

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
        for (String kvStr : partitionName.split("/")) {
            String[] kv = kvStr.split("=");
            this.kvMap.put(kv[0], this.trimValue(kv[1]));
        }
    }

    @Override
    public Boolean visitRoot(PartitionFilterParser.RootContext ctx) {
        return (Boolean)this.visit((ParseTree)ctx.expr());
    }

    @Override
    public Boolean visitDoNothing(PartitionFilterParser.DoNothingContext ctx) {
        return (Boolean)this.visit((ParseTree)ctx.expr());
    }

    @Override
    public Boolean visitInOp(PartitionFilterParser.InOpContext ctx) {
        String partitionName = ctx.IDENTITY().getText();
        String realValue = this.kvMap.get(partitionName);
        if (Objects.isNull(realValue)) {
            return false;
        }
        return ctx.values().value().stream().anyMatch(v -> realValue.equals(this.trimValue(v.getText())));
    }

    @Override
    public Boolean visitCompareOp(PartitionFilterParser.CompareOpContext ctx) {
        String partitionName = ctx.IDENTITY().getText();
        String value = this.trimValue(ctx.value().getText());
        String compare = ctx.comparisonOperator().getText();
        String realValue = this.kvMap.get(partitionName);
        if (Objects.isNull(realValue)) {
            return false;
        }
        switch (compare) {
            case "<": {
                return realValue.compareTo(value) < 0;
            }
            case "<=": {
                return realValue.compareTo(value) <= 0;
            }
            case "=": {
                return realValue.compareTo(value) == 0;
            }
            case ">": {
                return realValue.compareTo(value) > 0;
            }
            case ">=": {
                return realValue.compareTo(value) >= 0;
            }
            case "<>": {
                return realValue.compareTo(value) != 0;
            }
        }
        return false;
    }

    @Override
    public Boolean visitLogicOp(PartitionFilterParser.LogicOpContext ctx) {
        String logicOp;
        boolean v1 = (Boolean)this.visit((ParseTree)ctx.expr(0));
        boolean v2 = (Boolean)this.visit((ParseTree)ctx.expr(1));
        switch (logicOp = ctx.op.getText().toLowerCase()) {
            case "and": {
                return v1 && v2;
            }
            case "or": {
                return v1 || v2;
            }
        }
        return false;
    }

    @Override
    public Boolean visitComparisonOperator(PartitionFilterParser.ComparisonOperatorContext ctx) {
        return (Boolean)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Boolean visitValue(PartitionFilterParser.ValueContext ctx) {
        return (Boolean)this.visitChildren((RuleNode)ctx);
    }

    private String trimValue(String value) {
        return value.replace("'", "").replace("\"", "");
    }

    @Override
    public Boolean visitRegexpOp(PartitionFilterParser.RegexpOpContext ctx) {
        String partitionName = ctx.IDENTITY().getText();
        String realValue = this.kvMap.get(partitionName);
        String text = ctx.regex().getText();
        text = text.substring(1, text.length() - 1);
        boolean matches = false;
        try {
            matches = Pattern.matches(text, realValue);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return matches;
    }
}

