/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.utils.resource;

import com.aliyun.migration.teleport.common.dto.migration.enums.MatchType;
import com.aliyun.migration.teleport.common.utils.resource.matcher.DbMatcher;
import com.aliyun.migration.teleport.common.utils.resource.matcher.PartitionMatcher;
import com.aliyun.migration.teleport.common.utils.resource.matcher.TableMatcher;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class QualifiedNameFilter {
    protected List<InnerFilter> filters = new ArrayList<InnerFilter>();

    public QualifiedNameFilter(List<String> filters) {
        for (String s : filters) {
            this.filters.add(new InnerFilter(s));
        }
    }

    public boolean filter(String schemaName, String tableName, String partitionName) {
        if (this.filters.isEmpty()) {
            return false;
        }
        return this.filters.stream().anyMatch(innerFilter -> innerFilter.filter(schemaName, tableName, partitionName));
    }

    public List<InnerFilter> getFilters() {
        return this.filters;
    }

    public static class InnerFilter {
        private static final int MAPPING_PARTS = 3;
        private String config;
        private MatchType matchType;
        private DbMatcher dbMatcher;
        private TableMatcher tableMatcher;
        private PartitionMatcher partitionMatcher;

        public InnerFilter(String config) {
            if (StringUtils.isBlank((CharSequence)config)) {
                this.matchType = MatchType.WHITE_LIST;
                this.config = null;
                this.dbMatcher = new DbMatcher(null);
                this.tableMatcher = new TableMatcher(null);
                this.partitionMatcher = new PartitionMatcher(null);
            } else {
                if (config.startsWith(MatchType.BLACK_LIST.getLabel())) {
                    this.matchType = MatchType.BLACK_LIST;
                    this.config = config.substring(1);
                } else if (config.startsWith(MatchType.WHITE_LIST.getLabel())) {
                    this.matchType = MatchType.WHITE_LIST;
                    this.config = config.substring(1);
                } else {
                    this.matchType = MatchType.WHITE_LIST;
                    this.config = config;
                }
                String[] parts = this.config.split("\\|", -1);
                if (parts.length != 3) {
                    return;
                }
                this.dbMatcher = new DbMatcher(parts[0]);
                this.tableMatcher = new TableMatcher(parts[1]);
                this.partitionMatcher = new PartitionMatcher(parts[2]);
            }
        }

        public boolean filter(String schemaName, String tableName, String partitionName) {
            if (this.config == null) {
                return false;
            }
            boolean flag = false;
            if (StringUtils.isNotBlank((CharSequence)schemaName) && StringUtils.isNotBlank((CharSequence)tableName) && StringUtils.isNotBlank((CharSequence)partitionName)) {
                flag = this.dbMatcher.isMatch(schemaName) && this.tableMatcher.isMatch(tableName) && this.partitionMatcher.isMatch(partitionName);
            } else if (StringUtils.isNotBlank((CharSequence)schemaName) && StringUtils.isNotBlank((CharSequence)tableName)) {
                flag = this.dbMatcher.isMatch(schemaName) && this.tableMatcher.isMatch(tableName);
            } else if (StringUtils.isNotBlank((CharSequence)schemaName)) {
                flag = this.dbMatcher.isMatch(schemaName);
            }
            if (this.matchType == MatchType.BLACK_LIST) {
                return flag;
            }
            return !flag;
        }

        public String getConfig() {
            return this.config;
        }

        public MatchType getMatchType() {
            return this.matchType;
        }

        public DbMatcher getDbMatcher() {
            return this.dbMatcher;
        }

        public TableMatcher getTableMatcher() {
            return this.tableMatcher;
        }

        public PartitionMatcher getPartitionMatcher() {
            return this.partitionMatcher;
        }

        public void setConfig(String config) {
            this.config = config;
        }

        public void setMatchType(MatchType matchType) {
            this.matchType = matchType;
        }

        public void setDbMatcher(DbMatcher dbMatcher) {
            this.dbMatcher = dbMatcher;
        }

        public void setTableMatcher(TableMatcher tableMatcher) {
            this.tableMatcher = tableMatcher;
        }

        public void setPartitionMatcher(PartitionMatcher partitionMatcher) {
            this.partitionMatcher = partitionMatcher;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InnerFilter)) {
                return false;
            }
            InnerFilter other = (InnerFilter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$config = this.getConfig();
            String other$config = other.getConfig();
            if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
                return false;
            }
            MatchType this$matchType = this.getMatchType();
            MatchType other$matchType = other.getMatchType();
            if (this$matchType == null ? other$matchType != null : !((Object)((Object)this$matchType)).equals((Object)other$matchType)) {
                return false;
            }
            DbMatcher this$dbMatcher = this.getDbMatcher();
            DbMatcher other$dbMatcher = other.getDbMatcher();
            if (this$dbMatcher == null ? other$dbMatcher != null : !this$dbMatcher.equals(other$dbMatcher)) {
                return false;
            }
            TableMatcher this$tableMatcher = this.getTableMatcher();
            TableMatcher other$tableMatcher = other.getTableMatcher();
            if (this$tableMatcher == null ? other$tableMatcher != null : !this$tableMatcher.equals(other$tableMatcher)) {
                return false;
            }
            PartitionMatcher this$partitionMatcher = this.getPartitionMatcher();
            PartitionMatcher other$partitionMatcher = other.getPartitionMatcher();
            return !(this$partitionMatcher == null ? other$partitionMatcher != null : !this$partitionMatcher.equals(other$partitionMatcher));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InnerFilter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $config = this.getConfig();
            result = result * 59 + ($config == null ? 43 : $config.hashCode());
            MatchType $matchType = this.getMatchType();
            result = result * 59 + ($matchType == null ? 43 : ((Object)((Object)$matchType)).hashCode());
            DbMatcher $dbMatcher = this.getDbMatcher();
            result = result * 59 + ($dbMatcher == null ? 43 : $dbMatcher.hashCode());
            TableMatcher $tableMatcher = this.getTableMatcher();
            result = result * 59 + ($tableMatcher == null ? 43 : $tableMatcher.hashCode());
            PartitionMatcher $partitionMatcher = this.getPartitionMatcher();
            result = result * 59 + ($partitionMatcher == null ? 43 : $partitionMatcher.hashCode());
            return result;
        }

        public String toString() {
            return "QualifiedNameFilter.InnerFilter(config=" + this.getConfig() + ", matchType=" + String.valueOf((Object)this.getMatchType()) + ", dbMatcher=" + String.valueOf(this.getDbMatcher()) + ", tableMatcher=" + String.valueOf(this.getTableMatcher()) + ", partitionMatcher=" + String.valueOf(this.getPartitionMatcher()) + ")";
        }
    }
}

