/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.element.meta;

import com.aliyun.migration.teleport.common.constants.TeleportMetaStatusCode;
import com.aliyun.migration.teleport.common.constants.TeleportStatusCode;
import com.aliyun.migration.teleport.common.element.BaseElement;
import com.aliyun.migration.teleport.common.exceptions.TeleportException;
import com.aliyun.migration.teleport.common.utils.Tuple;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Datasource
extends BaseElement
implements Serializable {
    private String name;
    private CategoryType categoryType;
    private Type type;
    private String version;
    private String description;
    private LocalDateTime expireTime;
    private Map<String, String> properties;
    private EndType endType;
    private ConnectionStatus status;
    private OperaterType operaterType;
    private List<String> filePath;

    public boolean isExpired() {
        return this.expireTime != null && LocalDateTime.now().isAfter(this.expireTime);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Datasource)) {
            return false;
        }
        Datasource other = (Datasource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        CategoryType this$categoryType = this.getCategoryType();
        CategoryType other$categoryType = other.getCategoryType();
        if (this$categoryType == null ? other$categoryType != null : !((Object)((Object)this$categoryType)).equals((Object)other$categoryType)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        LocalDateTime this$expireTime = this.getExpireTime();
        LocalDateTime other$expireTime = other.getExpireTime();
        if (this$expireTime == null ? other$expireTime != null : !((Object)this$expireTime).equals(other$expireTime)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        EndType this$endType = this.getEndType();
        EndType other$endType = other.getEndType();
        if (this$endType == null ? other$endType != null : !((Object)((Object)this$endType)).equals((Object)other$endType)) {
            return false;
        }
        ConnectionStatus this$status = this.getStatus();
        ConnectionStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        OperaterType this$operaterType = this.getOperaterType();
        OperaterType other$operaterType = other.getOperaterType();
        if (this$operaterType == null ? other$operaterType != null : !((Object)((Object)this$operaterType)).equals((Object)other$operaterType)) {
            return false;
        }
        List<String> this$filePath = this.getFilePath();
        List<String> other$filePath = other.getFilePath();
        return !(this$filePath == null ? other$filePath != null : !((Object)this$filePath).equals(other$filePath));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Datasource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        CategoryType $categoryType = this.getCategoryType();
        result = result * 59 + ($categoryType == null ? 43 : ((Object)((Object)$categoryType)).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        LocalDateTime $expireTime = this.getExpireTime();
        result = result * 59 + ($expireTime == null ? 43 : ((Object)$expireTime).hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        EndType $endType = this.getEndType();
        result = result * 59 + ($endType == null ? 43 : ((Object)((Object)$endType)).hashCode());
        ConnectionStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        OperaterType $operaterType = this.getOperaterType();
        result = result * 59 + ($operaterType == null ? 43 : ((Object)((Object)$operaterType)).hashCode());
        List<String> $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : ((Object)$filePath).hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public CategoryType getCategoryType() {
        return this.categoryType;
    }

    public Type getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public LocalDateTime getExpireTime() {
        return this.expireTime;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public EndType getEndType() {
        return this.endType;
    }

    public ConnectionStatus getStatus() {
        return this.status;
    }

    public OperaterType getOperaterType() {
        return this.operaterType;
    }

    public List<String> getFilePath() {
        return this.filePath;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCategoryType(CategoryType categoryType) {
        this.categoryType = categoryType;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExpireTime(LocalDateTime expireTime) {
        this.expireTime = expireTime;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setEndType(EndType endType) {
        this.endType = endType;
    }

    public void setStatus(ConnectionStatus status) {
        this.status = status;
    }

    public void setOperaterType(OperaterType operaterType) {
        this.operaterType = operaterType;
    }

    public void setFilePath(List<String> filePath) {
        this.filePath = filePath;
    }

    @Override
    public String toString() {
        return "Datasource(name=" + this.getName() + ", categoryType=" + String.valueOf((Object)this.getCategoryType()) + ", type=" + String.valueOf((Object)this.getType()) + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", expireTime=" + String.valueOf(this.getExpireTime()) + ", properties=" + String.valueOf(this.getProperties()) + ", endType=" + String.valueOf((Object)this.getEndType()) + ", status=" + String.valueOf((Object)this.getStatus()) + ", operaterType=" + String.valueOf((Object)this.getOperaterType()) + ", filePath=" + String.valueOf(this.getFilePath()) + ")";
    }

    public static enum CategoryType {
        DATASET,
        WORKFLOW,
        ENGINE;


        public static CategoryType of(String value) {
            try {
                return CategoryType.valueOf(value);
            }
            catch (Exception e) {
                throw new TeleportException((TeleportStatusCode)TeleportMetaStatusCode.DATASOURCE_PARAM_ERROR, "\u6570\u636e\u6e90\u5206\u7c7b\u9519\u8bef:" + value);
            }
        }
    }

    public static enum Type {
        Kudu(Arrays.asList(EngineType.Presto, EngineType.Impala), CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.KuduVersion),
        Hive(Arrays.asList(EngineType.MapReduce, EngineType.Tez, EngineType.Presto, EngineType.Impala), CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.HiveVersion),
        MaxCompute(CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.MaxComputeVersion),
        ClickHouse(CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.ClickHouseVersion),
        StarRocks(CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.StarRocksVersion),
        Hologres(CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.HologresVersion),
        HDFS(CategoryType.DATASET, DataStoreType.DATA_LAKE, DatasourceVersion.HDFSVersion),
        ADBPG(CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.ADBPGVersion),
        MySQL(CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.MySQLVersion),
        Doris(CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.DorisVersion),
        Oracle(CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.OracleVersion),
        PG(CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.PGVersion),
        PolarO(CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.PolarOVersion),
        PolarX(CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.PolarXVersion),
        Presto(CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.PrestoVersion),
        Impala(CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.ImpalaVersion),
        Kyuubi(CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.KyuubiVersion),
        RedShift(CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.RedShiftVersion),
        AzureSynapse(CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.AzureSynapseVersion),
        AmazonAthena(CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.AmazonAthenaVersion),
        Databricks(CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.DatabricksVersion),
        OSS(CategoryType.DATASET, DataStoreType.DATA_LAKE, DatasourceVersion.OSSVersion),
        OSS_HDFS(CategoryType.DATASET, DataStoreType.DATA_LAKE, DatasourceVersion.OSS_HDFSVersion),
        HiveMetaStore(CategoryType.DATASET, DataStoreType.METADATA, DatasourceVersion.HiveMetaStoreVersion),
        DLF(CategoryType.DATASET, DataStoreType.METADATA, DatasourceVersion.DLFVersion),
        DataLakeCompute(CategoryType.DATASET, DataStoreType.DATA_WAREHOUSE, DatasourceVersion.DataLakeComputeVersion),
        Airflow(CategoryType.WORKFLOW, DataStoreType.WORKFLOW, DatasourceVersion.AirflowVersion),
        Adf(CategoryType.WORKFLOW, DataStoreType.WORKFLOW, DatasourceVersion.Adf),
        DolphinScheduler(CategoryType.WORKFLOW, DataStoreType.WORKFLOW, DatasourceVersion.DolphinSchedulerVersion),
        Oozie(CategoryType.WORKFLOW, DataStoreType.WORKFLOW, DatasourceVersion.OozieVersion),
        Hue(CategoryType.WORKFLOW, DataStoreType.WORKFLOW, DatasourceVersion.HueVersion),
        Azkaban(CategoryType.WORKFLOW, DataStoreType.WORKFLOW, DatasourceVersion.AzkabanVersion),
        DataWorks(CategoryType.WORKFLOW, DataStoreType.WORKFLOW, DatasourceVersion.DataWorksVersion),
        DataArtsStudio(CategoryType.WORKFLOW, DataStoreType.WORKFLOW, DatasourceVersion.DataArtsStudioVersion),
        BwmSpec(CategoryType.WORKFLOW, DataStoreType.WORKFLOW, DatasourceVersion.BwmSpec),
        Custom(CategoryType.WORKFLOW, DataStoreType.WORKFLOW, DatasourceVersion.CustomVersion);

        private List<EngineType> defaultEngineList;
        private CategoryType categoryType;
        private DataStoreType dataStoreType;
        private DatasourceVersion datasourceVersion;

        private Type(CategoryType categoryType, DataStoreType dataStoreType, DatasourceVersion datasourceVersion) {
            this.categoryType = categoryType;
            this.dataStoreType = dataStoreType;
            this.datasourceVersion = datasourceVersion;
        }

        private Type(List<EngineType> engineTypeList, CategoryType categoryType, DataStoreType dataStoreType, DatasourceVersion datasourceVersion) {
            this.defaultEngineList = engineTypeList;
            this.categoryType = categoryType;
            this.dataStoreType = dataStoreType;
            this.datasourceVersion = datasourceVersion;
        }

        public static Type of(String value) {
            for (Type type : Type.values()) {
                String name = type.name().replace("_", "-");
                if (!name.equalsIgnoreCase(value)) continue;
                return type;
            }
            throw new TeleportException((TeleportStatusCode)TeleportMetaStatusCode.DATASOURCE_PARAM_ERROR, "\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b:" + value);
        }

        public static String getTypeName(Type type) {
            String name = type.name();
            return name.replace("_", "-");
        }

        public List<EngineType> getDefaultEngineList() {
            return this.defaultEngineList;
        }

        public CategoryType getCategoryType() {
            return this.categoryType;
        }

        public DataStoreType getDataStoreType() {
            return this.dataStoreType;
        }

        public DatasourceVersion getDatasourceVersion() {
            return this.datasourceVersion;
        }
    }

    public static enum EndType {
        SRC,
        DST;


        public static EndType of(Integer value) {
            if (value == null || value > EndType.values().length) {
                return null;
            }
            return EndType.values()[value];
        }
    }

    public static enum ConnectionStatus {
        FAILED(2),
        NOT_CONNECT(0),
        SUCCESS(1),
        NOT_SUPPORT(-1);

        private int value;

        private ConnectionStatus(int value) {
            this.value = value;
        }

        public static ConnectionStatus of(Integer value) {
            for (ConnectionStatus connectionStatus : ConnectionStatus.values()) {
                if (connectionStatus.getValue() != value.intValue()) continue;
                return connectionStatus;
            }
            throw new TeleportException((TeleportStatusCode)TeleportMetaStatusCode.DATASOURCE_PARAM_ERROR, "\u975e\u6cd5\u7684\u8fde\u901a\u6027\u72b6\u6001:" + value);
        }

        public static boolean isReady(int value) {
            return SUCCESS.getValue() == value || NOT_SUPPORT.getValue() == value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static enum OperaterType {
        MANUAL("manual"),
        AUTO("auto");

        private String name;

        private OperaterType(String name) {
            this.name = name;
        }

        public static OperaterType of(String name) {
            for (OperaterType type : OperaterType.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            throw new TeleportException((TeleportStatusCode)TeleportMetaStatusCode.DATASOURCE_PARAM_ERROR, "\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u64cd\u4f5c\u7c7b\u578b:" + name);
        }
    }

    public static enum DatasourceVersion {
        KuduVersion(DatasourceVersion.getDefaultVersions()),
        HiveVersion(Arrays.asList(Tuple.of("1.x", true, true), Tuple.of("2.x", true, true), Tuple.of("3.x", true, true))),
        MaxComputeVersion(DatasourceVersion.getDefaultVersions()),
        ClickHouseVersion(Arrays.asList(Tuple.of("19.15", true, true), Tuple.of("20.3", true, true), Tuple.of("20.8", true, true), Tuple.of("21.8", true, true), Tuple.of("22.8", true, true))),
        StarRocksVersion(List.of(Tuple.of("3.1.5", true, true))),
        HologresVersion(List.of(Tuple.of("11.3", true, true))),
        HDFSVersion(DatasourceVersion.getDefaultVersions()),
        ADBPGVersion(Arrays.asList(Tuple.of("6.0", true, true), Tuple.of("7.0", true, true))),
        MySQLVersion(Arrays.asList(Tuple.of("5.5", true, true), Tuple.of("5.6", true, true), Tuple.of("5.7", true, true), Tuple.of("8.0", true, true))),
        DorisVersion(Arrays.asList(Tuple.of("1.2", true, true), Tuple.of("2.0", true, true), Tuple.of("2.1", true, true))),
        OracleVersion(Arrays.asList(Tuple.of("7.0", true, true), Tuple.of("8i", true, true), Tuple.of("9i", true, true), Tuple.of("10g", true, true), Tuple.of("11g", true, true), Tuple.of("12c", true, true), Tuple.of("18c", true, true), Tuple.of("19c", true, true))),
        PGVersion(Arrays.asList(Tuple.of("11", true, true), Tuple.of("12", true, true), Tuple.of("13", true, true), Tuple.of("14", true, true), Tuple.of("15", true, true), Tuple.of("16", true, true))),
        PolarOVersion(Arrays.asList(Tuple.of("1.0", true, true), Tuple.of("2.0", true, true))),
        PolarXVersion(Arrays.asList(Tuple.of("1.0", true, true), Tuple.of("2.0", true, true))),
        PrestoVersion(List.of(Tuple.of("0.2.x", true, true))),
        ImpalaVersion(Arrays.asList(Tuple.of("3.x", true, true), Tuple.of("4.x", true, true))),
        KyuubiVersion(List.of(Tuple.of("1.x", true, true))),
        RedShiftVersion(List.of(Tuple.of("1.x", true, true))),
        AzureSynapseVersion(List.of(Tuple.of("1.x", true, true))),
        AmazonAthenaVersion(List.of(Tuple.of("1.x", true, true))),
        DatabricksVersion(Arrays.asList(Tuple.of("9.1", true, true), Tuple.of("10.4", true, true), Tuple.of("11.3", true, true), Tuple.of("12.2.", true, true), Tuple.of("13.3", true, true), Tuple.of("14.3", true, true))),
        MapReduceVersion(DatasourceVersion.getDefaultVersions()),
        TezVersion(DatasourceVersion.getDefaultVersions()),
        OSSVersion(DatasourceVersion.getDefaultVersions()),
        OSS_HDFSVersion(DatasourceVersion.getDefaultVersions()),
        HiveMetaStoreVersion(DatasourceVersion.getDefaultVersions()),
        DLFVersion(DatasourceVersion.getDefaultVersions()),
        DolphinSchedulerVersion(Arrays.asList(Tuple.of("1.3.9", true, false), Tuple.of("2.0.0", true, false), Tuple.of("3.2.0", true, true))),
        DataWorksVersion(Arrays.asList(Tuple.of("oldidea", true, true), Tuple.of("newidea", true, true))),
        AzkabanVersion(Arrays.asList(Tuple.of("3.7.1", true, false))),
        OozieVersion(Arrays.asList(Tuple.of("5.2.1", true, false))),
        AirflowVersion(Arrays.asList(Tuple.of("1.4.0", true, false))),
        HueVersion(DatasourceVersion.getDefaultVersionsSrc()),
        Adf(DatasourceVersion.getDefaultVersionsSrc()),
        DataArtsStudioVersion(DatasourceVersion.getDefaultVersionsSrc()),
        BwmSpec(DatasourceVersion.getDefaultVersionsSrc()),
        DataLakeComputeVersion(Arrays.asList(Tuple.of("2021-01-25", true, false))),
        CustomVersion(DatasourceVersion.getDefaultVersions());

        private Tuple<String, Boolean, Boolean> defaultVersion = Tuple.of("All", true, true);
        private List<Tuple<String, Boolean, Boolean>> versions = new ArrayList<Tuple<String, Boolean, Boolean>>();

        private static List<Tuple<String, Boolean, Boolean>> getDefaultVersions() {
            return List.of(Tuple.of("All", true, true));
        }

        private static List<Tuple<String, Boolean, Boolean>> getDefaultVersionsSrc() {
            return List.of(Tuple.of("All", true, false));
        }

        private static List<Tuple<String, Boolean, Boolean>> getDefaultVersionsTgt() {
            return List.of(Tuple.of("All", false, true));
        }

        private DatasourceVersion(List<Tuple<String, Boolean, Boolean>> versions) {
            this.versions = versions;
        }

        public List<String> getVersions() {
            return this.versions.stream().map(Tuple::getLeft).distinct().collect(Collectors.toList());
        }

        public List<Tuple<String, Boolean, Boolean>> getVersionAndEndType() {
            return this.versions;
        }
    }

    public static enum DataStoreType {
        DATA_WAREHOUSE,
        DATA_LAKE,
        METADATA,
        WORKFLOW;

    }

    public static enum EngineType {
        Tez(Boolean.FALSE, DatasourceVersion.MapReduceVersion),
        MapReduce(Boolean.FALSE, DatasourceVersion.TezVersion),
        Impala(Boolean.TRUE, DatasourceVersion.ImpalaVersion),
        Presto(Boolean.TRUE, DatasourceVersion.PrestoVersion),
        Kyuubi(Boolean.TRUE, DatasourceVersion.KyuubiVersion);

        private final Boolean isIndependent;
        private DatasourceVersion datasourceVersion;

        private EngineType(Boolean isIndependent) {
            this.isIndependent = isIndependent;
        }

        private EngineType(Boolean isIndependent, DatasourceVersion datasourceVersion) {
            this.isIndependent = isIndependent;
            this.datasourceVersion = datasourceVersion;
        }

        public Boolean getIsIndependent() {
            return this.isIndependent;
        }

        public DatasourceVersion getDatasourceVersion() {
            return this.datasourceVersion;
        }
    }
}

